/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.pojo;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.scmc.ccm.business.pojo.CreditElement;
import kd.scmc.ccm.business.pojo.Field;

public class EntityConfig
implements Serializable {
    private String entityKey;
    private Field orgField;
    private Field currencyField;
    private Map<String, Field> creditRolesKeyMap = new HashMap<String, Field>();
    private Map<CreditElement, Field> elementFieldRelation = new HashMap<CreditElement, Field>();
    private Set<String> selectors = new HashSet<String>();

    public static EntityConfig doCreate(String entityKey) {
        EntityConfig entityConfig = new EntityConfig();
        entityConfig.setEntityKey(entityKey);
        return entityConfig;
    }

    public Field getRoleField(String roleType) {
        return this.creditRolesKeyMap.get(roleType);
    }

    public Map<String, Field> getCreditRolesKeyMap() {
        return this.creditRolesKeyMap;
    }

    public String getEntityKey() {
        return this.entityKey;
    }

    public void setEntityKey(String entityKey) {
        this.entityKey = entityKey;
    }

    public Field getOrgField() {
        return this.orgField;
    }

    public Field getCurrencyField() {
        return this.currencyField;
    }

    public Set<String> getSelectors() {
        return this.selectors;
    }

    public void setSelectors(Set<String> selectors) {
        this.selectors = selectors;
    }

    public void setField(CreditElement element, Field field) {
        this.elementFieldRelation.put(element, field);
        if (element.getType() == CreditElement.ElementType.ROLE) {
            this.creditRolesKeyMap.put(element.getNumber(), field);
        } else if (element.getType() == CreditElement.ElementType.ORG) {
            this.orgField = field;
        } else if (element.getType() == CreditElement.ElementType.CURRENCY) {
            this.currencyField = field;
        }
    }

    public Field getField(CreditElement element) {
        return this.elementFieldRelation.get(element);
    }

    public String toString() {
        return "EntityConfig{entityKey='" + this.entityKey + '\'' + ", orgField=" + this.orgField + ", currencyField=" + this.currencyField + ", creditRolesKeyMap=" + this.creditRolesKeyMap + ", elementFieldRelation=" + this.elementFieldRelation + ", selectors=" + this.selectors + '}';
    }
}

