/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.pojo;

import java.io.Serializable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.scmc.ccm.business.helper.MetaDataHelper;

public class Field
implements Serializable {
    private String key;
    private String refProp;
    private String entryKey;
    private String fullName;

    public Field() {
    }

    public Field(String fieldKey, MainEntityType dataEntityType) {
        this.fullName = fieldKey;
        String[] split = fieldKey.split("[.]");
        if (split.length > 3) {
            throw new KDBizException("Field setting error:field=" + fieldKey);
        }
        for (int i = 0; i < split.length; ++i) {
            if (i == 0) {
                String entryKey = MetaDataHelper.getEntryKey(dataEntityType, split[i]);
                if (entryKey != null) {
                    this.entryKey = entryKey;
                }
                this.key = split[i];
                continue;
            }
            if (i == 1) {
                if (this.key == null) {
                    this.key = split[i];
                    continue;
                }
                this.refProp = split[i];
                continue;
            }
            this.refProp = split[i];
        }
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getEntryKey() {
        return this.entryKey;
    }

    public void setEntryKey(String entryKey) {
        this.entryKey = entryKey;
    }

    public String getRefProp() {
        return this.refProp;
    }

    public void setRefProp(String refProp) {
        this.refProp = refProp;
    }

    public String getFullName() {
        return this.fullName;
    }

    public Object getValue(DynamicObject source) {
        if (this.entryKey == null && source.getDataEntityType() instanceof EntryType) {
            DynamicObject parent = (DynamicObject)source.getParent();
            if (this.refProp == null) {
                return parent.get(this.key);
            }
            return parent.get(this.key + "." + this.refProp);
        }
        if (this.refProp == null) {
            return source.get(this.key);
        }
        return source.get(this.key + "." + this.refProp);
    }

    public String toString() {
        return "{key='" + this.key + '\'' + ", refProp='" + this.refProp + '\'' + ", entryKey='" + this.entryKey + '\'' + ", fullName='" + this.fullName + '\'' + '}';
    }
}

