/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.pojo.log;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.scmc.ccm.common.util.CreditContext;

public class CreditLogCollectInfo
implements Serializable {
    private static final Log logger = LogFactory.getLog(CreditLogCollectInfo.class);
    private Long id;
    private Date datetime;
    private Long user;
    private String traceid;
    private String logdetail;
    private String logdetail_tag;
    private Map<String, Object> logCollection;
    private Long billid;
    private List<Long> billentryid;
    private List<Long> billseq;
    private String creditbill;
    private String creditno;
    private String creditop;
    private String bizexpdesc;
    private static final String DELETESQL = "DELETE FROM T_CCM_CREDITANALYSISLOG WHERE  FBILLID=?";
    private static final String UPDATESQL = "UPDATE T_CCM_CREDITANALYSISLOG  SET  FLOGDETAIL=?,FLOGDETAIL_TAG=?  WHERE  FID=?";
    private static final String INSERTSQL = "INSERT INTO T_CCM_CREDITANALYSISLOG (FID,FCREDITBILL,FCREDITOP,FTRACEID,FUSERID,FDATETIME,FLOGDETAIL,FLOGDETAIL_TAG,FCREDITBILLNO_TAG,FCREDITBILLNO) VALUES(?,?,?,?,?,?,?,?,?,?)";
    private static final String WRITESQL = "UPDATE T_CCM_CREDITANALYSISLOG SET FLOGDETAIL_TAG=?,FBIZEXPDESC=?  WHERE  FID=?";
    public static final String CREDITSCHEME = "creditscheme";
    public static final String CREDITJOURNAL = "creditjournal";
    public static final String ARCHIVE_BEFORE = "archive_before";
    public static final String ARCHIVE_AFTER = "archive_after";
    public static final String NOGETCREDITLOCK = "nogetcreditlock";

    private CreditLogCollectInfo(String creditbill, String creditop, Set<String> billNoList) {
        this.creditbill = creditbill;
        this.creditop = creditop;
        long[] pkId = DBServiceHelper.genLongIds((String)"T_CCM_CREDITANALYSISLOG", (int)1);
        this.id = pkId[0];
        this.logCollection = new LinkedHashMap<String, Object>(16);
        this.createCreditLogInfo(creditbill, creditop, billNoList);
    }

    private CreditLogCollectInfo() {
        long[] pkId = DBServiceHelper.genLongIds((String)"T_CCM_CREDITANALYSISLOG", (int)1);
        this.id = pkId[0];
        this.createCreditLogInfo("", "", new HashSet<String>(16));
    }

    public static CreditLogCollectInfo doCreate(String creditbill, String creditop, Set<String> billNoList) {
        return new CreditLogCollectInfo(creditbill, creditop, billNoList);
    }

    private Boolean getIsWriteLog() {
        AppParam appParam = new AppParam("0N6JIY2ETSPF", "03", Long.valueOf(RequestContext.get().getOrgId()), Long.valueOf(0L));
        Map pmAppParameterMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        if (pmAppParameterMap == null) {
            return null;
        }
        return (Boolean)pmAppParameterMap.get("iswritelog");
    }

    private void createCreditLogInfo(String creditbill, String creditop, Set<String> billNoList) {
        this.logdetail_tag = ResManager.loadKDString((String)"**\u4fe1\u7528\u63a7\u5236\u8be6\u60c5**", (String)"CreditLogCollectInfo_3", (String)"scmc-ccm", (Object[])new Object[0]);
        this.logdetail = ResManager.loadKDString((String)"**\u4fe1\u7528\u63a7\u5236\u8be6\u60c5**", (String)"CreditLogCollectInfo_3", (String)"scmc-ccm", (Object[])new Object[0]);
        ThreadPools.executeOnce((String)"create creditLogInfo", () -> {
            if (this.getIsWriteLog() == Boolean.FALSE) {
                return;
            }
            try (TXHandle h = TX.requiresNew((String)"creditLogInfoList");){
                try {
                    Object[] obj = new Object[10];
                    obj[0] = this.id;
                    obj[1] = creditbill;
                    obj[2] = creditop;
                    obj[3] = RequestContext.get().getTraceId();
                    obj[4] = UserServiceHelper.getCurrentUserId();
                    obj[5] = TimeServiceHelper.now();
                    obj[6] = this.logdetail;
                    obj[7] = this.logdetail_tag;
                    if (billNoList.size() > 0) {
                        obj[8] = SerializationUtils.toJsonString((Object)billNoList);
                        obj[9] = ResManager.loadKDString((String)"\u5b58\u5728", (String)"CreditLogCollectInfo_0", (String)"scmc-ccm", (Object[])new Object[0]);
                    } else {
                        obj[8] = "";
                        obj[9] = ResManager.loadKDString((String)"\u672a\u5b58\u5728", (String)"CreditLogCollectInfo_1", (String)"scmc-ccm", (Object[])new Object[0]);
                    }
                    DB.execute((DBRoute)DBRoute.of((String)"SCM"), (String)INSERTSQL, (Object[])obj);
                    logger.info("\u4fe1\u63a7\u65e5\u5fd7\u4fdd\u5b58\u7ed3\u675f\u2026\u2026");
                }
                catch (Exception kde) {
                    logger.error("\u4fe1\u63a7\u65e5\u5fd7\u4fdd\u5b58\u5f02\u5e38\uff1a{}", (Object)kde.getMessage().concat(Arrays.toString(kde.getStackTrace())));
                    h.markRollback();
                }
            }
        });
    }

    public void updateCreditLogInfo(String logdetailparameter, String logdetail_tagparameter) {
        ThreadPools.executeOnce((String)"update creditLogInfo", () -> {
            if (this.getIsWriteLog() == Boolean.FALSE) {
                return;
            }
            try (TXHandle h = TX.requiresNew((String)"creditLogInfoList");){
                try {
                    Object[] obj = new Object[]{logdetailparameter, logdetail_tagparameter, this.id};
                    DB.execute((DBRoute)DBRoute.of((String)"SCM"), (String)UPDATESQL, (Object[])obj);
                    logger.info("\u4fe1\u63a7\u65e5\u5fd7\u4fdd\u5b58\u7ed3\u675f\u2026\u2026");
                }
                catch (Exception kde) {
                    logger.error("\u4fe1\u63a7\u65e5\u5fd7\u4fdd\u5b58\u5f02\u5e38\uff1a{}", (Object)kde.getMessage().concat(Arrays.toString(kde.getStackTrace())));
                    h.markRollback();
                }
            }
        });
    }

    public static void writeCreditLog() {
        CreditContext txt = CreditContext.get();
        if (txt == null) {
            return;
        }
        CreditLogCollectInfo logInfo = txt.getLogInfo();
        if (logInfo == null) {
            return;
        }
        logInfo.writeCreditLogInfo();
    }

    public static void writeExpCreditLog(String logdetailparameter, String logdetail_tagparameter) {
        CreditContext txt = CreditContext.get();
        if (txt == null) {
            return;
        }
        CreditLogCollectInfo logInfo = txt.getLogInfo();
        if (logInfo == null) {
            logInfo = new CreditLogCollectInfo();
        } else {
            Map<String, Object> logCollection = logInfo.getLogCollection();
            if (logCollection != null) {
                logCollection.clear();
                logCollection = null;
            }
        }
        logInfo.updateCreditLogInfo(logdetailparameter, logdetail_tagparameter);
    }

    public static void collectCreditLogInfo(String theme, Object parameter) {
        CreditContext txt = CreditContext.get();
        if (txt == null) {
            return;
        }
        CreditLogCollectInfo logInfo = txt.getLogInfo();
        if (logInfo == null) {
            return;
        }
        if (logInfo.getLogCollection() != null) {
            logInfo.getLogCollection().put(theme, parameter);
        }
    }

    public static void collectCreditLogInfo(String bizexpdesc) {
        CreditContext txt = CreditContext.get();
        if (txt == null) {
            return;
        }
        CreditLogCollectInfo logInfo = txt.getLogInfo();
        if (logInfo == null) {
            return;
        }
        logInfo.setBizexpdesc(bizexpdesc);
    }

    public void writeCreditLogInfo() {
        ThreadPools.executeOnce((String)"update creditLogInfo", () -> {
            if (this.getIsWriteLog() == Boolean.FALSE) {
                return;
            }
            try (TXHandle h = TX.requiresNew((String)"creditLogInfoList");){
                try {
                    if (this.logCollection != null && this.logCollection.size() > 0) {
                        this.logdetail_tag = this.logCollection.toString();
                    }
                    Object[] obj = new Object[]{this.logdetail_tag, this.bizexpdesc != null && !"".equals(this.bizexpdesc) ? this.bizexpdesc : ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f", (String)"CreditLogCollectInfo_2", (String)"scmc-ccm", (Object[])new Object[0]), this.id};
                    DB.execute((DBRoute)DBRoute.of((String)"SCM"), (String)WRITESQL, (Object[])obj);
                    logger.info("\u4fe1\u63a7\u65e5\u5fd7\u4fdd\u5b58\u7ed3\u675f\u2026\u2026");
                }
                catch (Exception kde) {
                    logger.error("\u4fe1\u63a7\u65e5\u5fd7\u4fdd\u5b58\u5f02\u5e38\uff1a{}", (Object)kde.getMessage().concat(Arrays.toString(kde.getStackTrace())));
                    h.markRollback();
                }
            }
            catch (Exception exp) {
                logger.error("\u4fe1\u63a7\u65e5\u5fd7\u4fdd\u5b58\u5f02\u5e38\uff1a{}", (Object)exp.getMessage().concat(Arrays.toString(exp.getStackTrace())));
            }
        });
    }

    public Long getId() {
        return this.id;
    }

    public Date getDatetime() {
        return this.datetime;
    }

    public Long getUser() {
        return this.user;
    }

    public String getTraceid() {
        return this.traceid;
    }

    public String getLogdetail() {
        return this.logdetail;
    }

    public String getLogdetail_tag() {
        return this.logdetail_tag;
    }

    public Long getBillid() {
        return this.billid;
    }

    public String getCreditbill() {
        return this.creditbill;
    }

    public String getCreditno() {
        return this.creditno;
    }

    public String getCreditop() {
        return this.creditop;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setDatetime(Date datetime) {
        this.datetime = datetime;
    }

    public void setUser(Long user) {
        this.user = user;
    }

    public void setTraceid(String traceid) {
        this.traceid = traceid;
    }

    public void setLogdetail(String logdetail) {
        this.logdetail = logdetail;
    }

    public void setLogdetail_tag(String logdetail_tag) {
        this.logdetail_tag = logdetail_tag;
    }

    public void setBillid(Long billid) {
        this.billid = billid;
    }

    public List<Long> getBillentryid() {
        return this.billentryid;
    }

    public void setBillentryid(List<Long> billentryid) {
        this.billentryid = billentryid;
    }

    public List<Long> getBillseq() {
        return this.billseq;
    }

    public void setBillseq(List<Long> billseq) {
        this.billseq = billseq;
    }

    public void setCreditbill(String creditbill) {
        this.creditbill = creditbill;
    }

    public void setCreditno(String creditno) {
        this.creditno = creditno;
    }

    public void setCreditop(String creditop) {
        this.creditop = creditop;
    }

    public Map<String, Object> getLogCollection() {
        return this.logCollection;
    }

    public void setLogCollection(Map<String, Object> logCollection) {
        this.logCollection = logCollection;
    }

    public String getBizexpdesc() {
        return this.bizexpdesc;
    }

    public void setBizexpdesc(String bizexpdesc) {
        this.bizexpdesc = bizexpdesc;
    }

    public String toString() {
        return "{id=" + this.id + ", datetime=" + this.datetime + ", user=" + this.user + ", traceid='" + this.traceid + '\'' + ", logdetail='" + this.logdetail + '\'' + ", billid=" + this.billid + ", billentryid=" + this.billentryid + ", billseq=" + this.billseq + ", creditbill='" + this.creditbill + '\'' + ", creditno='" + this.creditno + '\'' + ", creditop='" + this.creditop + '\'' + ", bizexpdesc='" + this.bizexpdesc + '\'' + '}';
    }
}

