/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.prefilter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.scmc.ccm.business.helper.MetaDataHelper;
import kd.scmc.ccm.business.pojo.Field;
import kd.scmc.ccm.business.pojo.exprfilter.CreditCondition;
import kd.scmc.ccm.business.pojo.exprfilter.CreditFormula;
import kd.scmc.ccm.business.prefilter.BillFilter;

public class BillConditionFilter
implements BillFilter {
    private static final Log logger = LogFactory.getLog(BillConditionFilter.class);
    private CRCondition condition;

    public BillConditionFilter(CreditCondition condition) {
        if (condition != null) {
            this.condition = condition.getCondition();
        }
    }

    @Override
    public boolean isBillMatch(DynamicObject bill) {
        if (this.condition == null) {
            return true;
        }
        String entrykey = this.getEntryKey(bill);
        if (entrykey != null) {
            DynamicObjectCollection entry = bill.getDynamicObjectCollection(entrykey);
            for (DynamicObject row : entry) {
                if (!this.isRowMatch(row)) continue;
                return true;
            }
            return false;
        }
        return this.isMatch(bill, null);
    }

    @Override
    public boolean isRowMatch(DynamicObject row) {
        if (this.condition == null) {
            return true;
        }
        return this.isMatch((DynamicObject)row.getParent(), row);
    }

    private boolean isMatch(DynamicObject bill, DynamicObject row) {
        String fullFormula = this.condition.buildFullFormula((MainEntityType)bill.getDataEntityType());
        if (StringUtils.isEmpty((String)fullFormula)) {
            return true;
        }
        try {
            String[] vars = FormulaEngine.extractVariables((String)fullFormula);
            IDataEntityType dataEntityType = bill.getDataEntityType();
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            for (String fieldName : vars) {
                Object fieldValue;
                String entrykey = MetaDataHelper.getEntryKey((MainEntityType)dataEntityType, fieldName);
                Object object = fieldValue = entrykey == null || row == null ? bill.get(fieldName) : row.get(fieldName);
                if (fieldValue instanceof ILocaleString) {
                    fieldValue = ((ILocaleString)fieldValue).getLocaleValue();
                }
                params.put(fieldName, fieldValue);
            }
            boolean match = (Boolean)FormulaEngine.execExcelFormula((String)fullFormula, params);
            return match;
        }
        catch (Exception e) {
            String expMsg = e.getMessage().concat(Arrays.toString(e.getStackTrace()));
            logger.error("match  fullformula:{}  occur exception:{}", (Object)fullFormula, (Object)expMsg);
            throw new KDBizException(String.format("match  fullformula:%1$s  occur exception:%2$s", fullFormula, expMsg));
        }
    }

    private String getEntryKey(DynamicObject bill) {
        List filterRows = this.condition.getFilterCondition().getFilterRow();
        String entrykey = null;
        for (int i = 0; i < filterRows.size(); ++i) {
            SimpleFilterRow row = (SimpleFilterRow)filterRows.get(i);
            String fieldName = row.getFieldName();
            entrykey = MetaDataHelper.getEntryKey((MainEntityType)bill.getDataEntityType(), fieldName);
            if (entrykey == null) continue;
            return entrykey;
        }
        String expression = this.condition.getExpression();
        CreditFormula creditFormula = new CreditFormula(bill.getDataEntityType().getName(), expression);
        List<Field> fields = creditFormula.getFields();
        for (Field field : fields) {
            entrykey = field.getEntryKey();
            if (entrykey == null) continue;
            return entrykey;
        }
        return entrykey;
    }
}

