/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.prefilter;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.ccm.business.pojo.exprfilter.Expression;
import kd.scmc.ccm.business.prefilter.BillFilter;

public class BillMultiConditionFilter
implements BillFilter {
    private List<BillFilter> filterChain;

    public BillMultiConditionFilter(List<Expression> expressions) {
        this.filterChain = new ArrayList<BillFilter>(expressions.size());
        for (Expression expression : expressions) {
            this.filterChain.add(expression.getFilter());
        }
    }

    @Override
    public boolean isBillMatch(DynamicObject bill) {
        for (BillFilter filter : this.filterChain) {
            if (!filter.isBillMatch(bill)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isRowMatch(DynamicObject row) {
        for (BillFilter filter : this.filterChain) {
            if (!filter.isRowMatch(row)) continue;
            return true;
        }
        return false;
    }
}

