/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.prefilter;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntryType;
import kd.bos.exception.KDBizException;
import kd.scmc.ccm.business.pojo.CreditScheme;
import kd.scmc.ccm.business.pojo.Field;
import kd.scmc.ccm.business.prefilter.BillFilter;

public class CreditOrgBillFilter
implements BillFilter {
    private Field orgField;
    private CreditScheme scheme;

    public CreditOrgBillFilter(CreditScheme scheme, Field orgField) {
        this.scheme = scheme;
        this.orgField = orgField;
    }

    @Override
    public boolean isBillMatch(DynamicObject bill) {
        if (this.orgField.getEntryKey() != null) {
            DynamicObjectCollection entry = bill.getDynamicObjectCollection(this.orgField.getEntryKey());
            for (DynamicObject row : entry) {
                Object org = row.get(this.orgField.getKey());
                if (!this.isOrgMatch(org, this.scheme)) continue;
                return true;
            }
            return false;
        }
        Object org = bill.get(this.orgField.getKey());
        return this.isOrgMatch(org, this.scheme);
    }

    @Override
    public boolean isRowMatch(DynamicObject row) {
        if (this.orgField.getEntryKey() != null) {
            Object org = row.get(this.orgField.getKey());
            return this.isOrgMatch(org, this.scheme);
        }
        DynamicObject bill = (DynamicObject)row.getParent();
        Object org = bill.get(this.orgField.getKey());
        return this.isOrgMatch(org, this.scheme);
    }

    public boolean isMatch(DynamicObject obj, CreditScheme scheme) {
        if (obj.getDataEntityType() instanceof EntryType) {
            if (this.orgField.getEntryKey() != null) {
                Object org = obj.get(this.orgField.getKey());
                return this.isOrgMatch(org, scheme);
            }
            DynamicObject bill = (DynamicObject)obj.getParent();
            Object org = bill.get(this.orgField.getKey());
            return this.isOrgMatch(org, scheme);
        }
        if (this.orgField.getEntryKey() != null) {
            DynamicObjectCollection entry = obj.getDynamicObjectCollection(this.orgField.getEntryKey());
            for (DynamicObject row : entry) {
                Object org = row.get(this.orgField.getKey());
                if (!this.isOrgMatch(org, scheme)) continue;
                return true;
            }
            return false;
        }
        Object org = obj.get(this.orgField.getKey());
        return this.isOrgMatch(org, scheme);
    }

    private boolean isOrgMatch(Object org, CreditScheme scheme) {
        if (org == null) {
            return false;
        }
        if (!(org instanceof DynamicObject) && !(org instanceof Long)) {
            throw new KDBizException("unsupport org match datatype error:field=" + this.orgField.getKey());
        }
        Object orgPk = org instanceof DynamicObject ? ((DynamicObject)org).getPkValue() : org;
        String orgScope = scheme.getOrgscope();
        if ("GLOBAL".equals(orgScope)) {
            return true;
        }
        if ("SINGLE".equals(orgScope)) {
            List<Long> orgScopes = scheme.getOrgScopes();
            return orgScopes.contains(orgPk);
        }
        return false;
    }
}

