/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.prefilter;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.ccm.business.pojo.CreditScheme;
import kd.scmc.ccm.business.pojo.EntityConfig;
import kd.scmc.ccm.business.pojo.Field;
import kd.scmc.ccm.business.pojo.exprfilter.Expression;
import kd.scmc.ccm.business.prefilter.BillFilter;
import kd.scmc.ccm.business.prefilter.BillMultiConditionFilter;
import kd.scmc.ccm.business.prefilter.CreditCurrencyBillFilter;
import kd.scmc.ccm.business.prefilter.CreditOrgBillFilter;
import kd.scmc.ccm.common.util.CreditContext;

public class SchemeFilter
implements BillFilter {
    private CreditScheme scheme;
    private CreditContext context;
    private List<BillFilter> filterChain = new ArrayList<BillFilter>();

    public SchemeFilter(CreditScheme scheme, CreditContext context) {
        this.context = context;
        this.scheme = scheme;
        this.initFilterChain();
    }

    @Override
    public boolean isBillMatch(DynamicObject bill) {
        for (BillFilter filter : this.filterChain) {
            if (filter.isBillMatch(bill)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isRowMatch(DynamicObject row) {
        for (BillFilter filter : this.filterChain) {
            if (filter.isRowMatch(row)) continue;
            return false;
        }
        return true;
    }

    private void initFilterChain() {
        EntityConfig config = this.scheme.getEntityConfig(this.context);
        Field orgField = config.getOrgField();
        CreditOrgBillFilter orgFilter = new CreditOrgBillFilter(this.scheme, orgField);
        this.filterChain.add(orgFilter);
        Field currencyField = config.getCurrencyField();
        CreditCurrencyBillFilter creditCurrencyFilter = new CreditCurrencyBillFilter(this.scheme, currencyField);
        this.filterChain.add(creditCurrencyFilter);
        List<Expression> expressions = this.scheme.getExpressions(this.context);
        BillMultiConditionFilter billMultiConditionFilter = new BillMultiConditionFilter(expressions);
        this.filterChain.add(billMultiConditionFilter);
    }
}

