/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.service;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.scmc.ccm.business.helper.MetaDataHelper;
import kd.scmc.ccm.business.pojo.CheckResult;
import kd.scmc.ccm.business.pojo.log.CreditLogCollectInfo;
import kd.scmc.ccm.business.service.ICreditService;

public abstract class AbstractCreditService
implements ICreditService,
AutoCloseable {
    public DynamicObject[] bills;
    public String opKey;

    public AbstractCreditService(DynamicObject[] bills, String opKey) {
        this.bills = bills;
        this.opKey = opKey;
    }

    public List<Map<String, Object>> convertResult(List<CheckResult> results) {
        return (List)JSON.toJSON(results);
    }

    public String collectBizBillNo() {
        String entityKey = this.bills[0].getDataEntityType().getName();
        DynamicProperty billnoProperty = MetaDataHelper.getProperty(entityKey, "billno");
        String bizBillNo = "$$";
        if (billnoProperty != null) {
            bizBillNo = this.bills[0].getString("billno");
        }
        return bizBillNo;
    }

    public void collectExpLog(Exception exp) {
        String mainExpMsg = exp.toString();
        String expMsg = mainExpMsg.concat(Arrays.toString(exp.getStackTrace()));
        CreditLogCollectInfo.writeExpCreditLog(mainExpMsg, expMsg);
    }

    public void collectCheckExpResult(List<CheckResult> resultList, String mainExpMsg) {
        CheckResult result = new CheckResult(false, "error", String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u201c%1$s\u201d\u5728\u8c03\u7528\u4fe1\u63a7\u68c0\u67e5\u65f6\u5b58\u5728\u5f02\u5e38\uff1a%2$s\u3002", (String)"AbstractCreditService_0", (String)"scmc-ccm", (Object[])new Object[0]), this.opKey, mainExpMsg));
        result.setBillno(this.collectBizBillNo());
        resultList.add(result);
    }

    public void collectUpdateExpResult(List<CheckResult> resultList, String mainExpMsg) {
        CheckResult result = new CheckResult(false, "error", String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u201c%1$s\u201d\u5728\u8c03\u7528\u4fe1\u63a7\u66f4\u65b0\u65f6\u5b58\u5728\u5f02\u5e38\uff1a%2$s\u3002", (String)"AbstractCreditService_1", (String)"scmc-ccm", (Object[])new Object[0]), this.opKey, mainExpMsg));
        result.setBillno(this.collectBizBillNo());
        resultList.add(result);
    }
}

