/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.service;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.audit.Audit;
import kd.bos.audit.Auditable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scmc.ccm.business.CreditServiceFactory;
import kd.scmc.ccm.business.pojo.CheckResult;
import kd.scmc.ccm.business.pojo.CreditScheme;
import kd.scmc.ccm.business.pojo.journal.JournalGroup;
import kd.scmc.ccm.business.service.AbstractCreditService;
import kd.scmc.ccm.business.service.applylock.ICreditSyncApplyService;
import kd.scmc.ccm.business.service.archive.ArchiveCollection;
import kd.scmc.ccm.business.service.archive.ICreditArchiveService;
import kd.scmc.ccm.business.service.checkexecutor.CreditChecker;
import kd.scmc.ccm.business.service.journal.CreditJournalCreateServiceImpl;
import kd.scmc.ccm.business.service.scheme.ICreditSchemeService;
import kd.scmc.ccm.common.util.CreditContext;

public class CreditCheckServiceImpl
extends AbstractCreditService {
    private static final Log logger = LogFactory.getLog(CreditCheckServiceImpl.class);
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern(TimeServiceHelper.getDateTimeFormatString());
    private ICreditSchemeService schemeService;
    private ICreditSyncApplyService creditSyncLockService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map<String, Object>> invokeMicroService() {
        logger.info("ccm--\u300bcheck function start time:{}", (Object)formatter.format(LocalDateTime.now()));
        CreditContext txt = CreditContext.create(this.bills[0].getDataEntityType().getName(), this.opKey, "CHECK");
        LinkedList<CheckResult> resultList = new LinkedList<CheckResult>();
        List<DynamicObject> billList = Arrays.asList(this.bills);
        try (TXHandle tx = TX.required();){
            try {
                List<CreditScheme> effectiveCreditSchemeList = this.schemeService.getEffectiveCreditSchemeList();
                this.treatImBills();
                for (CreditScheme creditScheme : effectiveCreditSchemeList) {
                    List<JournalGroup> journalGroupList = CreditJournalCreateServiceImpl.doCreate(creditScheme, txt).buildJournals(billList);
                    if (journalGroupList == null || journalGroupList.size() < 1) continue;
                    ICreditArchiveService creditArchiveService = CreditServiceFactory.doCreateCreditArchiveService();
                    ArchiveCollection archiveMap = creditArchiveService.queryArchives(creditScheme, journalGroupList);
                    List<CheckResult> validateResult = creditArchiveService.validateArchives(archiveMap, journalGroupList);
                    resultList.addAll(validateResult);
                    if (archiveMap == null || archiveMap.isEmpty()) continue;
                    List<CheckResult> lockCheckResultList = this.creditSyncLockService.tryApplyUpdate(journalGroupList);
                    List<CheckResult> checkResultList = this.check(journalGroupList, archiveMap, creditScheme);
                    List eachResult = Stream.of(lockCheckResultList, checkResultList).flatMap(Collection::stream).collect(Collectors.toList());
                    resultList.addAll(eachResult);
                }
            }
            catch (Exception exp) {
                logger.error("\u4fe1\u63a7\u64cd\u4f5c\uff1a{} \u4e8echeck\u670d\u52a1\u4e2d\u5b58\u5728\u5f02\u5e38\uff1a{}", (Object)this.opKey, (Object)exp);
                this.collectExpLog(exp);
                this.collectCheckExpResult(resultList, exp.toString());
                tx.markRollback();
            }
            finally {
                this.creditSyncLockService.releaseApplyUpdate();
            }
        }
        logger.info("ccm--\u300bcheck function end time:{},result size:{}", (Object)formatter.format(LocalDateTime.now()), (Object)resultList.size());
        return this.convertResult(resultList);
    }

    private List<CheckResult> check(List<JournalGroup> journalGroups, ArchiveCollection archives, CreditScheme creditScheme) {
        try (Auditable audit = Audit.audit((String)"ccm.check", (Object[])new Object[0]);){
            ArrayList<CheckResult> results = new ArrayList<CheckResult>(journalGroups.size());
            String quotaType = creditScheme.getQuotaType().getQuotaType();
            CreditChecker creditChecker = CreditServiceFactory.doCreateCreditChecker(quotaType);
            logger.info("\u4fe1\u63a7\u65b9\u6848:{},\u68c0\u67e5\u5f62\u5f0f:{}", (Object)creditScheme.getName(), (Object)quotaType);
            for (JournalGroup bill : journalGroups) {
                results.add(creditChecker.check(bill, archives));
            }
            ArrayList<CheckResult> arrayList = results;
            return arrayList;
        }
    }

    public CreditCheckServiceImpl(DynamicObject[] bills, String opKey) {
        super(bills, opKey);
        this.schemeService = CreditServiceFactory.doCreateEffectiveCreditScheme(this.bills);
        this.creditSyncLockService = CreditServiceFactory.doCreateCreditSyncApplyService();
    }

    @Override
    public void close() throws Exception {
        if (this.schemeService != null) {
            this.schemeService.close();
        }
        if (this.creditSyncLockService != null) {
            this.creditSyncLockService.close();
            this.creditSyncLockService = null;
        }
    }

    private void treatImBills() {
        HashMap<String, Set<String>> needInverseColumnsColumnsMap = new HashMap<String, Set<String>>(16);
        for (DynamicObject bill : this.bills) {
            Set<String> ccmEntityConfigColumns;
            if (!bill.getDataEntityType().getName().contains("im_") || !bill.containsProperty("invscheme") || !bill.containsProperty("ischargeoff")) continue;
            String billEntity = bill.getDataEntityType().getName();
            Boolean isChargeOff = bill.getBoolean("ischargeoff");
            DynamicObject invScheme = bill.getDynamicObject("invscheme");
            if (invScheme == null || !invScheme.containsProperty("bizdirection") || invScheme.getString("bizdirection") == null) continue;
            String bizDirection = invScheme.getString("bizdirection");
            boolean isNeedInverse = false;
            if (!isChargeOff.booleanValue() && "1".equals(bizDirection) || isChargeOff.booleanValue() && "0".equals(bizDirection)) {
                isNeedInverse = true;
            }
            if ((ccmEntityConfigColumns = (Set<String>)needInverseColumnsColumnsMap.get(billEntity)) == null) {
                ccmEntityConfigColumns = this.getEntityConfigColumns(billEntity);
                Set<String> imNeedInverseColumns = this.getImNeedInverseColumns(billEntity);
                ccmEntityConfigColumns.retainAll(imNeedInverseColumns);
                needInverseColumnsColumnsMap.put(billEntity, ccmEntityConfigColumns);
            }
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entrys) {
                for (String column : ccmEntityConfigColumns) {
                    BigDecimal value = entry.getBigDecimal(column);
                    if (value == null) {
                        value = BigDecimal.ZERO;
                    }
                    value = isNeedInverse ? value.abs().negate() : value.abs();
                    entry.set(column, (Object)value);
                }
            }
        }
    }

    private Set<String> getEntityConfigColumns(String entityKey) {
        HashSet<String> selectors = new HashSet<String>();
        DynamicObject entityConfig = BusinessDataServiceHelper.loadSingleFromCache((Object)entityKey, (String)"ccm_entityconfig");
        if (entityConfig == null) {
            return selectors;
        }
        DynamicObjectCollection selectorEntry = entityConfig.getDynamicObjectCollection("selectors");
        for (DynamicObject selectorRow : selectorEntry) {
            selectors.add(selectorRow.getString("field"));
        }
        selectors.add("billno");
        return selectors;
    }

    private Set<String> getImNeedInverseColumns(String billEntity) {
        Map<String, Map<String, Object>> settingMap = this.getColumnsSetting(billEntity, "id,bill,entry.field,entry.isinverse");
        HashSet<String> needInverseColumnSet = new HashSet<String>();
        for (Map.Entry<String, Map<String, Object>> fieldSetting : settingMap.entrySet()) {
            Map<String, Object> setting = fieldSetting.getValue();
            Boolean isinverse = (Boolean)setting.get("isinverse");
            if (isinverse == null || !isinverse.booleanValue()) continue;
            needInverseColumnSet.add(fieldSetting.getKey());
        }
        return needInverseColumnSet;
    }

    private Map<String, Map<String, Object>> getColumnsSetting(String billEntity, String selectFields) {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>(256);
        QFilter f = new QFilter("bill", "=", (Object)billEntity);
        f = f.and("enable", "=", (Object)"1");
        DynamicObject setting = BusinessDataServiceHelper.loadSingleFromCache((String)"im_billfieldsetting", (String)("id,bill,entry.field" + selectFields), (QFilter[])f.toArray());
        if (setting != null) {
            String[] fields = selectFields.split(",");
            HashSet<String> entryFields = new HashSet<String>();
            for (int i = 0; i < fields.length; ++i) {
                String field = fields[i];
                if (field.indexOf(46) <= 0) continue;
                entryFields.add(field.substring(field.indexOf(46) + 1));
            }
            DynamicObjectCollection entrys = setting.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                HashMap<String, Object> fieldProps = new HashMap<String, Object>(entryFields.size());
                String filedKey = entry.getString("field");
                for (String entryField : entryFields) {
                    fieldProps.put(entryField, entry.get(entryField));
                }
                result.put(filedKey, fieldProps);
            }
        }
        return result;
    }
}

