/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.service;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.db.tx.CommitListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scmc.ccm.business.helper.CreditUpdateHelper;
import kd.scmc.ccm.business.pojo.journal.JournalGroup;
import kd.scmc.ccm.business.service.archive.CreditArchive;

public class CreditOpTxListener
implements CommitListener {
    private static final Log logger = LogFactory.getLog(CreditOpTxListener.class);
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern(TimeServiceHelper.getDateTimeFormatString());
    private List<JournalGroup> journalGroupList;
    private List<CreditArchive> updateArchiveList;
    private String opJournal;

    public static CreditOpTxListener doCreate(List<JournalGroup> journalList, List<CreditArchive> updateArchiveList, String opJournal) {
        return new CreditOpTxListener(journalList, updateArchiveList, opJournal);
    }

    private CreditOpTxListener(List<JournalGroup> journalGroupList, List<CreditArchive> updateArchiveList, String opJournal) {
        this.journalGroupList = journalGroupList;
        this.updateArchiveList = updateArchiveList;
        this.opJournal = opJournal;
    }

    public void onEnded(boolean rollBacked) {
        logger.info("--\u5f53\u524d\u64cd\u4f5c\u4e8b\u52a1\u4e0d\u5b58\u5728\u56de\u6eda\u65f6\uff1a\u6d41\u6c34+\u6863\u6848+\u5feb\u7167 \u843d\u5e93\u5f00\u59cb\u65f6\u95f4\uff1a{}", (Object)formatter.format(LocalDateTime.now()));
        if (!rollBacked) {
            CreditUpdateHelper.exeCreditUpdate(this.journalGroupList, this.updateArchiveList, this.opJournal);
        }
        logger.info("--\u5f53\u524d\u64cd\u4f5c\u4e8b\u52a1\u4e0d\u5b58\u5728\u5f02\u5e38\u65f6\uff1a\u6d41\u6c34+\u6863\u6848+\u5feb\u7167 \u843d\u5e93\u7ed3\u675f\u65f6\u95f4\uff1a{}", (Object)formatter.format(LocalDateTime.now()));
    }
}

