/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.service;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scmc.ccm.business.CreditServiceFactory;
import kd.scmc.ccm.business.pojo.CheckResult;
import kd.scmc.ccm.business.pojo.CreditScheme;
import kd.scmc.ccm.business.pojo.journal.JournalGroup;
import kd.scmc.ccm.business.pojo.log.CreditLogCollectInfo;
import kd.scmc.ccm.business.pojo.snapshot.CreditSnapshotsGroupInfo;
import kd.scmc.ccm.business.service.AbstractCreditService;
import kd.scmc.ccm.business.service.CreditOpTxListener;
import kd.scmc.ccm.business.service.applylock.ICreditSyncApplyService;
import kd.scmc.ccm.business.service.archive.ArchiveCollection;
import kd.scmc.ccm.business.service.archive.CreditArchive;
import kd.scmc.ccm.business.service.archive.ICreditArchiveService;
import kd.scmc.ccm.business.service.journal.CreditJournalCreateServiceImpl;
import kd.scmc.ccm.business.service.scheme.ICreditSchemeService;
import kd.scmc.ccm.business.service.snapshot.ICreditSnapshotCreateService;
import kd.scmc.ccm.common.util.CreditContext;

public class CreditUpdateServiceImpl
extends AbstractCreditService {
    private static final Log logger = LogFactory.getLog(CreditUpdateServiceImpl.class);
    private ICreditSchemeService schemeService;
    private ICreditSyncApplyService creditSyncLockService;
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern(TimeServiceHelper.getDateTimeFormatString());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map<String, Object>> invokeMicroService() {
        logger.info("CreditUpdateServiceImpl start:", (Object)formatter.format(LocalDateTime.now()));
        CreditContext txt = CreditContext.create(this.bills[0].getDataEntityType().getName(), this.opKey, "UPDATE");
        LinkedList<CheckResult> resultList = new LinkedList<CheckResult>();
        LinkedList<JournalGroup> saveableJournalGroups = new LinkedList<JournalGroup>();
        LinkedList<JournalGroup> deleteableJournalGroups = new LinkedList<JournalGroup>();
        LinkedList<CreditArchive> updateableArchives = new LinkedList<CreditArchive>();
        try (TXHandle tx = TX.required();){
            try {
                this.startCreditLog();
                List<CreditScheme> effectiveCreditSchemeList = this.schemeService.getEffectiveCreditSchemeList();
                if (effectiveCreditSchemeList.size() <= 0) {
                    CreditLogCollectInfo.writeCreditLog();
                    List<Map<String, Object>> list = Collections.emptyList();
                    return list;
                }
                Set<Long> billIds = Arrays.stream(this.bills).map(bill -> bill.getLong("id")).collect(Collectors.toSet());
                List<DynamicObject> billList = Arrays.asList(this.bills);
                for (CreditScheme scheme : effectiveCreditSchemeList) {
                    String updateOp = scheme.getBillStrategy(txt.getEntityKey()).getUpdateOp();
                    boolean isReverse = !Objects.equals(updateOp, txt.getOperateKey());
                    logger.info("\u66f4\u65b0\u4fe1\u7528\u4f59\u989d update loop scheme id : " + scheme.getId() + "-----\u672c\u6b21\u66f4\u65b0\u64cd\u4f5c : " + updateOp + "----- \u662f\u5426\u53cd\u5411\u64cd\u4f5c : " + isReverse);
                    CreditJournalCreateServiceImpl cjService = CreditJournalCreateServiceImpl.doCreate(scheme, txt);
                    List<JournalGroup> journalGroups = null;
                    if (isReverse ? (journalGroups = cjService.loadJournals(updateOp, billIds)).size() <= 0 : (journalGroups = cjService.buildJournals(billList)).size() <= 0) continue;
                    ICreditSnapshotCreateService snapshotCreateService = CreditServiceFactory.doCreateCreditSnapshotCreateService(scheme, isReverse);
                    List<CreditSnapshotsGroupInfo> snapshotGroupInfoList = snapshotCreateService.createSnapshotGroupInfoList(billList);
                    ICreditArchiveService creditArchiveService = CreditServiceFactory.doCreateCreditArchiveService();
                    ArchiveCollection archiveMap = creditArchiveService.queryArchives(scheme, journalGroups);
                    if (archiveMap == null || archiveMap.isEmpty()) continue;
                    List<CheckResult> checkResultList = this.creditSyncLockService.tryApplyUpdate(journalGroups);
                    List<CheckResult> validateResult = creditArchiveService.validateArchives(archiveMap, journalGroups, true);
                    if (isReverse) {
                        deleteableJournalGroups.addAll(journalGroups);
                    } else {
                        saveableJournalGroups.addAll(journalGroups);
                    }
                    List<CheckResult> updateResults = creditArchiveService.updateArchives(journalGroups, archiveMap, isReverse);
                    creditArchiveService.updateArchiveList(snapshotGroupInfoList, archiveMap, isReverse);
                    List eachResult = Stream.of(validateResult, checkResultList, updateResults).flatMap(Collection::stream).collect(Collectors.toList());
                    resultList.addAll(eachResult);
                    updateableArchives.addAll(archiveMap.values());
                    snapshotCreateService.saveSnapshotInfoList(snapshotGroupInfoList);
                }
                if (saveableJournalGroups.size() > 0 || deleteableJournalGroups.size() > 0) {
                    String opJournal = saveableJournalGroups.size() > 0 ? "save" : "delete";
                    LinkedList<JournalGroup> journalList = saveableJournalGroups.size() > 0 ? saveableJournalGroups : deleteableJournalGroups;
                    CreditOpTxListener creditOpTxListener = CreditOpTxListener.doCreate(journalList, updateableArchives, opJournal);
                    TX.addCommitListener((CommitListener)creditOpTxListener);
                }
                this.writeCreditLog(resultList);
            }
            catch (Exception exp) {
                logger.error("\u4fe1\u63a7\u64cd\u4f5c\uff1a{} \u4e8eupdate\u670d\u52a1\u4e2d\u5b58\u5728\u5f02\u5e38\uff1a{}", (Object)this.opKey, (Object)exp);
                this.collectExpLog(exp);
                this.collectUpdateExpResult(resultList, exp.toString());
                tx.markRollback();
            }
            finally {
                this.creditSyncLockService.releaseApplyUpdate();
            }
        }
        logger.info("CreditUpdateServiceImpl end:", (Object)formatter.format(LocalDateTime.now()));
        return this.convertResult(resultList);
    }

    private void removeSnapshotGroupInfo(List<CreditSnapshotsGroupInfo> snapshotGroupInfoList, List<JournalGroup> journalGroups) {
        Set billNoSet = journalGroups.stream().map(row -> row.getBillNo()).collect(Collectors.toSet());
        Iterator<CreditSnapshotsGroupInfo> sp = snapshotGroupInfoList.iterator();
        while (sp.hasNext()) {
            CreditSnapshotsGroupInfo info = sp.next();
            String billNo = info.getBillNo();
            if (billNoSet.contains(billNo)) continue;
            sp.remove();
        }
    }

    private void writeCreditLog(List<CheckResult> resultList) {
        if (resultList.size() > 0) {
            StringBuilder resultStr = new StringBuilder();
            for (int i = 0; i < resultList.size(); ++i) {
                CheckResult result = resultList.get(i);
                boolean success = result.isSuccess();
                if (success) continue;
                String formatMsg = String.format("success:%1$s,messagetype:%2$s,message:%3$s", success, result.getMessageType(), result.getMessage());
                if (i == 0) {
                    resultStr.append(formatMsg);
                    continue;
                }
                resultStr.append("$$").append(formatMsg);
            }
            if (resultStr.length() > 0) {
                CreditLogCollectInfo.collectCreditLogInfo(resultStr.toString());
            }
        }
        CreditLogCollectInfo.writeCreditLog();
    }

    private void startCreditLog() {
        String name = this.bills[0].getDataEntityType().getName();
        Set<String> billNoList = Arrays.stream(this.bills).map(bill -> bill.getString("billno")).collect(Collectors.toSet());
        CreditLogCollectInfo logInfo = CreditLogCollectInfo.doCreate(name, this.opKey, billNoList);
        CreditContext.get().setLogInfo(logInfo);
    }

    public CreditUpdateServiceImpl(DynamicObject[] bills, String opKey) {
        super(bills, opKey);
        this.schemeService = CreditServiceFactory.doCreateEffectiveCreditScheme(this.bills);
        this.creditSyncLockService = CreditServiceFactory.doCreateCreditSyncApplyService();
    }

    @Override
    public void close() throws Exception {
        if (this.creditSyncLockService != null) {
            this.creditSyncLockService.close();
            this.creditSyncLockService = null;
        }
        if (this.schemeService != null) {
            this.schemeService = null;
        }
    }
}

