/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.service.applylock;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.scmc.ccm.business.pojo.CheckResult;
import kd.scmc.ccm.business.pojo.journal.Journal;
import kd.scmc.ccm.business.pojo.journal.JournalGroup;
import kd.scmc.ccm.business.pojo.log.CreditLogCollectInfo;
import kd.scmc.ccm.business.service.applylock.ICreditSyncApplyService;

public class CreditSyncApplyService
implements ICreditSyncApplyService {
    private static final Log logger = LogFactory.getLog(CreditSyncApplyService.class);
    private static final String LOCKTIMEPARAMKEY = "locktime";
    private static final String CCM_APPID = "0N6JIY2ETSPF";
    private List<String> successfulLockKeys = new LinkedList<String>();

    @Override
    public List<CheckResult> tryApplyUpdate(List<JournalGroup> journalGroupList) {
        logger.info("JournalGroup  start  get lock\u2026");
        ArrayList<CheckResult> unlockArchiveList = new ArrayList<CheckResult>(journalGroupList.size());
        Iterator<JournalGroup> jgIterator = journalGroupList.iterator();
        block0: while (jgIterator.hasNext()) {
            JournalGroup journalGroup = jgIterator.next();
            for (Journal journal : journalGroup.getJournals()) {
                String lockKey = journal.getScheme().getId() + ":" + journal.getDimensionValue().getValue();
                if (this.tryLock(lockKey)) continue;
                CheckResult checkResult = new CheckResult(journalGroup.getScheme(), journalGroup.getMainEntityKey());
                checkResult.setSuccess(false);
                checkResult.setBillno(journalGroup.getBillNo());
                String messageTemplate = ResManager.loadKDString((String)"\u5355\u636e\u5bf9\u5e94\u7684\u4fe1\u7528\u6863\u6848\u5b58\u5728\u5e76\u53d1\u9501\u201c%s\u201d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"CreditSyncApplyService_0", (String)"scmc-ccm", (Object[])new Object[0]);
                checkResult.setMessage(String.format(messageTemplate, lockKey));
                unlockArchiveList.add(checkResult);
                jgIterator.remove();
                continue block0;
            }
        }
        if (unlockArchiveList.size() > 0) {
            CreditLogCollectInfo.collectCreditLogInfo("nogetcreditlock", unlockArchiveList);
            logger.info("\u672a\u83b7\u53d6\u5230\u5e76\u53d1\u9501\u7684\u6863\u6848\u5982\u4e0b\uff1a{}", unlockArchiveList);
        }
        logger.info("JournalGroup get lock end\u2026");
        return unlockArchiveList;
    }

    @Override
    public void releaseApplyUpdate() {
        this.close();
    }

    public boolean tryLock(String lockKey) {
        DLock reentrantLock = DLock.createReentrant((String)lockKey);
        reentrantLock.fastMode();
        boolean getLockSuccess = false;
        int Lock_Time = this.getLockTimeAPPParam();
        getLockSuccess = reentrantLock.tryLock((long)Lock_Time);
        if (getLockSuccess) {
            this.successfulLockKeys.add(lockKey);
        }
        return getLockSuccess;
    }

    public void unlockAll() {
        for (String lockKey : this.successfulLockKeys) {
            DLock reentrantLock = DLock.createReentrant((String)lockKey);
            reentrantLock.unlock();
        }
    }

    public void unLock(String key) {
        DLock reentrantLock = DLock.createReentrant((String)key);
        reentrantLock.unlock();
    }

    public void lock(String lockKey) {
        DLock reentrantLock = DLock.createReentrant((String)lockKey);
        reentrantLock.fastMode();
        reentrantLock.lock();
        this.successfulLockKeys.add(lockKey);
    }

    @Override
    public void close() {
        this.unlockAll();
        logger.info("credit synclock service close success");
    }

    private int getLockTimeAPPParam() {
        int Lock_Time = 10000;
        Long orgID = RequestContext.get().getOrgId();
        AppParam appParam = new AppParam(CCM_APPID, "03", orgID, Long.valueOf(0L));
        Object lockTimeValue = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)LOCKTIMEPARAMKEY);
        if (lockTimeValue != null && (Integer)lockTimeValue > 0) {
            Lock_Time = (Integer)lockTimeValue;
        }
        return Lock_Time;
    }

    private CreditSyncApplyService() {
    }

    public static CreditSyncApplyService doCreate() {
        return new CreditSyncApplyService();
    }
}

