/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.service.archive;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.scmc.ccm.business.pojo.CreditScheme;
import kd.scmc.ccm.business.pojo.DimensionValue;

public class CreditArchive
implements Serializable {
    private static final long serialVersionUID = -4741796229865341408L;
    private long id;
    private transient CreditScheme scheme;
    private DimensionValue dimensionValue;
    private String quotaType;
    private long unit;
    private BigDecimal quota = BigDecimal.ZERO;
    private BigDecimal oldBalance = BigDecimal.ZERO;
    private BigDecimal balance = BigDecimal.ZERO;
    private transient List<DynamicObject> rawArchives = new ArrayList<DynamicObject>();

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public DimensionValue getDimensionValue() {
        return this.dimensionValue;
    }

    public void setDimensionValue(DimensionValue dimensionValue) {
        this.dimensionValue = dimensionValue;
    }

    public CreditScheme getScheme() {
        return this.scheme;
    }

    public void setScheme(CreditScheme scheme) {
        this.scheme = scheme;
    }

    public List<DynamicObject> getRawArchives() {
        return this.rawArchives;
    }

    public void setRawArchives(List<DynamicObject> rawArchives) {
        this.rawArchives = rawArchives;
    }

    public DynamicObject getMainArchive() {
        for (DynamicObject rawArchive : this.rawArchives) {
            if (!Objects.equals("normal", rawArchive.getString("archivetype"))) continue;
            return rawArchive;
        }
        String messageTemplate = ResManager.loadKDString((String)"\u4fe1\u7528\u7ba1\u7406\u7684\u4fe1\u63a7\u65b9\u6848\u201c%s\u201d\u627e\u4e0d\u5230\u4e3b\u6863\u6848\u3002", (String)"CreditArchive_0", (String)"scmc-ccm-business", (Object[])new Object[0]);
        throw new KDBizException(String.format(messageTemplate, this.rawArchives.get(0).getLocaleString("scheme.name")));
    }

    public String getQuotaType() {
        return this.quotaType;
    }

    public void setQuotaType(String quotaType) {
        this.quotaType = quotaType;
    }

    public long getUnit() {
        return this.unit;
    }

    public void setUnit(long unit) {
        this.unit = unit;
    }

    public BigDecimal getQuota() {
        return this.quota;
    }

    public void setQuota(BigDecimal quota) {
        this.quota = quota;
    }

    public BigDecimal getOldBalance() {
        return this.oldBalance;
    }

    public void setOldBalance(BigDecimal oldBalance) {
        this.oldBalance = oldBalance;
    }

    public BigDecimal getBalance() {
        return this.balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public void increaseQuota(BigDecimal increaseValue) {
        this.quota = this.quota.add(increaseValue);
    }

    public void increaseBalance(BigDecimal increaseValue) {
        this.balance = this.balance.add(increaseValue);
    }

    public void reduceBalance(BigDecimal reduceValue) {
        this.balance = this.balance.subtract(reduceValue);
    }

    public String toString() {
        return "{id=" + this.id + ", quotaType='" + this.quotaType + '\'' + ", unit=" + this.unit + ", quota=" + this.quota + ", oldBalance=" + this.oldBalance + ", balance=" + this.balance + '}';
    }
}

