/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.service.archive;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.audit.Audit;
import kd.bos.audit.Auditable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scmc.ccm.business.CreditServiceFactory;
import kd.scmc.ccm.business.helper.DimensionValueControlledHelper;
import kd.scmc.ccm.business.pojo.CheckResult;
import kd.scmc.ccm.business.pojo.CreditScheme;
import kd.scmc.ccm.business.pojo.DimensionValue;
import kd.scmc.ccm.business.pojo.Role;
import kd.scmc.ccm.business.pojo.journal.Journal;
import kd.scmc.ccm.business.pojo.journal.JournalGroup;
import kd.scmc.ccm.business.pojo.log.CreditLogCollectInfo;
import kd.scmc.ccm.business.pojo.snapshot.CreditSnapshotsGroupInfo;
import kd.scmc.ccm.business.pojo.snapshot.CreditSnapshotsInfo;
import kd.scmc.ccm.business.service.archive.ArchiveCollection;
import kd.scmc.ccm.business.service.archive.CreditArchive;
import kd.scmc.ccm.business.service.archive.ICreditArchiveService;
import kd.scmc.ccm.business.service.archive.loader.IArchiveLoader;
import kd.scmc.ccm.common.enums.Direction;

public class CreditArchiveServiceImpl
implements ICreditArchiveService {
    private static final Log logger = LogFactory.getLog(CreditArchiveServiceImpl.class);
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern(TimeServiceHelper.getDateTimeFormatString());

    @Override
    public ArchiveCollection queryArchives(CreditScheme scheme, List<JournalGroup> journalGroups) {
        List<DimensionValue> dimensionValues = this.getDimensionValues(journalGroups);
        try (Auditable audit = Audit.audit((String)"ccm.loadarchives", (Object[])new Object[0]);){
            String quotaType = scheme.getQuotaType().getQuotaType();
            IArchiveLoader archiveLoader = CreditServiceFactory.doCreateArchiveLoader(quotaType);
            ArchiveCollection archiveMap = archiveLoader.loadArchives(scheme, dimensionValues);
            if (archiveMap == null) {
                logger.info("credit update is notexist archive process is exist");
            } else {
                logger.info("credit archive num is:" + archiveMap.size());
                CreditLogCollectInfo.collectCreditLogInfo("archive_before".concat("$$").concat(scheme.getNumber()), archiveMap.toString());
            }
            ArchiveCollection archiveCollection = archiveMap;
            return archiveCollection;
        }
    }

    @Override
    public List<CheckResult> validateArchives(ArchiveCollection archives, List<JournalGroup> journalGroupList) {
        return this.validateArchives(archives, journalGroupList, false);
    }

    @Override
    public List<CheckResult> validateArchives(ArchiveCollection archives, List<JournalGroup> journalGroupList, boolean isForUpdateBalanceService) {
        LinkedList<DimensionValue> dimensionValues = new LinkedList<DimensionValue>();
        LinkedList<CheckResult> results = new LinkedList<CheckResult>();
        if (journalGroupList == null || archives == null || archives.getScheme() == null) {
            return results;
        }
        for (JournalGroup journalGroup : journalGroupList) {
            for (Journal journal : journalGroup.getJournals()) {
                boolean isCusUnicodeNull = false;
                DimensionValue dimensionValue = journal.getDimensionValue();
                CreditArchive archive = (CreditArchive)archives.get(dimensionValue);
                if (dimensionValue != null) {
                    List<Role> roles = dimensionValue.getDimension().getRoles();
                    for (Role role : roles) {
                        String roleType = role.getRoleType();
                        if (!"CUSUNICODE".equals(roleType) || dimensionValue.getValue(role) != null) continue;
                        isCusUnicodeNull = true;
                        break;
                    }
                }
                if (archive != null || isCusUnicodeNull) continue;
                dimensionValues.add(dimensionValue);
            }
        }
        CreditScheme scheme = archives.getScheme();
        List<DimensionValue> controlledDimensionValuesList = DimensionValueControlledHelper.getControlledDimensionValues(scheme, dimensionValues);
        HashSet<DimensionValue> controlledDimensionValues = new HashSet<DimensionValue>(controlledDimensionValuesList);
        Iterator<JournalGroup> iterator = journalGroupList.iterator();
        block3: while (iterator.hasNext()) {
            JournalGroup journalGroup = iterator.next();
            for (Journal journal : journalGroup.getJournals()) {
                if (!controlledDimensionValues.contains(journal.getDimensionValue())) continue;
                String entityKey = journalGroup.getMainEntityKey();
                CheckResult result = new CheckResult(scheme, entityKey);
                this.wrapControlResult(scheme, result, journal, isForUpdateBalanceService);
                results.add(result);
                iterator.remove();
                continue block3;
            }
        }
        return results;
    }

    @Override
    public List<CheckResult> updateArchives(List<JournalGroup> journalGroups, ArchiveCollection archives, boolean isReverse) {
        logger.info("CCM-\u4fe1\u63a7\u672c\u6b21\u64cd\u4f5c\u66f4\u65b0\u6863\u6848\u5185\u5b58\u8ba1\u7b97\u5f00\u59cb\uff1a:{}", (Object)formatter.format(LocalDateTime.now()));
        List<CheckResult> collectResult = journalGroups.stream().map(row -> this.updateBalance((JournalGroup)row, archives, isReverse)).collect(Collectors.toList());
        logger.info("CCM-\u4fe1\u63a7\u672c\u6b21\u64cd\u4f5c\u66f4\u65b0\u6863\u6848\u5185\u5b58\u8ba1\u7b97\u7ed3\u675f\uff1a:{}", (Object)formatter.format(LocalDateTime.now()));
        return collectResult;
    }

    @Override
    public List<CheckResult> validateArchiveList(List<CreditSnapshotsGroupInfo> snapshotGroupInfoList, ArchiveCollection archives) {
        LinkedList<DimensionValue> dimensionValues = new LinkedList<DimensionValue>();
        LinkedList<CheckResult> validateResult = new LinkedList<CheckResult>();
        if (snapshotGroupInfoList == null || archives == null || archives.getScheme() == null) {
            return validateResult;
        }
        for (CreditSnapshotsGroupInfo snapshotGroupInfo : snapshotGroupInfoList) {
            for (CreditSnapshotsInfo snapshotInfo : snapshotGroupInfo.getCreditSnapshotsInfoList()) {
                boolean isCusUnicodeNull = false;
                DimensionValue dimensionValue = snapshotInfo.getDimensionvalue();
                CreditArchive archive = (CreditArchive)archives.get(dimensionValue);
                if (dimensionValue != null) {
                    List<Role> roles = dimensionValue.getDimension().getRoles();
                    for (Role role : roles) {
                        String roleType = role.getRoleType();
                        if (!"CUSUNICODE".equals(roleType) || dimensionValue.getValue(role) != null) continue;
                        isCusUnicodeNull = true;
                        break;
                    }
                }
                if (archive != null || isCusUnicodeNull) continue;
                dimensionValues.add(dimensionValue);
            }
        }
        CreditScheme scheme = archives.getScheme();
        List<DimensionValue> controlledDimensionValuesList = DimensionValueControlledHelper.getControlledDimensionValues(scheme, dimensionValues);
        HashSet<DimensionValue> controlledDimensionValues = new HashSet<DimensionValue>(controlledDimensionValuesList);
        Iterator<CreditSnapshotsGroupInfo> iterator = snapshotGroupInfoList.iterator();
        block3: while (iterator.hasNext()) {
            CreditSnapshotsGroupInfo snapshotsGroupInfo = iterator.next();
            for (CreditSnapshotsInfo snapshotInfo : snapshotsGroupInfo.getCreditSnapshotsInfoList()) {
                if (!controlledDimensionValues.contains(snapshotInfo.getDimensionvalue())) continue;
                String entityKey = snapshotsGroupInfo.getMainEntityKey();
                CheckResult result = new CheckResult(scheme, entityKey);
                result.setBillno(snapshotsGroupInfo.getBillNo());
                result.setSuccess(false);
                String schemeName = scheme.getName();
                String message = ResManager.loadKDString((String)"\u4fe1\u63a7\u65b9\u6848\u201c%s\u201d\u65e0\u53ef\u7528\u7684\u4fe1\u7528\u6863\u6848\u3002", (String)"CreditArchiveServiceImpl_0", (String)"scmc-ccm", (Object[])new Object[0]);
                result.setMessage(String.format(message, schemeName));
                result.setMessageType("error");
                validateResult.add(result);
                iterator.remove();
                continue block3;
            }
        }
        return validateResult;
    }

    @Override
    public void updateArchiveList(List<CreditSnapshotsGroupInfo> snapshotGroupInfoList, ArchiveCollection archives, boolean isReverse) {
        for (CreditSnapshotsGroupInfo info : snapshotGroupInfoList) {
            for (CreditSnapshotsInfo sp : info.getCreditSnapshotsInfoList()) {
                CreditArchive archive;
                if (sp == null || (archive = (CreditArchive)archives.get(sp.getDimensionvalue())) == null) continue;
                DynamicObject mainArchive = archive.getMainArchive();
                sp.setArchiveid(mainArchive.getLong("id"));
            }
        }
    }

    public CheckResult updateBalance(JournalGroup journalGroup, ArchiveCollection archives, boolean isReverse) {
        logger.info("CCM-\u4fe1\u63a7\u5355\u636e\uff1a{}\u6863\u6848\u66f4\u65b0\u5185\u5b58\u8ba1\u7b97\u5f00\u59cb\uff1a:{}", (Object)journalGroup.getBillNo(), (Object)formatter.format(LocalDateTime.now()));
        CreditScheme scheme = archives.getScheme();
        for (Journal journal : journalGroup.getJournals()) {
            CreditArchive archive;
            if (journal == null || (archive = (CreditArchive)archives.get(journal.getDimensionValue())) == null) continue;
            DynamicObject mainArchive = archive.getMainArchive();
            journal.setArchiveId(mainArchive.getLong("id"));
            BigDecimal balance = mainArchive.getBigDecimal("balance");
            BigDecimal reduceSum = mainArchive.getBigDecimal("reducesum");
            BigDecimal increaseSum = mainArchive.getBigDecimal("increasesum");
            if (Direction.REDUCE.name().equals(journal.getDirection())) {
                if (isReverse) {
                    archive.increaseBalance(journal.getAmount());
                    mainArchive.set("balance", (Object)balance.add(journal.getAmount()));
                    mainArchive.set("reducesum", (Object)reduceSum.subtract(journal.getAmount()));
                    continue;
                }
                archive.reduceBalance(journal.getAmount());
                mainArchive.set("balance", (Object)balance.subtract(journal.getAmount()));
                mainArchive.set("reducesum", (Object)reduceSum.add(journal.getAmount()));
                continue;
            }
            if (isReverse) {
                archive.reduceBalance(journal.getAmount());
                mainArchive.set("balance", (Object)balance.subtract(journal.getAmount()));
                mainArchive.set("increasesum", (Object)increaseSum.subtract(journal.getAmount()));
                continue;
            }
            archive.increaseBalance(journal.getAmount());
            mainArchive.set("balance", (Object)balance.add(journal.getAmount()));
            mainArchive.set("increasesum", (Object)increaseSum.add(journal.getAmount()));
        }
        CreditLogCollectInfo.collectCreditLogInfo("archive_after".concat("$$").concat(scheme.getNumber()), archives.toString());
        CheckResult checkResult = new CheckResult();
        checkResult.setSuccess(true);
        checkResult.setBillno(journalGroup.getBillNo());
        logger.info("CCM-\u4fe1\u63a7\u5355\u636e\uff1a{}\u6863\u6848\u66f4\u65b0\u5185\u5b58\u8ba1\u7b97\u7ed3\u675f\uff1a:{}", (Object)journalGroup.getBillNo(), (Object)formatter.format(LocalDateTime.now()));
        return checkResult;
    }

    private CheckResult wrapControlResult(CreditScheme scheme, CheckResult result, Journal journal, boolean isForUpdateBalanceService) {
        result.setBillno(journal.getBillNo());
        result.setSuccess(false);
        String schemeName = scheme.getName();
        String message = ResManager.loadKDString((String)"\u4fe1\u63a7\u65b9\u6848\u201c%s\u201d\u65e0\u53ef\u7528\u7684\u4fe1\u7528\u6863\u6848\u3002", (String)"CreditArchiveServiceImpl_0", (String)"scmc-ccm", (Object[])new Object[0]);
        result.setMessage(String.format(message, schemeName));
        if (isForUpdateBalanceService) {
            result.setMessageType("error");
        }
        return result;
    }

    protected List<DimensionValue> getDimensionValues(List<JournalGroup> journalGroupList) {
        LinkedList<DimensionValue> dimensionValues = new LinkedList<DimensionValue>();
        if (journalGroupList == null) {
            return dimensionValues;
        }
        for (JournalGroup journalGroup : journalGroupList) {
            for (Journal journal : journalGroup.getJournals()) {
                dimensionValues.add(journal.getDimensionValue());
            }
        }
        return dimensionValues;
    }

    public static CreditArchiveServiceImpl doCreate() {
        return new CreditArchiveServiceImpl();
    }

    private CreditArchiveServiceImpl() {
    }

    @Override
    public void close() throws Exception {
    }
}

