/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.service.archive.create;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.ccm.business.helper.DimensionEntryFieldMapper;
import kd.scmc.ccm.business.helper.DimensionValueControlledHelper;
import kd.scmc.ccm.business.pojo.CreditScheme;
import kd.scmc.ccm.business.pojo.DimensionValue;
import kd.scmc.ccm.business.pojo.Role;
import kd.scmc.ccm.common.util.DateUtil;

public class ArchiveGenerator
implements AutoCloseable {
    public static ArchiveGenerator doCreate() {
        return new ArchiveGenerator();
    }

    public DynamicObject[] autoGenerate(CreditScheme scheme, List<DimensionValue> dimensionValues) {
        String validity = scheme.getValidity();
        List<DimensionValue> controlledDimensionValues = DimensionValueControlledHelper.getControlledDimensionValues(scheme, dimensionValues);
        ArrayList<String> dimensionValueList = new ArrayList<String>(controlledDimensionValues.size());
        ArrayList<DynamicObject> archiveList = new ArrayList<DynamicObject>(controlledDimensionValues.size());
        long[] archiveIds = DB.genLongIds((String)"ccm_archive", (int)controlledDimensionValues.size());
        int archiveIdIndex = 0;
        DimensionEntryFieldMapper mapper = new DimensionEntryFieldMapper(scheme.getDimension().getId());
        for (DimensionValue dimensionValue : controlledDimensionValues) {
            DynamicObject[] archive = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ccm_archive"));
            dimensionValueList.add(dimensionValue.getValue());
            archive.set("id", (Object)archiveIds[archiveIdIndex]);
            archive.set("scheme", (Object)scheme.getId());
            archive.set("dimensionvalue", (Object)dimensionValue.getValue());
            archive.set("archivetype", (Object)"normal");
            archive.set("dimension", (Object)scheme.getDimension().getId());
            String quotaType = scheme.getQuotaType().getQuotaType();
            archive.set("quotatype", (Object)quotaType);
            if ("amount".equals(quotaType)) {
                archive.set("unit", (Object)scheme.getCurrency());
                archive.set("quota", (Object)scheme.getDefaultquota());
                archive.set("balance", (Object)scheme.getDefaultquota());
            }
            if ("days".equals(quotaType)) {
                archive.set("quota", (Object)scheme.getDefaultdays());
                archive.set("balance", (Object)scheme.getDefaultdays());
            }
            if ("PERPETUAL".equals(validity)) {
                archive.set("begindate", (Object)new Date());
                archive.set("enddate", (Object)DateUtil.getYearsLaterDate(new Date(), 100));
                archive.set("effectstate", (Object)"ISEFFECT");
            } else {
                archive.set("effectstate", (Object)"NOEFFECT");
                Date yearBeginDate = scheme.getYearbegindate();
                Date beginDate = DateUtil.getSpecialDate(DateUtil.getDateYear(new Date()), DateUtil.getDateMonth(yearBeginDate), DateUtil.getDateDay(yearBeginDate));
                archive.set("begindate", (Object)beginDate);
                archive.set("enddate", (Object)DateUtil.getYearsLaterDate(beginDate, 1));
            }
            ++archiveIdIndex;
            List<Role> roles = dimensionValue.getDimension().getRoles();
            List<String> roleFieldKeys = mapper.getRoleFieldKeys();
            for (int i = 0; i < roleFieldKeys.size(); ++i) {
                archive.set(roleFieldKeys.get(i), dimensionValue.getValue(roles.get(i)));
            }
            List<String> fieldTypeKeys = mapper.getFieldTypeKeys();
            for (String fieldTypeKey : fieldTypeKeys) {
                archive.set(fieldTypeKey, (Object)mapper.getBaseDataKey(fieldTypeKey));
            }
            archiveList.add((DynamicObject)archive);
        }
        if (!ObjectUtils.isEmpty(archiveList)) {
            if ("YEAR".equals(validity)) {
                this.setRelatedId(archiveList, scheme.getId(), dimensionValueList);
            }
            DynamicObject[] archives = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])archiveList.toArray(new DynamicObject[0]));
            ArrayList<Long> successArchiveIds = new ArrayList<Long>(archives.length);
            for (DynamicObject archive : archives) {
                successArchiveIds.add(archive.getLong("id"));
            }
            DynamicObject[] successArchives = BusinessDataServiceHelper.load((String)"ccm_archive", (String)"billno,scheme,dimension,dimensionvalue,unit,quota,archivetype,quotatype,balance,enddate,increasesum,reducesum,effectstate,relatedid", (QFilter[])new QFilter[]{new QFilter("id", "in", successArchiveIds)});
            return successArchives;
        }
        return null;
    }

    private void setRelatedId(List<DynamicObject> archiveList, long schemeId, List<String> dimensionValueList) {
        DynamicObject[] archives = BusinessDataServiceHelper.load((String)"ccm_archive", (String)"scheme,dimensionvalue,relatedid", (QFilter[])new QFilter[]{new QFilter("scheme", "=", (Object)schemeId), new QFilter("dimensionvalue", "in", dimensionValueList)});
        for (DynamicObject dest : archiveList) {
            DynamicObject archive = this.matchArchive(archives, dest);
            if (archive == null) {
                dest.set("relatedid", (Object)dest.getLong("id"));
                continue;
            }
            dest.set("relatedid", (Object)archive.getLong("relatedid"));
        }
    }

    private DynamicObject matchArchive(DynamicObject[] archives, DynamicObject dest) {
        for (DynamicObject archive : archives) {
            if (!archive.getString("dimensionvalue").equals(dest.getString("dimensionvalue"))) continue;
            return archive;
        }
        return null;
    }

    @Override
    public void close() throws Exception {
    }
}

