/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.service.archive.loader;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ccm.business.pojo.CreditScheme;
import kd.scmc.ccm.business.pojo.Dimension;
import kd.scmc.ccm.business.pojo.DimensionValue;
import kd.scmc.ccm.business.service.archive.ArchiveCollection;
import kd.scmc.ccm.business.service.archive.CreditArchive;
import kd.scmc.ccm.business.service.archive.create.ArchiveGenerator;
import kd.scmc.ccm.business.service.archive.effect.ArchiveEffectService;
import kd.scmc.ccm.business.service.archive.loader.IArchiveLoader;
import kd.scmc.ccm.common.util.DateUtil;
import org.apache.commons.lang.ArrayUtils;

public class DefaultArchiveLoader
implements IArchiveLoader {
    private ArchiveEffectService archiveEffectService = ArchiveEffectService.doCreate();

    @Override
    public ArchiveCollection loadArchives(CreditScheme scheme) {
        QFilter filter = new QFilter("scheme", "=", (Object)scheme.getId());
        filter.and(new QFilter("begindate", "<=", (Object)new Date()));
        filter.and(new QFilter("enddate", ">=", (Object)new Date()));
        DynamicObject[] rawArchives = BusinessDataServiceHelper.load((String)"ccm_archive", (String)"billno,scheme,dimension,dimensionvalue,unit,quota,archivetype,quotatype,balance,enddate,increasesum,reducesum,effectstate,relatedid", (QFilter[])new QFilter[]{filter});
        this.archiveEffectService.effect(rawArchives);
        return this.transDynamnicToArchive(scheme, rawArchives);
    }

    @Override
    public ArchiveCollection loadArchives(CreditScheme scheme, List<DimensionValue> dimensionValues) {
        HashSet<String> plainValues = new HashSet<String>(dimensionValues.size());
        for (DimensionValue value : dimensionValues) {
            plainValues.add(value.getValue());
        }
        QFilter dimensionValueFilter = new QFilter("dimensionvalue", "in", plainValues);
        QFilter schemeFilter = new QFilter("scheme", "=", (Object)scheme.getId());
        Date today = new Date();
        QFilter dataRangeFilter = new QFilter("begindate", "<=", (Object)DateUtil.getEndOfDay(today)).and("enddate", ">=", (Object)DateUtil.getStartOfDay(today));
        QFilter[] filters = new QFilter[]{schemeFilter, dimensionValueFilter, dataRangeFilter};
        Object[] rawArchives = BusinessDataServiceHelper.load((String)"ccm_archive", (String)"billno,scheme,dimension,dimensionvalue,unit,quota,archivetype,quotatype,balance,enddate,increasesum,reducesum,effectstate,relatedid", (QFilter[])filters);
        DynamicObject[] autoCreatedArchives = null;
        if (!"overdueamt".equals(scheme.getQuotaType().getQuotaType())) {
            autoCreatedArchives = this.getAutoCreatedArchive(scheme, dimensionValues, (DynamicObject[])rawArchives);
        }
        Object[] transArchives = autoCreatedArchives == null ? rawArchives : (DynamicObject[])ArrayUtils.addAll((Object[])rawArchives, autoCreatedArchives);
        this.archiveEffectService.effect((DynamicObject[])transArchives);
        return this.transDynamnicToArchive(scheme, (DynamicObject[])transArchives);
    }

    public ArchiveCollection transDynamnicToArchive(CreditScheme scheme, DynamicObject[] rawArchives) {
        ArchiveCollection archiveCollection = new ArchiveCollection(scheme, rawArchives.length);
        for (DynamicObject rawArchive : rawArchives) {
            this.dynamicToArchive(scheme, archiveCollection, rawArchive);
        }
        return archiveCollection;
    }

    public DynamicObjectCollection loadArchives(List<Long> schemeIds, List<String> dimensionValues) {
        QFilter schemeFilter = new QFilter("scheme", "in", schemeIds);
        QFilter dimensionValueFilter = new QFilter("dimensionvalue", "in", dimensionValues);
        QFilter[] filters = new QFilter[]{schemeFilter, dimensionValueFilter};
        DynamicObjectCollection archives = QueryServiceHelper.query((String)"ccm_archive", (String)"id,scheme,dimensionvalue,relatedid", (QFilter[])filters);
        return archives;
    }

    private void dynamicToArchive(CreditScheme scheme, ArchiveCollection archiveCollection, DynamicObject rawArchive) {
        DimensionValue dimensionValue = new DimensionValue(scheme.getDimension());
        dimensionValue.setValue(rawArchive.getString("dimensionvalue"));
        CreditArchive archive = (CreditArchive)archiveCollection.get(dimensionValue);
        if (archive == null) {
            archive = new CreditArchive();
            archive.setId(rawArchive.getLong("id"));
            archive.setScheme(scheme);
            Dimension dimension = scheme.getDimension();
            DimensionValue value = new DimensionValue(dimension);
            value.setValue(rawArchive.getString("dimensionvalue"));
            archive.setDimensionValue(value);
            archiveCollection.put(dimensionValue, archive);
        }
        String quotaType = rawArchive.getString("quotatype");
        archive.setUnit(rawArchive.getLong("unit"));
        archive.setQuotaType(quotaType);
        archive.increaseQuota(rawArchive.getBigDecimal("quota"));
        archive.increaseBalance(rawArchive.getBigDecimal("balance"));
        archive.setOldBalance(archive.getBalance());
        archive.getRawArchives().add(rawArchive);
    }

    public DynamicObject[] getAutoCreatedArchive(CreditScheme scheme, List<DimensionValue> dimensionValues, DynamicObject[] rawArchives) {
        boolean autoCreateArchive = scheme.isAutocreatearchive();
        if (autoCreateArchive) {
            ArrayList<DimensionValue> isCreateDimensionValues = new ArrayList<DimensionValue>(dimensionValues.size());
            for (DimensionValue dimensionValue : dimensionValues) {
                if (this.isMatchArchive(dimensionValue, scheme.getId(), rawArchives)) continue;
                isCreateDimensionValues.add(dimensionValue);
            }
            return ArchiveGenerator.doCreate().autoGenerate(scheme, isCreateDimensionValues);
        }
        return null;
    }

    private boolean isMatchArchive(DimensionValue dimensionValue, long schemeId, DynamicObject[] archives) {
        boolean isMatch = false;
        for (DynamicObject archive : archives) {
            if (!archive.getString("dimensionvalue").equals(dimensionValue.getValue()) || schemeId != archive.getDynamicObject("scheme").getLong("id")) continue;
            isMatch = true;
        }
        return isMatch;
    }

    @Override
    public void close() throws Exception {
    }
}

