/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.service.archive.loader;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.scmc.ccm.business.pojo.CreditScheme;
import kd.scmc.ccm.business.pojo.DimensionValue;
import kd.scmc.ccm.business.service.archive.ArchiveCollection;
import kd.scmc.ccm.business.service.archive.CreditArchive;
import kd.scmc.ccm.business.service.archive.loader.DefaultArchiveLoader;
import kd.scmc.ccm.business.service.archive.overdue.RuleBasedOverdueCalculator;

public class OverdueArchiveLoader
extends DefaultArchiveLoader {
    @Override
    public ArchiveCollection loadArchives(CreditScheme scheme) {
        ArchiveCollection archives = super.loadArchives(scheme);
        this.calculateRuntimeDueday(scheme, archives);
        return archives;
    }

    @Override
    public ArchiveCollection loadArchives(CreditScheme scheme, List<DimensionValue> dimensionValues) {
        ArchiveCollection archives = super.loadArchives(scheme, dimensionValues);
        this.calculateRuntimeDueday(scheme, archives);
        return archives;
    }

    private void calculateRuntimeDueday(CreditScheme scheme, ArchiveCollection archives) {
        RuleBasedOverdueCalculator overdueDayCalculator = new RuleBasedOverdueCalculator();
        Map<DimensionValue, BigDecimal> result = overdueDayCalculator.calculate(scheme, archives.keySet());
        for (Map.Entry<DimensionValue, BigDecimal> entry : result.entrySet()) {
            DimensionValue dimensionValue = entry.getKey();
            CreditArchive archive = (CreditArchive)archives.get(dimensionValue);
            if (archive == null) continue;
            archive.reduceBalance(entry.getValue());
        }
    }
}

