/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.service.archive.overdue;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.ccm.business.CreditServiceFactory;
import kd.scmc.ccm.business.helper.OverDueDayHelper;
import kd.scmc.ccm.business.helper.OverdueBillQueryConditionMapper;
import kd.scmc.ccm.business.pojo.BillStrategy;
import kd.scmc.ccm.business.pojo.CreditElement;
import kd.scmc.ccm.business.pojo.CreditScheme;
import kd.scmc.ccm.business.pojo.DimensionValue;
import kd.scmc.ccm.business.pojo.EntityConfig;
import kd.scmc.ccm.business.pojo.Field;
import kd.scmc.ccm.business.pojo.Role;
import kd.scmc.ccm.business.service.archive.overdue.IOverdueCalculator;
import kd.scmc.ccm.business.service.entityconfig.ICreditEntityConService;
import kd.scmc.ccm.common.util.CreditContext;
import kd.scmc.ccm.common.util.DateUtil;

public class RuleBasedOverdueCalculator
implements IOverdueCalculator {
    private static final Log logger = LogFactory.getLog(RuleBasedOverdueCalculator.class);
    private ICreditEntityConService iCreditEntityConService = CreditServiceFactory.doCreateCreditEntityConService();

    @Override
    public Map<DimensionValue, BigDecimal> calculate(CreditScheme scheme, Set<DimensionValue> dimensionValues) {
        long queryOverdueBeginTime = System.currentTimeMillis();
        logger.info("\u8ba1\u7b97\u903e\u671f\u6570\u636e 1.\u5f00\u59cb\uff1a" + new Date(queryOverdueBeginTime));
        CreditContext creditContext = CreditContext.get();
        BillStrategy billStrategy = scheme.getBillStrategy(creditContext.getEntityKey());
        boolean isSingleCurrencyControl = scheme.isSingleCurrencyControl();
        String calculateDateField = "";
        String calculateAmtField = "";
        String quotaType = scheme.getQuotaType().getQuotaType();
        if ("overdueamt".equals(quotaType)) {
            calculateAmtField = billStrategy.getCalculateAmt();
            calculateDateField = billStrategy.getCalculateDate();
        } else if ("days".equals(quotaType)) {
            calculateDateField = billStrategy.getCalculateDate();
        }
        if (ObjectUtils.isEmpty((Object)calculateDateField)) {
            return new HashMap<DimensionValue, BigDecimal>(0);
        }
        String assingEntityKey = billStrategy.getAssingEntityKey();
        EntityConfig entityConfig = this.iCreditEntityConService.readConfig(assingEntityKey);
        List<Role> roles = scheme.getDimension().getRoles();
        OverdueBillQueryConditionMapper billCondition = new OverdueBillQueryConditionMapper(scheme, dimensionValues, entityConfig);
        List<String> billRoleFields = billCondition.getBillRoleFields();
        QFilter filter = billCondition.getFilter();
        List<String> selectors = billCondition.getSelectors();
        Long cusunicodeId = billCondition.getCusunicodeId();
        HashMap<DimensionValue, BigDecimal> results = new HashMap<DimensionValue, BigDecimal>(dimensionValues.size());
        HashMap<DimensionValue, String> billnos = new HashMap<DimensionValue, String>(dimensionValues.size());
        selectors.add(calculateDateField);
        selectors.add("billno");
        Field currencyField = entityConfig.getField(CreditElement.ELEMENT_CURRENCY);
        String currencyFieldKey = currencyField.getKey();
        if (currencyField.getEntryKey() != null) {
            currencyFieldKey = currencyField.getEntryKey() + "." + currencyField.getKey();
        }
        filter.and(new QFilter(calculateDateField, "is not null", null));
        if ("overdueamt".equals(quotaType)) {
            selectors.add(calculateAmtField);
            if (isSingleCurrencyControl) {
                filter.and(new QFilter(currencyFieldKey, "=", (Object)scheme.getCurrency()));
            } else {
                selectors.add(currencyFieldKey);
            }
            filter.and(new QFilter(calculateDateField, "<", (Object)DateUtil.getStartOfDay(new Date())));
        }
        long getConfigAndFilterTime = System.currentTimeMillis();
        logger.info("\u8ba1\u7b97\u903e\u671f\u6570\u636e 2.\u89e3\u6790\u65b9\u6848\u6784\u9020\u67e5\u8be2\u6761\u4ef6\uff1a" + new Date(getConfigAndFilterTime) + " \u8017\u65f6\uff1a" + (getConfigAndFilterTime - queryOverdueBeginTime) + " ms");
        DataSet bills = QueryServiceHelper.queryDataSet((String)"ccm.RuleBasedOverdueCalculator.queryoverdue", (String)assingEntityKey, (String)String.join((CharSequence)",", selectors), (QFilter[])new QFilter[]{filter}, null);
        DataSet processedBills = null;
        long queryBillTime = System.currentTimeMillis();
        logger.info("\u8ba1\u7b97\u903e\u671f\u6570\u636e 3.\u67e5\u8be2\u5355\u636edataset\uff1a" + new Date(queryBillTime) + " \u8017\u65f6\uff1a" + (queryBillTime - getConfigAndFilterTime) + " ms");
        DataSet billscopy = bills.copy();
        if ("overdueamt".equals(quotaType)) {
            if (!isSingleCurrencyControl) {
                RowMeta rowMeta = billscopy.getRowMeta();
                DataSetBuilder newBillsBuilder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(rowMeta);
                Long schemeCurrencyId = scheme.getCurrency();
                Long schemeExchangeRateTableId = scheme.getExchangeRateTable();
                for (Object bill : billscopy) {
                    Object[] newRow = new Object[rowMeta.getFieldCount()];
                    BigDecimal actual_overdueamt = BigDecimal.ZERO;
                    BigDecimal bill_overdueamt = bill.getBigDecimal(calculateAmtField);
                    Long billCurrencyId = bill.getLong(currencyFieldKey);
                    if (schemeCurrencyId.longValue() != billCurrencyId.longValue()) {
                        BigDecimal bigDecimal = this.getExChangeRate(billCurrencyId, schemeCurrencyId, schemeExchangeRateTableId, new Date());
                        if (bigDecimal != null) {
                            actual_overdueamt = bill_overdueamt.multiply(bigDecimal);
                        }
                    } else {
                        actual_overdueamt = bill_overdueamt;
                    }
                    for (String fieldName : rowMeta.getFieldNames()) {
                        int fieldIndex = rowMeta.getFieldIndex(fieldName);
                        newRow[fieldIndex] = calculateAmtField.endsWith(fieldName) ? actual_overdueamt : bill.get(fieldName);
                    }
                    newBillsBuilder.append(newRow);
                }
                processedBills = newBillsBuilder.build().groupBy(billRoleFields.toArray(new String[0])).sum(calculateAmtField).finish();
                long calExchangeAmoutTime = System.currentTimeMillis();
                logger.info("\u8ba1\u7b97\u903e\u671f\u6570\u636e 4.\u975e\u5e01\u522b\u9694\u79bb\u8fdb\u884c\u91d1\u989d\u6362\u7b97\u5e76\u6c47\u603b\uff1a" + new Date(calExchangeAmoutTime) + " \u8017\u65f6\uff1a" + (calExchangeAmoutTime - queryBillTime) + " ms");
            } else {
                long calSumAmtBeginTime = System.currentTimeMillis();
                processedBills = bills.groupBy(billRoleFields.toArray(new String[0])).sum(calculateAmtField).finish();
                long calSumAmtEndTime = System.currentTimeMillis();
                logger.info("\u8ba1\u7b97\u903e\u671f\u6570\u636e 4.\u5e01\u522b\u9694\u79bb\u4e0d\u7528\u6362\u7b97\u76f4\u63a5\u6c47\u603b\uff1a" + new Date(calSumAmtEndTime) + " \u8017\u65f6\uff1a" + (calSumAmtEndTime - calSumAmtBeginTime) + " ms");
            }
        } else {
            processedBills = bills.groupBy(billRoleFields.toArray(new String[0])).min(calculateDateField).finish();
            long calMinDayEndTime = System.currentTimeMillis();
            logger.info("\u8ba1\u7b97\u903e\u671f\u6570\u636e 4.\u8ba1\u7b97\u6700\u5c0f\u903e\u671f\u5929\u6570\uff1a" + new Date(calMinDayEndTime) + " \u8017\u65f6\uff1a" + (calMinDayEndTime - queryBillTime) + " ms");
        }
        long buildOverdueResultBeginTime = System.currentTimeMillis();
        for (Row row : processedBills) {
            DimensionValue dimensionValue = new DimensionValue(scheme.getDimension());
            for (Role role : roles) {
                MainEntityType assEntityType;
                Field roleField = entityConfig.getRoleField(role.getRoleType());
                if (cusunicodeId != 0L) {
                    dimensionValue.putValue(role, cusunicodeId);
                    continue;
                }
                String roleFieldKey = roleField.getKey();
                String roleBDEntityKey = role.getBasedataEntityKey();
                MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)roleBDEntityKey);
                if (mainEntityType != null && mainEntityType.findProperty("masterid") != null && (assEntityType = MetadataServiceHelper.getDataEntityType((String)assingEntityKey)).getProperty(roleField.getKey()) instanceof BasedataProp) {
                    roleFieldKey = roleFieldKey + ".masterid";
                }
                if (roleField.getEntryKey() == null) {
                    dimensionValue.putValue(role, row.get(roleFieldKey));
                    continue;
                }
                dimensionValue.putValue(role, row.get(roleField.getEntryKey() + "." + roleFieldKey));
            }
            if ("overdueamt".equals(quotaType)) {
                results.put(dimensionValue, row.getBigDecimal(calculateAmtField));
                continue;
            }
            if (!"days".equals(quotaType)) continue;
            QFilter dateFilter = new QFilter(calculateDateField, "=", (Object)row.getDate(calculateDateField));
            DynamicObject bill = QueryServiceHelper.queryOne((String)assingEntityKey, (String)"billno", (QFilter[])new QFilter[]{filter, dateFilter});
            if (!ObjectUtils.isEmpty((Object)bill)) {
                billnos.put(dimensionValue, bill.getString("billno"));
            }
            BigDecimal diffDays = BigDecimal.valueOf(DateUtil.getDiffDays(row.getDate(calculateDateField), new Date()));
            results.put(dimensionValue, diffDays);
        }
        long buildOverdueResultEndTime = System.currentTimeMillis();
        logger.info("\u8ba1\u7b97\u903e\u671f\u6570\u636e 5.\u6c47\u603b\uff1a" + new Date(buildOverdueResultEndTime) + " \u8017\u65f6\uff1a" + (buildOverdueResultEndTime - buildOverdueResultBeginTime) + " ms");
        for (Map.Entry entry : billnos.entrySet()) {
            OverDueDayHelper.cacheOverdueDayDetailBillno(scheme, (DimensionValue)entry.getKey(), (String)entry.getValue());
        }
        return results;
    }

    private BigDecimal getExChangeRate(Long srcCurId, Long tarCurId, Long exRateTableId, Date date) {
        BigDecimal exchangeRate = BigDecimal.ZERO;
        if (srcCurId == null || tarCurId == null || exRateTableId == null || date == null) {
            return exchangeRate;
        }
        exchangeRate = srcCurId.equals(tarCurId) ? BigDecimal.ONE : BaseDataServiceHelper.getExchangeRate((Long)exRateTableId, (Long)srcCurId, (Long)tarCurId, (Date)date);
        return exchangeRate;
    }

    @Override
    public void close() throws Exception {
        this.iCreditEntityConService = null;
    }
}

