/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.service.checkexecutor;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ccm.business.helper.OverDueDayHelper;
import kd.scmc.ccm.business.pojo.CheckResult;
import kd.scmc.ccm.business.pojo.CreditScheme;
import kd.scmc.ccm.business.pojo.journal.Journal;
import kd.scmc.ccm.business.pojo.journal.JournalGroup;
import kd.scmc.ccm.business.service.archive.ArchiveCollection;
import kd.scmc.ccm.business.service.archive.CreditArchive;
import kd.scmc.ccm.business.service.checkexecutor.CreditChecker;

public class OverdueChecker
implements CreditChecker {
    @Override
    public CheckResult check(JournalGroup journalGroup, ArchiveCollection archives) {
        CreditScheme scheme = journalGroup.getScheme();
        String quotaType = scheme.getQuotaType().getQuotaType();
        String entityKey = journalGroup.getMainEntityKey();
        CheckResult result = new CheckResult(scheme, entityKey);
        result.setSuccess(true);
        Map<Object, Object> privilegeDayMap = new HashMap(8);
        if ("days".equals(quotaType)) {
            privilegeDayMap = this.calPrivilegeDay(journalGroup);
        }
        for (Journal journal : journalGroup.getJournals()) {
            CreditArchive archive = (CreditArchive)archives.get(journal.getDimensionValue());
            if (archive == null) continue;
            int maxOverdue = archive.getQuota().intValue();
            int currentOverdue = 0 - archive.getBalance().intValue();
            int privilegeDay = 0;
            if (!ObjectUtils.isEmpty(privilegeDayMap)) {
                privilegeDay = (Integer)privilegeDayMap.get(journal.getBillId());
                currentOverdue -= privilegeDay;
            }
            result.setBillno(journal.getBillNo());
            if (currentOverdue <= 0) continue;
            String overdueBillno = OverDueDayHelper.getOverdueDayDetailBillno(scheme, journal.getDimensionValue());
            result.setSuccess(false);
            if ("days".equals(quotaType)) {
                if (privilegeDay != 0) {
                    result.setMessage(String.format(ResManager.loadKDString((String)"\u4fe1\u7528\u63a7\u5236\u7ba1\u7406\u903e\u671f\u5929\u6570\u6821\u9a8c\uff0c\u5141\u8bb8\u903e\u671f%1$s\u5929\uff0c\u7279\u6279\u5929\u6570%2$s\u5929\uff0c\u5f53\u524d\u5df2\u7ecf\u903e\u671f%3$s\u5929\uff0c\u903e\u671f\u5355\u636e\u7f16\u53f7\u4e3a%4$s\u3002", (String)"OverdueChecker_0", (String)"scmc-ccm", (Object[])new Object[0]), maxOverdue, privilegeDay, currentOverdue + maxOverdue + privilegeDay, overdueBillno));
                } else {
                    result.setMessage(String.format(ResManager.loadKDString((String)"\u4fe1\u7528\u63a7\u5236\u7ba1\u7406\u903e\u671f\u5929\u6570\u6821\u9a8c\uff0c\u5141\u8bb8\u903e\u671f%1$s\u5929\uff0c\u5355\u636e\u201c%3$s\u201d\u5f53\u524d\u5df2\u903e\u671f%2$s\u5929\u3002", (String)"OverdueChecker_1", (String)"scmc-ccm", (Object[])new Object[0]), maxOverdue, currentOverdue + maxOverdue, overdueBillno));
                }
            } else if ("overdueamt".equals(quotaType)) {
                String messageTemplate = ResManager.loadKDString((String)"\u4fe1\u7528\u63a7\u5236\u7ba1\u7406\u903e\u671f\u91d1\u989d\u6821\u9a8c\uff0c\u5141\u8bb8\u903e\u671f\u989d\u5ea6%1$s%2$s\uff0c\u5f53\u524d\u8d85\u989d%3$s%4$s\u3002", (String)"OverdueChecker_2", (String)"scmc-ccm", (Object[])new Object[0]);
                DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((Object)scheme.getCurrency(), (String)"bd_currency");
                int precision = currency.getInt("amtprecision");
                String sign = currency.getString("sign");
                String displayQuota = BigDecimal.valueOf(maxOverdue).setScale(precision, RoundingMode.HALF_UP).toPlainString();
                String displayAmount = BigDecimal.valueOf(currentOverdue).setScale(precision, RoundingMode.HALF_UP).toPlainString();
                String message = String.format(messageTemplate, sign, displayQuota, sign, displayAmount);
                result.setMessage(message);
            }
            return result;
        }
        return result;
    }

    private Map<Long, Integer> calPrivilegeDay(JournalGroup journalGroup) {
        HashMap<Long, Integer> privilegeDayMap = new HashMap<Long, Integer>();
        Set billIdSet = journalGroup.getJournals().stream().map(Journal::getBillId).collect(Collectors.toSet());
        Set entityKeySet = journalGroup.getJournals().stream().map(Journal::getEntityKey).collect(Collectors.toSet());
        QFilter billIdFilter = new QFilter("billid", "in", billIdSet);
        QFilter entityKeyFilter = new QFilter("entitykey", "in", entityKeySet);
        QFilter quotaTypeFilter = new QFilter("quotatype", "=", (Object)"privilegeday");
        DynamicObjectCollection privilegeJournalInfo = QueryServiceHelper.query((String)"ccm_journal", (String)"billid,amount", (QFilter[])new QFilter[]{billIdFilter, entityKeyFilter, quotaTypeFilter});
        for (DynamicObject privilegeJournal : privilegeJournalInfo) {
            long billId = privilegeJournal.getLong("billid");
            int day = privilegeJournal.getInt("amount");
            if (privilegeDayMap.get(billId) != null) {
                privilegeDayMap.put(billId, (Integer)privilegeDayMap.get(billId) + day);
                continue;
            }
            privilegeDayMap.put(billId, day);
        }
        return privilegeDayMap;
    }
}

