/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.service.checkexecutor;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ccm.business.pojo.CheckResult;
import kd.scmc.ccm.business.pojo.CreditScheme;
import kd.scmc.ccm.business.pojo.journal.Journal;
import kd.scmc.ccm.business.pojo.journal.JournalGroup;
import kd.scmc.ccm.business.service.archive.ArchiveCollection;
import kd.scmc.ccm.business.service.archive.CreditArchive;
import kd.scmc.ccm.business.service.checkexecutor.CreditChecker;

public class QuotaCreditChecker
implements CreditChecker {
    @Override
    public CheckResult check(JournalGroup journalGroup, ArchiveCollection archives) {
        CreditScheme scheme = journalGroup.getScheme();
        String quotaType = scheme.getQuotaType().getQuotaType();
        String entityKey = journalGroup.getMainEntityKey();
        CheckResult result = new CheckResult(scheme, entityKey);
        result.setSuccess(true);
        result.setBillno(journalGroup.getBillNo());
        Map<Object, Object> privilegeAmtMap = new HashMap();
        if ("amount".equals(quotaType)) {
            privilegeAmtMap = this.calPrivilegeAmt(journalGroup);
        }
        for (Journal journal : journalGroup.getJournals()) {
            String directionMessage;
            BigDecimal privilegeAmt;
            CreditArchive archive = (CreditArchive)archives.get(journal.getDimensionValue());
            if (archive == null) continue;
            String direction = journal.getDirection();
            result.setDirection(direction);
            BigDecimal balance = archive.getBalance();
            if (!privilegeAmtMap.isEmpty() && (privilegeAmt = (BigDecimal)privilegeAmtMap.get(journal.getBillId())) != null) {
                balance = balance.add(privilegeAmt);
            }
            BigDecimal amount = "REDUCE".equals(direction) ? journal.getAmount() : journal.getAmount().negate();
            String string = directionMessage = "REDUCE".equals(direction) ? ResManager.loadKDString((String)"\u5360\u7528", (String)"QuotaCreditChecker_0", (String)"scmc-ccm", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8fd4\u8fd8", (String)"QuotaCreditChecker_1", (String)"scmc-ccm", (Object[])new Object[0]);
            if (amount.compareTo(balance) > 0) {
                result.setSuccess(false);
                String schemeName = scheme.getName();
                if ("amount".equals(quotaType) || "privilegeamt".equals(quotaType)) {
                    long currencyId = scheme.getCurrency();
                    DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency");
                    int precision = currency.getInt("amtprecision");
                    String sign = currency.getString("sign");
                    BigDecimal displayQuota = balance.setScale(precision, RoundingMode.HALF_UP);
                    BigDecimal displayAmount = journal.getAmount().setScale(precision, RoundingMode.HALF_UP);
                    BigDecimal receivableAmt = amount.subtract(balance).setScale(precision, RoundingMode.HALF_UP);
                    String message = String.format(ResManager.loadKDString((String)"\u5355\u636e\u5728\u4fe1\u63a7\u65b9\u6848\u201c%1$s\u201d\u4e2d\u5bf9\u5e94\u7684\u4fe1\u7528\u989d\u5ea6\u4e0d\u8db3\uff0c\u53ef\u7528\u989d\u5ea6\u4e3a%2$s%3$s\uff0c\u672c\u6b21%4$s\u989d\u5ea6\u4e3a%5$s%6$s\uff0c\u9700\u56de\u6b3e\u989d\u5ea6\u4e3a%7$s%8$s\u3002", (String)"QuotaCreditChecker_2", (String)"scmc-ccm", (Object[])new Object[0]), schemeName, sign, displayQuota, directionMessage, sign, displayAmount, sign, receivableAmt);
                    result.setBalance(balance);
                    result.setAmount(journal.getAmount());
                    result.setUnit(currencyId);
                    result.setMessage(message);
                } else if ("qty".equals(quotaType)) {
                    long unit = archive.getUnit();
                    DynamicObject measureUnit = BusinessDataServiceHelper.loadSingleFromCache((Object)unit, (String)"bd_measureunits");
                    int precision = 10;
                    if (measureUnit != null) {
                        precision = measureUnit.getInt("precision");
                    }
                    BigDecimal displayQuota = archive.getBalance().setScale(precision, RoundingMode.HALF_UP);
                    BigDecimal displayAmount = journal.getAmount().setScale(precision, RoundingMode.HALF_UP);
                    String message = String.format(ResManager.loadKDString((String)"\u5355\u636e\u5728\u4fe1\u63a7\u65b9\u6848\u201c%1$s\u201d\u4e2d\u5bf9\u5e94\u7684\u4fe1\u7528\u6570\u91cf\u4e0d\u8db3\uff0c\u53ef\u7528\u6570\u91cf\u4e3a%2$s\uff0c\u672c\u6b21%3$s\u6570\u91cf\u4e3a%4$s\u3002", (String)"QuotaCreditChecker_3", (String)"scmc-ccm", (Object[])new Object[0]), schemeName, displayQuota, directionMessage, displayAmount);
                    result.setBalance(archive.getBalance());
                    result.setAmount(journal.getAmount());
                    result.setUnit(unit);
                    result.setMessage(message);
                }
                return result;
            }
            if ("REDUCE".equals(direction)) {
                archive.reduceBalance(journal.getAmount());
                continue;
            }
            if (!"INCREASE".equals(direction)) continue;
            archive.increaseBalance(journal.getAmount());
        }
        return result;
    }

    private Map<Long, BigDecimal> calPrivilegeAmt(JournalGroup journalGroup) {
        HashMap<Long, BigDecimal> privilegeAmtMap = new HashMap<Long, BigDecimal>(16);
        Set billIdSet = journalGroup.getJournals().stream().map(Journal::getBillId).collect(Collectors.toSet());
        Set entityKeySet = journalGroup.getJournals().stream().map(Journal::getEntityKey).collect(Collectors.toSet());
        QFilter billIdFilter = new QFilter("billid", "in", billIdSet);
        QFilter entityKeyFilter = new QFilter("entitykey", "in", entityKeySet);
        QFilter quotaTypeFilter = new QFilter("quotatype", "=", (Object)"privilegeamt");
        DynamicObjectCollection privilegeJournalInfo = QueryServiceHelper.query((String)"ccm_journal", (String)"billid,amount", (QFilter[])new QFilter[]{billIdFilter, entityKeyFilter, quotaTypeFilter});
        for (DynamicObject privilegeJournal : privilegeJournalInfo) {
            long billId = privilegeJournal.getLong("billid");
            BigDecimal amount = privilegeJournal.getBigDecimal("amount");
            BigDecimal amountSum = (BigDecimal)privilegeAmtMap.get(billId);
            if (amountSum != null) {
                amount = amountSum.add(amount);
            }
            privilegeAmtMap.put(billId, amount);
        }
        return privilegeAmtMap;
    }
}

