/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.service.entityconfig;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.ccm.business.pojo.CreditElement;
import kd.scmc.ccm.business.pojo.EntityConfig;
import kd.scmc.ccm.business.pojo.Field;
import kd.scmc.ccm.business.service.entityconfig.ICreditEntityConService;

public class CreditEntityConServiceImpl
implements ICreditEntityConService {
    private static final Log logger = LogFactory.getLog(CreditEntityConServiceImpl.class);
    public Map<String, EntityConfig> entityConfigCache = new HashMap<String, EntityConfig>();

    @Override
    public EntityConfig readConfig(String entityKey) {
        EntityConfig entityConfig = this.entityConfigCache.get(entityKey);
        if (entityConfig != null) {
            return entityConfig;
        }
        DynamicObject entityConfigObj = BusinessDataServiceHelper.loadSingleFromCache((Object)entityKey, (String)"ccm_entityconfig");
        entityConfig = this.convertDynToObj(entityConfigObj);
        if (entityConfig != null) {
            this.entityConfigCache.put(entityKey, entityConfig);
        }
        logger.info("\u8868\u5355\uff1a{}\u67e5\u8be2\u7684\u5b9e\u4f53\u914d\u7f6e\u4fe1\u606f\u5982\u4e0b\uff1a{}:", (Object)entityKey, (Object)entityConfig);
        return entityConfig;
    }

    @Override
    public List<EntityConfig> readConfigList(List<String> entityKeyList) {
        Map entityConfigs = BusinessDataServiceHelper.loadFromCache((Object[])entityKeyList.toArray(new String[0]), (String)"ccm_entityconfig");
        ArrayList<EntityConfig> configs = new ArrayList<EntityConfig>(16);
        entityConfigs.values().forEach(billSetting -> configs.add(this.convertDynToObj((DynamicObject)billSetting)));
        for (String entityKey : entityKeyList) {
            boolean isMatch = false;
            for (EntityConfig config : configs) {
                if (!entityKey.equals(config.getEntityKey())) continue;
                isMatch = true;
                break;
            }
            if (isMatch) continue;
            throw new KDBizException("None credit setting was found,entityKey=" + entityKey);
        }
        return configs;
    }

    public EntityConfig convertDynToObj(DynamicObject billSetting) {
        DynamicObjectCollection selectorsEntry;
        String entityKey = billSetting.getString("number");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityKey);
        EntityConfig config = EntityConfig.doCreate(entityKey);
        String orgKey = billSetting.getString("orgkey");
        Field orgField = this.createField(orgKey, dataEntityType);
        config.setField(CreditElement.ELEMENT_ORG, orgField);
        String currencyKey = billSetting.getString("currencykey");
        Field currencyField = this.createField(currencyKey, dataEntityType);
        config.setField(CreditElement.ELEMENT_CURRENCY, currencyField);
        DynamicObjectCollection dimensionEntry = billSetting.getDynamicObjectCollection("dimensions");
        if (!dimensionEntry.isEmpty()) {
            for (DynamicObject dimSettingRow : dimensionEntry) {
                DynamicObject role = dimSettingRow.getDynamicObject("role");
                if (role == null) continue;
                String roleKey = dimSettingRow.getString("rolekey");
                Field roleField = this.createField(roleKey, dataEntityType);
                CreditElement element = new CreditElement(CreditElement.ElementType.ROLE, role.getString("number").toUpperCase());
                config.setField(element, roleField);
            }
        }
        if ((selectorsEntry = billSetting.getDynamicObjectCollection("selectors")).isEmpty()) {
            config.setSelectors(Collections.EMPTY_SET);
        } else {
            Set<String> selectors = selectorsEntry.stream().map(row -> row.getString("field")).collect(Collectors.toSet());
            config.setSelectors(selectors);
        }
        return config;
    }

    private Field createField(String key, MainEntityType dataEntityType) {
        return new Field(key, dataEntityType);
    }
}

