/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.service.journal;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Set;
import kd.bos.audit.Audit;
import kd.bos.audit.Auditable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scmc.ccm.business.pojo.CreditScheme;
import kd.scmc.ccm.business.pojo.QuotaType;
import kd.scmc.ccm.business.pojo.journal.Journal;
import kd.scmc.ccm.business.pojo.journal.JournalGroup;
import kd.scmc.ccm.business.pojo.log.CreditLogCollectInfo;
import kd.scmc.ccm.business.service.journal.ICreditJournalCreateService;
import kd.scmc.ccm.business.service.journal.builder.OverdueDayJournalBuilder;
import kd.scmc.ccm.business.service.journal.builder.RuleBasedJournalBuilder;
import kd.scmc.ccm.business.service.journal.reader.JournalReader;
import kd.scmc.ccm.common.util.CreditContext;

public class CreditJournalCreateServiceImpl
implements ICreditJournalCreateService {
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern(TimeServiceHelper.getDateTimeFormatString());
    private static final Log logger = LogFactory.getLog(CreditJournalCreateServiceImpl.class);
    private CreditScheme scheme;
    private CreditContext context;

    @Override
    public List<JournalGroup> buildJournals(List<DynamicObject> bills) {
        logger.info("credit buildjournals begin: {}", (Object)formatter.format(LocalDateTime.now()));
        try (Auditable audit = Audit.audit((String)"ccm.buildjournals", (Object[])new Object[0]);){
            QuotaType quotaTypeObj = this.scheme.getQuotaType();
            String quotaType = quotaTypeObj.getQuotaType();
            boolean isOverduDay = quotaType.equals("days") || quotaType.equals("overdueamt");
            RuleBasedJournalBuilder journalBuilder = isOverduDay ? new OverdueDayJournalBuilder(this.scheme, this.context) : new RuleBasedJournalBuilder(this.scheme, this.context);
            List<JournalGroup> journalGroupList = journalBuilder.buildJournals(bills);
            logger.info("credit buildjournals end: {}", (Object)formatter.format(LocalDateTime.now()));
            this.writeCreateJournalLog(journalGroupList);
            List<JournalGroup> list = journalGroupList;
            return list;
        }
    }

    @Override
    public List<JournalGroup> loadJournals(String op, Set<Long> billIds) {
        try (Auditable audit = Audit.audit((String)"ccm.loadjournals", (Object[])new Object[0]);){
            List<JournalGroup> journalGroupList = new JournalReader().loadJournals(this.scheme, this.context.getEntityKey(), op, billIds);
            logger.info("credit loadJournals is:{}", journalGroupList);
            this.writeCreateJournalLog(journalGroupList);
            List<JournalGroup> list = journalGroupList;
            return list;
        }
    }

    public CreditJournalCreateServiceImpl(CreditScheme scheme, CreditContext context) {
        this.scheme = scheme;
        this.context = context;
    }

    public static CreditJournalCreateServiceImpl doCreate(CreditScheme scheme, CreditContext context) {
        return new CreditJournalCreateServiceImpl(scheme, context);
    }

    @Override
    public void close() throws Exception {
    }

    private void writeCreateJournalLog(List<JournalGroup> journalGroupList) {
        boolean flag = false;
        for (JournalGroup group : journalGroupList) {
            List<Journal> journals = group.getJournals();
            if (journals.size() <= 0) continue;
            flag = true;
            break;
        }
        if (flag) {
            CreditLogCollectInfo.collectCreditLogInfo("creditjournal".concat("$$").concat(this.scheme.getNumber()), journalGroupList);
        } else {
            CreditLogCollectInfo.collectCreditLogInfo("creditjournal".concat("$$").concat(this.scheme.getNumber()), ResManager.loadKDString((String)"\u5355\u636e\u7b56\u7565\u53d6\u503c\u8fc7\u7a0b\u672a\u80fd\u5339\u914d\u751f\u6210\u6d41\u6c34\u3002", (String)"CreditJournalCreateServiceImpl_0", (String)"scmc-ccm", (Object[])new Object[0]));
        }
        logger.info("credit buildjournals is:{}", (Object)journalGroupList.size());
    }
}

