/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.service.journal.builder;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ccm.business.formulavalue.DimensionValueGetter;
import kd.scmc.ccm.business.formulavalue.ValueGetter;
import kd.scmc.ccm.business.helper.DimensionEntryFieldMapper;
import kd.scmc.ccm.business.pojo.CompositeKey;
import kd.scmc.ccm.business.pojo.CreditElement;
import kd.scmc.ccm.business.pojo.CreditScheme;
import kd.scmc.ccm.business.pojo.Dimension;
import kd.scmc.ccm.business.pojo.DimensionValue;
import kd.scmc.ccm.business.pojo.EntityConfig;
import kd.scmc.ccm.business.pojo.Field;
import kd.scmc.ccm.business.pojo.QuotaType;
import kd.scmc.ccm.business.pojo.Role;
import kd.scmc.ccm.business.pojo.exprfilter.CreditFormula;
import kd.scmc.ccm.business.pojo.exprfilter.Expression;
import kd.scmc.ccm.business.pojo.journal.Journal;
import kd.scmc.ccm.business.pojo.journal.JournalGroup;
import kd.scmc.ccm.business.service.journal.builder.CacheableExchangeRateLoader;
import kd.scmc.ccm.business.service.journal.builder.JournalBuilder;
import kd.scmc.ccm.common.util.CreditContext;

public class RuleBasedJournalBuilder
implements JournalBuilder {
    private CreditScheme scheme;
    private CreditContext context;
    private CacheableExchangeRateLoader rateLoader = new CacheableExchangeRateLoader();
    private DimensionValueGetter dimensionValueGetter;
    private Date rateDate = new Date();

    public RuleBasedJournalBuilder(CreditScheme scheme, CreditContext context) {
        this.scheme = scheme;
        this.context = context;
        this.dimensionValueGetter = new DimensionValueGetter(scheme, context);
    }

    @Override
    public List<JournalGroup> buildJournals(List<DynamicObject> bills) {
        LinkedList<JournalGroup> journalGroups = new LinkedList<JournalGroup>();
        for (DynamicObject bill : bills) {
            JournalGroup journalGroup = this.buildJournals(bill);
            this.groupBy(journalGroup);
            journalGroups.add(journalGroup);
        }
        return journalGroups;
    }

    public JournalGroup buildJournals(DynamicObject bill) {
        JournalGroup journalGroup = new JournalGroup();
        journalGroup.setScheme(this.scheme);
        journalGroup.setBillNo(bill.getString("billno"));
        journalGroup.setMainBillId(bill.getLong("id"));
        journalGroup.setMainEntityKey(this.context.getEntityKey());
        ArrayList<Journal> journals = new ArrayList<Journal>();
        journalGroup.setJournals(journals);
        EntityConfig config = this.scheme.getEntityConfig(this.context);
        String entryKey = this.getEntryKey(config);
        if (entryKey == null) {
            Journal journal;
            Expression expression = this.matchExpressionByBill(bill);
            if (expression != null && (journal = this.createJournal(bill, null, expression)) != null) {
                journals.add(journal);
            }
        } else {
            DynamicObjectCollection entry = bill.getDynamicObjectCollection(entryKey);
            for (DynamicObject row : entry) {
                Journal journal;
                Expression expression = this.matchExpressionByRow(row);
                if (expression == null || (journal = this.createJournal(bill, row, expression)) == null) continue;
                journals.add(journal);
            }
        }
        return journalGroup;
    }

    private Journal createJournal(DynamicObject bill, DynamicObject row, Expression expression) {
        Field orgField;
        Object orgObj;
        EntityConfig entityConfig = this.scheme.getEntityConfig(this.context);
        Journal journal = new Journal();
        journal.setMainBillId(bill.getLong("id"));
        journal.setMainEntityKey(this.context.getEntityKey());
        journal.setScheme(this.scheme);
        journal.setBillNo(bill.getString("billno"));
        journal.setBillId(bill.getLong("id"));
        journal.setAction(this.context.getCreditAction());
        journal.setDirection(expression.getDirection().name());
        journal.setOp(this.context.getOperateKey());
        journal.setEntityKey(bill.getDataEntityType().getName());
        if (row != null) {
            journal.setEntryKey(row.getDataEntityType().getName());
            journal.setEntryId(row.getLong("id"));
        }
        if ((orgObj = this.getValue(bill, row, orgField = entityConfig.getOrgField(), this.getValueGetter(this.scheme, CreditElement.ELEMENT_ORG))) instanceof DynamicObject) {
            journal.setOrg(((DynamicObject)orgObj).getLong("id"));
        } else {
            journal.setOrg((Long)orgObj);
        }
        QuotaType quotaType = this.scheme.getQuotaType();
        ValueGetter quotaValueGetter = expression.getValueGetter();
        journal.setQuotaType(quotaType.getQuotaType());
        BigDecimal originalQuota = BigDecimal.ZERO;
        originalQuota = row != null ? (BigDecimal)quotaValueGetter.get(row) : (BigDecimal)quotaValueGetter.get(bill);
        DimensionValue dimensionValue = null;
        dimensionValue = row != null ? (DimensionValue)this.dimensionValueGetter.get(row) : (DimensionValue)this.dimensionValueGetter.get(bill);
        journal.setDimensionValue(dimensionValue);
        journal.setOriginalAmount(originalQuota);
        if ("amount".equals(quotaType.getQuotaType()) || "privilegeamt".equals(quotaType.getQuotaType())) {
            if (originalQuota.compareTo(BigDecimal.ZERO) == 0) {
                return null;
            }
            Field currencyField = entityConfig.getCurrencyField();
            ValueGetter currencyValueGetter = this.getValueGetter(this.scheme, CreditElement.ELEMENT_CURRENCY);
            Object currencyObj = this.getValue(bill, row, currencyField, currencyValueGetter);
            long currency = 0L;
            currency = currencyObj instanceof DynamicObject ? ((DynamicObject)currencyObj).getLong("id") : ((Long)currencyObj).longValue();
            journal.setOriginalUnit(currency);
            journal.setUnit(this.scheme.getCurrency());
            BigDecimal exchangeRate = this.getRate(currency, this.scheme.getCurrency(), this.scheme.getExchangeRateTable(), this.rateDate);
            journal.setConversionRate(exchangeRate);
            BigDecimal quota = originalQuota.multiply(exchangeRate);
            journal.setAmount(quota);
        } else if ("qty".equals(quotaType.getQuotaType())) {
            Dimension dimension = this.scheme.getDimension();
            List<Role> roles = dimension.getRoles();
            Map<Role, Object> valueMap = dimensionValue.getValueMap();
            DimensionEntryFieldMapper mapper = new DimensionEntryFieldMapper(dimension.getId());
            List<String> fieldTypeKeys = mapper.getFieldTypeKeys();
            for (int i = 0; i < roles.size(); ++i) {
                if (!"bd_material".equals(mapper.getBaseDataKey(fieldTypeKeys.get(i)))) continue;
                Object materialId = valueMap.get(roles.get(i));
                DynamicObject material = QueryServiceHelper.queryOne((String)"bd_material", (String)"baseunit", (QFilter[])new QFilter[]{new QFilter("id", "=", materialId)});
                journal.setUnit(material.getLong("baseunit"));
                break;
            }
            journal.setAmount(originalQuota);
        } else {
            journal.setAmount(originalQuota);
        }
        return journal;
    }

    private void groupBy(JournalGroup journalGroup) {
        List<Journal> journals = journalGroup.getJournals();
        HashMap<CompositeKey, Journal> journalMap = new HashMap<CompositeKey, Journal>();
        for (Journal journal : journals) {
            CompositeKey compositeKey = new CompositeKey(new Object[0]);
            compositeKey.addKey(journal.getOrg());
            compositeKey.addKey(journal.getDimensionValue());
            compositeKey.addKey(journal.getOriginalUnit());
            compositeKey.addKey(journal.getQuotaType());
            compositeKey.addKey(journal.getConversionRate());
            Journal journal3 = (Journal)journalMap.get(compositeKey);
            if (journal3 != null) {
                journal3.setOriginalAmount(journal3.getOriginalAmount().add(journal.getOriginalAmount()));
                journal3.setAmount(journal3.getAmount().add(journal.getAmount()));
                continue;
            }
            journalMap.put(compositeKey, journal);
        }
        journalGroup.setJournals(new LinkedList<Journal>(journalMap.values()));
    }

    private String getEntryKey(EntityConfig entityConfig) {
        Field orgField = entityConfig.getOrgField();
        if (orgField.getEntryKey() != null) {
            return orgField.getEntryKey();
        }
        Field currencyField = entityConfig.getCurrencyField();
        if (currencyField.getEntryKey() != null) {
            return currencyField.getEntryKey();
        }
        Map<String, Field> creditRolesKeyMap = entityConfig.getCreditRolesKeyMap();
        for (Role role : this.scheme.getDimension().getRoles()) {
            Field field = creditRolesKeyMap.get(role.getRoleType());
            if (field.getEntryKey() == null) continue;
            return field.getEntryKey();
        }
        List<Expression> expressions = this.scheme.getExpressions(this.context);
        for (Expression exp : expressions) {
            List<Field> refFields = exp.getCondition().getFields();
            for (Field field : refFields) {
                if (field.getEntryKey() == null) continue;
                return field.getEntryKey();
            }
            CreditFormula formula = exp.getFormula();
            if (formula == null) continue;
            refFields = formula.getFields();
            for (Field field : refFields) {
                if (field.getEntryKey() == null) continue;
                return field.getEntryKey();
            }
        }
        return null;
    }

    private Object getValue(DynamicObject bill, DynamicObject row, Field field, ValueGetter fieldValueGetter) {
        if (field.getEntryKey() != null) {
            return fieldValueGetter.get(row);
        }
        return fieldValueGetter.get(bill);
    }

    private ValueGetter getValueGetter(CreditScheme scheme2, CreditElement element) {
        return scheme2.getValueGetter(this.getContext(), element);
    }

    private Expression matchExpressionByBill(DynamicObject bill) {
        List<Expression> expressions = this.scheme.getExpressions(this.getContext());
        for (Expression exp : expressions) {
            if (!exp.getFilter().isBillMatch(bill)) continue;
            return exp;
        }
        return null;
    }

    private Expression matchExpressionByRow(DynamicObject row) {
        List<Expression> expressions = this.scheme.getExpressions(this.getContext());
        for (Expression exp : expressions) {
            if (!exp.getFilter().isRowMatch(row)) continue;
            return exp;
        }
        return null;
    }

    private BigDecimal getRate(long srcCurrencyId, long targetCurrencyId, long exchangeRateTableId, Date rateDate) {
        BigDecimal rate = this.rateLoader.getRate(srcCurrencyId, targetCurrencyId, exchangeRateTableId, rateDate);
        if (rate != null) {
            return rate;
        }
        DynamicObject srcCurrency = BusinessDataServiceHelper.loadSingleFromCache((Object)srcCurrencyId, (String)"bd_currency");
        DynamicObject targetCurrency = BusinessDataServiceHelper.loadSingleFromCache((Object)targetCurrencyId, (String)"bd_currency");
        DynamicObject exchangeRateTable = BusinessDataServiceHelper.loadSingleFromCache((Object)exchangeRateTableId, (String)"bd_exratetable");
        String srcCurrencyName = srcCurrency == null ? "" : srcCurrency.getString("name");
        String targetCurrencyName = targetCurrency == null ? "" : targetCurrency.getString("name");
        String rateTableName = exchangeRateTable == null ? "" : exchangeRateTable.getString("name");
        String message = String.format(ResManager.loadKDString((String)"\u4fe1\u7528\u989d\u5ea6\u6298\u7b97\u5931\u8d25\uff0c\u6c47\u7387\u8868\u6ca1\u6709\u7ef4\u62a4\u5bf9\u5e94\u7684\u6c47\u7387\uff0c\u539f\u5e01\u4e3a%1$s\uff0c\u76ee\u6807\u5e01\u4e3a%2$s\uff0c\u6c47\u7387\u8868\u4e3a%3$s\u3002", (String)"RuleBasedJournalBuilder_0", (String)"scmc-ccm", (Object[])new Object[0]), srcCurrencyName, targetCurrencyName, rateTableName);
        throw new KDBizException(message);
    }

    public CreditScheme getScheme() {
        return this.scheme;
    }

    public void setScheme(CreditScheme scheme) {
        this.scheme = scheme;
    }

    public CreditContext getContext() {
        return this.context;
    }

    public void setContext(CreditContext context) {
        this.context = context;
    }
}

