/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.service.journal.reader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ccm.business.pojo.CreditScheme;
import kd.scmc.ccm.business.pojo.DimensionValue;
import kd.scmc.ccm.business.pojo.journal.Journal;
import kd.scmc.ccm.business.pojo.journal.JournalGroup;

public class JournalReader {
    public List<JournalGroup> loadJournals(CreditScheme scheme, String mainEntityKey, String op, Set<Long> mainBillIds) {
        QFilter billIdFilter = new QFilter("mainbillid", "in", mainBillIds);
        QFilter entityFilter = new QFilter("mainentitykey", "=", (Object)mainEntityKey);
        QFilter opFilter = new QFilter("op", "in", (Object)new String[]{op, "", " "});
        QFilter schemeFilter = new QFilter("scheme", "=", (Object)scheme.getId());
        QFilter[] journalFilters = new QFilter[]{billIdFilter, entityFilter, opFilter, schemeFilter};
        String selectors = String.join((CharSequence)",", this.getJournalSelectors());
        DynamicObjectCollection rawJournals = QueryServiceHelper.query((String)"ccm_journal", (String)selectors, (QFilter[])journalFilters);
        List<JournalGroup> journalGroups = this.readJournals0(scheme, (Collection<DynamicObject>)rawJournals);
        this.handleRecalculateJournals(op, journalGroups);
        return new ArrayList<JournalGroup>(journalGroups);
    }

    private void handleRecalculateJournals(String op, List<JournalGroup> journalGroups) {
        for (JournalGroup journalGroup : journalGroups) {
            List<Journal> journals = journalGroup.getJournals();
            boolean existsOpJournal = false;
            for (Journal journal : journals) {
                if (!Objects.equals(journal.getOp(), op)) continue;
                existsOpJournal = true;
                break;
            }
            if (!existsOpJournal) continue;
            Iterator<Journal> iterator = journals.iterator();
            while (iterator.hasNext()) {
                Journal journal;
                journal = iterator.next();
                if (!StringUtils.isBlank((CharSequence)journal.getOp())) continue;
                iterator.remove();
            }
        }
    }

    public List<JournalGroup> loadJournals(CreditScheme scheme, String mainEntityKey, Set<Long> mainBillIds) {
        QFilter billIdFilter = new QFilter("mainbillid", "in", mainBillIds);
        QFilter entityFilter = new QFilter("mainentitykey", "=", (Object)mainEntityKey);
        QFilter schemeFilter = new QFilter("scheme", "=", (Object)scheme.getId());
        QFilter[] journalFilters = new QFilter[]{billIdFilter, entityFilter, schemeFilter};
        String selectors = String.join((CharSequence)",", this.getJournalSelectors());
        DynamicObjectCollection rawJournals = QueryServiceHelper.query((String)"ccm_journal", (String)selectors, (QFilter[])journalFilters);
        return this.readJournals0(scheme, (Collection<DynamicObject>)rawJournals);
    }

    public List<JournalGroup> loadJournals(CreditScheme scheme, Set<Long> archiveIds, String action) {
        QFilter schemeFilter = new QFilter("scheme", "=", (Object)scheme.getId());
        QFilter archiveFilter = new QFilter("archiveid", "in", archiveIds);
        QFilter actionFilter = new QFilter("action", "=", (Object)action);
        QFilter[] journalFilters = new QFilter[]{schemeFilter, archiveFilter, actionFilter};
        String selectors = String.join((CharSequence)",", this.getJournalSelectors());
        DynamicObjectCollection rawJournals = QueryServiceHelper.query((String)"ccm_journal", (String)selectors, (QFilter[])journalFilters);
        return this.readJournals0(scheme, (Collection<DynamicObject>)rawJournals);
    }

    public JournalGroup loadJournal(CreditScheme scheme, Long journalId) {
        QFilter idFilter = new QFilter("id", "=", (Object)journalId);
        QFilter schemeFilter = new QFilter("scheme", "=", (Object)scheme.getId());
        QFilter[] journalFilters = new QFilter[]{idFilter, schemeFilter};
        String selectors = String.join((CharSequence)",", this.getJournalSelectors());
        DynamicObjectCollection rawJournals = QueryServiceHelper.query((String)"ccm_journal", (String)selectors, (QFilter[])journalFilters);
        List<JournalGroup> journals = this.readJournals0(scheme, (Collection<DynamicObject>)rawJournals);
        if (journals.isEmpty()) {
            return null;
        }
        return journals.get(0);
    }

    private List<JournalGroup> readJournals0(CreditScheme scheme, Collection<DynamicObject> rawJournals) {
        HashMap<Long, JournalGroup> journalGroups = new HashMap<Long, JournalGroup>();
        for (DynamicObject rawJournal : rawJournals) {
            Journal journal = this.dymToJournal(rawJournal, scheme);
            JournalGroup journalGroup = (JournalGroup)journalGroups.get(journal.getBillId());
            if (journalGroup == null) {
                journalGroup = new JournalGroup();
                journalGroup.setScheme(journal.getScheme());
                journalGroup.setMainBillId(journal.getBillId());
                journalGroup.setBillNo(journal.getBillNo());
                journalGroup.setMainEntityKey(journal.getEntityKey());
                journalGroups.put(journal.getBillId(), journalGroup);
            }
            journalGroup.getJournals().add(journal);
        }
        return new ArrayList<JournalGroup>(journalGroups.values());
    }

    private Journal dymToJournal(DynamicObject rawJournal, CreditScheme scheme) {
        Journal journal = new Journal();
        journal.setBillId(rawJournal.getLong("billid"));
        journal.setEntityKey(rawJournal.getString("entitykey"));
        journal.setEntryKey(rawJournal.getString("entrykey"));
        journal.setEntryId(rawJournal.getLong("entryid"));
        journal.setBillNo(rawJournal.getString("billno"));
        journal.setMainBillId(rawJournal.getLong("mainbillid"));
        journal.setMainEntityKey(rawJournal.getString("mainentitykey"));
        journal.setJournalId(rawJournal.getLong("id"));
        journal.setArchiveId(rawJournal.getLong("archiveid"));
        journal.setOriginalAmount(rawJournal.getBigDecimal("originalamount"));
        journal.setOriginalUnit(rawJournal.getLong("originalunit"));
        journal.setConversionRate(rawJournal.getBigDecimal("conversionrate"));
        journal.setUnit(rawJournal.getLong("unit"));
        journal.setAmount(rawJournal.getBigDecimal("amount"));
        journal.setQuotaType(rawJournal.getString("quotatype"));
        journal.setScheme(scheme);
        DimensionValue dimensionValue = new DimensionValue(scheme.getDimension());
        dimensionValue.setValue(rawJournal.getString("dimensionvalue"));
        journal.setDimensionValue(dimensionValue);
        journal.setAction(rawJournal.getString("action"));
        journal.setOp(rawJournal.getString("op"));
        journal.setDirection(rawJournal.getString("direction"));
        return journal;
    }

    private List<String> getJournalSelectors() {
        LinkedList<String> selectors = new LinkedList<String>();
        selectors.add("id");
        selectors.add("scheme");
        selectors.add("dimension");
        selectors.add("dimensionvalue");
        selectors.add("archiveid");
        selectors.add("quotatype");
        selectors.add("originalunit");
        selectors.add("originalamount");
        selectors.add("conversionrate");
        selectors.add("unit");
        selectors.add("amount");
        selectors.add("entitykey");
        selectors.add("entrykey");
        selectors.add("billid");
        selectors.add("entryid");
        selectors.add("billno");
        selectors.add("mainbillid");
        selectors.add("mainentitykey");
        selectors.add("action");
        selectors.add("op");
        selectors.add("direction");
        return selectors;
    }
}

