/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.service.scheme;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.audit.Audit;
import kd.bos.audit.Auditable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRFormula;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.ccm.business.CreditServiceFactory;
import kd.scmc.ccm.business.formulavalue.AmountFormulaValueGetter;
import kd.scmc.ccm.business.formulavalue.ConstValueGettter;
import kd.scmc.ccm.business.helper.CreditSchemeValidatorHelper;
import kd.scmc.ccm.business.pojo.BillStrategy;
import kd.scmc.ccm.business.pojo.CreditScheme;
import kd.scmc.ccm.business.pojo.Dimension;
import kd.scmc.ccm.business.pojo.EntityConfig;
import kd.scmc.ccm.business.pojo.Field;
import kd.scmc.ccm.business.pojo.QuotaType;
import kd.scmc.ccm.business.pojo.Role;
import kd.scmc.ccm.business.pojo.exprfilter.CreditCondition;
import kd.scmc.ccm.business.pojo.exprfilter.CreditFormula;
import kd.scmc.ccm.business.pojo.exprfilter.Expression;
import kd.scmc.ccm.business.pojo.log.CreditLogCollectInfo;
import kd.scmc.ccm.business.prefilter.BillConditionFilter;
import kd.scmc.ccm.business.service.entityconfig.ICreditEntityConService;
import kd.scmc.ccm.business.service.scheme.AbstractCreditSchemeService;
import kd.scmc.ccm.common.enums.Direction;
import kd.scmc.ccm.common.util.CreditContext;

public class CreditSchemeServiceImpl
extends AbstractCreditSchemeService {
    private static final Log logger = LogFactory.getLog(CreditSchemeServiceImpl.class);
    private ICreditEntityConService iCreditEntityConService = CreditServiceFactory.doCreateCreditEntityConService();

    @Override
    public List<CreditScheme> getEffectiveCreditSchemeList() {
        Set<Long> billOrgIds = this.getBillOrgIds();
        LinkedList<CreditScheme> usefulSchemeList = new LinkedList<CreditScheme>();
        for (Long orgId : billOrgIds) {
            QFilter orgFilter = new QFilter("orgentry.org", "=", (Object)orgId).or("orgscope", "=", (Object)"GLOBAL");
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            QFilter statusFilter = new QFilter("status", "=", (Object)"C");
            QFilter[] filter = new QFilter[]{enableFilter, orgFilter, statusFilter};
            Map schemeMap = BusinessDataServiceHelper.loadFromCache((String)"ccm_scheme", (QFilter[])filter);
            schemeMap.values().forEach(row -> usefulSchemeList.add(this.createCreditScheme((DynamicObject)row)));
        }
        Iterator creditSchemeIterator = usefulSchemeList.iterator();
        while (creditSchemeIterator.hasNext()) {
            CreditScheme scheme = (CreditScheme)creditSchemeIterator.next();
            if (this.isSchemeMatch(scheme)) continue;
            creditSchemeIterator.remove();
            logger.info("\u4fe1\u63a7\u65b9\u6848\u7f16\u7801:{} \u540d\u79f0:{} \u4e0a\u7684\u5355\u636e\u7b56\u7565\u672a\u5339\u914d\u5f53\u524d\u64cd\u4f5c\uff0c\u4e0d\u5bf9\u8be5\u4fe1\u63a7\u65b9\u6848\u8fdb\u884c\u68c0\u67e5.", (Object)scheme.getNumber(), (Object)scheme.getName());
        }
        logger.info("\u4fe1\u63a7\u65b9\u6848\u6821\u9a8c\u670d\u52a1\u5f00\u59cb\u2026\u2026");
        CreditSchemeValidatorHelper.validate(usefulSchemeList);
        logger.info("\u4fe1\u63a7\u65b9\u6848\u4e2a\u6570\u6709:{}\u4e2a", (Object)usefulSchemeList.size());
        this.writeCreateSchemeLog(usefulSchemeList);
        return usefulSchemeList;
    }

    private void writeCreateSchemeLog(List<CreditScheme> usefulSchemeList) {
        if (usefulSchemeList.size() > 0) {
            CreditLogCollectInfo.collectCreditLogInfo("creditscheme", usefulSchemeList);
        } else {
            CreditLogCollectInfo.collectCreditLogInfo(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u53ef\u7528\u4fe1\u63a7\u65b9\u6848\u3002", (String)"CreditSchemeServiceImpl_0", (String)"scmc-ccm", (Object[])new Object[0]));
        }
    }

    private boolean isSchemeMatch(CreditScheme scheme) {
        CreditContext txt = CreditContext.get();
        List<BillStrategy> billStrategies = scheme.getBillStrategies();
        boolean isMatch = false;
        Iterator<BillStrategy> iterator = billStrategies.iterator();
        while (iterator.hasNext()) {
            BillStrategy billStrategy = iterator.next();
            if (!Objects.equals(billStrategy.getEntityKey(), txt.getEntityKey())) continue;
            if (!this.isOpMatch(billStrategy, txt)) {
                iterator.remove();
                continue;
            }
            isMatch = true;
        }
        return isMatch;
    }

    private boolean isOpMatch(BillStrategy billStrategy, CreditContext context) {
        if ("CHECK".equals(context.getCreditAction())) {
            return billStrategy.getCheckOps().contains(context.getOperateKey());
        }
        if ("UPDATE".equals(context.getCreditAction())) {
            return Objects.equals(context.getOperateKey(), billStrategy.getUpdateOp()) || billStrategy.getReverseOps().contains(context.getOperateKey());
        }
        return "QUERYBALANCE".equals(context.getCreditAction());
    }

    private CreditScheme createCreditScheme(DynamicObject rawScheme) {
        CreditScheme scheme = new CreditScheme();
        scheme.setNumber(rawScheme.getString("number"));
        String name = rawScheme.getLocaleString("name").getLocaleValue();
        scheme.setName(name);
        scheme.setBizstate(rawScheme.getString("bizstate"));
        scheme.setChecktypenumber(rawScheme.getString("checktype.number"));
        scheme.setValidity(rawScheme.getString("validity"));
        scheme.setDefaultquota(rawScheme.getBigDecimal("defaultquota"));
        scheme.setDefaultdays(rawScheme.getBigDecimal("defaultdays"));
        scheme.setYearbegindate(rawScheme.getDate("yearbegindate"));
        scheme.setId(rawScheme.getLong("id"));
        scheme.setCurrency(rawScheme.getLong("currency.id"));
        scheme.setSingleCurrencyControl(rawScheme.getBoolean("singlecurcontrol"));
        scheme.setExchangeRateTable(rawScheme.getLong("exratetable.id"));
        Dimension dimension = new Dimension();
        DynamicObject dimensionObj = rawScheme.getDynamicObject("dimension");
        dimension.setId(dimensionObj.getLong("id"));
        boolean autoCreateArchive = rawScheme.getBoolean("autocreatearchive");
        scheme.setAutocreatearchive(autoCreateArchive);
        scheme.setDimension(dimension);
        DynamicObjectCollection rolesEntry = dimensionObj.getDynamicObjectCollection("entry");
        List roleIds = rolesEntry.stream().map(role -> role.getLong("role.id")).collect(Collectors.toList());
        Map roles = BusinessDataServiceHelper.loadFromCache((Object[])roleIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ccm_role"));
        for (DynamicObject roleObj : rolesEntry) {
            Role role2 = new Role(roleObj.getString("role.number"));
            role2.setRoleName(roleObj.getString("role.name"));
            DynamicObject tempRole = (DynamicObject)roles.get(roleObj.getLong("role.id"));
            role2.setBasedataEntityKey(tempRole.getString("basedata.id"));
            role2.setIsControled(tempRole.getBoolean("iscontroled"));
            dimension.getRoles().add(role2);
        }
        LinkedList<String> entityKeys = new LinkedList<String>();
        QuotaType quotaType = new QuotaType(this.getQuotaType(rawScheme.getString("checktype.number")));
        scheme.setQuotaType(quotaType);
        DynamicObjectCollection entry = rawScheme.getDynamicObjectCollection("entry");
        Set billStrategyIds = entry.stream().map(row -> row.getLong("billstrategy.id")).collect(Collectors.toSet());
        Map billSettings = BusinessDataServiceHelper.loadFromCache((Object[])billStrategyIds.toArray(), (String)"ccm_billstrategy");
        for (Object row2 : entry) {
            DynamicObject billSetting = (DynamicObject)billSettings.get(row2.getLong("billstrategy.id"));
            BillStrategy billStrategy = this.createBillStrategy(billSetting);
            billStrategy.setMode(row2.getString("controlmode"));
            boolean merge = false;
            for (BillStrategy strategy : scheme.getBillStrategies()) {
                if (!Objects.equals(strategy.getEntityKey(), billStrategy.getEntityKey()) || !Objects.equals(strategy.getUpdateOp(), billStrategy.getUpdateOp()) || !strategy.getReverseOps().containsAll(billStrategy.getReverseOps())) continue;
                merge = true;
                strategy.getExpressions().addAll(billStrategy.getExpressions());
            }
            if (!merge) {
                scheme.getBillStrategies().add(billStrategy);
            }
            entityKeys.add(billStrategy.getEntityKey());
        }
        List<EntityConfig> configs = this.iCreditEntityConService.readConfigList(entityKeys);
        for (BillStrategy billStrategy : scheme.getBillStrategies()) {
            for (EntityConfig config : configs) {
                if (!Objects.equals(billStrategy.getEntityKey(), config.getEntityKey())) continue;
                billStrategy.setConfig(config);
            }
        }
        String orgScope = rawScheme.getString("orgscope");
        scheme.setOrgscope(orgScope);
        scheme.setGlobalScheme("GLOBAL".equals(orgScope));
        if ("SINGLE".equals(orgScope)) {
            DynamicObjectCollection orgEntry = rawScheme.getDynamicObjectCollection("orgentry");
            ArrayList<Long> orgIds = new ArrayList<Long>(orgEntry.size());
            for (DynamicObject orgRow : orgEntry) {
                DynamicObject orgObj = orgRow.getDynamicObject("org");
                if (orgObj == null) continue;
                orgIds.add(orgObj.getLong("id"));
            }
            scheme.setOrgScopes(orgIds);
        }
        return scheme;
    }

    private BillStrategy createBillStrategy(DynamicObject billSetting) {
        Object expression;
        BillStrategy billStrategy = new BillStrategy();
        String entityKey = billSetting.getString("entity.id");
        billStrategy.setEntityKey(entityKey);
        List<String> reduceOps = this.getCreditOpList(billSetting, "reduceops");
        List<String> increaseOps = this.getCreditOpList(billSetting, "increaseops");
        List<String> checkOps = this.getCreditOpList(billSetting, "checkops");
        billStrategy.setReduceOps(reduceOps);
        billStrategy.setIncreaseOps(increaseOps);
        billStrategy.setCheckOps(checkOps);
        if (checkOps.isEmpty() && billSetting.getBoolean("ischeck")) {
            billStrategy.setCheckOps(reduceOps);
        }
        String forwardAction = billSetting.getString("forwardaction");
        billStrategy.setForwardAction(forwardAction.toUpperCase());
        Direction direction = Direction.REDUCE;
        if (StringUtils.isNotBlank((CharSequence)forwardAction)) {
            direction = Direction.valueOf(forwardAction.toUpperCase());
        }
        billStrategy.setDirection(direction);
        LinkedList<String> reverseOps = new LinkedList<String>();
        String updateOp = null;
        for (String op : reduceOps) {
            if (this.isReverseOp(op, direction, increaseOps, reduceOps)) {
                reverseOps.add(op);
                continue;
            }
            updateOp = op;
        }
        for (String op : increaseOps) {
            if (this.isReverseOp(op, direction, increaseOps, reduceOps)) {
                reverseOps.add(op);
                continue;
            }
            updateOp = op;
        }
        billStrategy.setUpdateOp(updateOp);
        billStrategy.setReverseOps(reverseOps);
        DynamicObjectCollection checkEntry = billSetting.getDynamicObjectCollection("checkentry");
        String checkTypeNumber = billSetting.getString("checktype.number");
        if (checkEntry.size() == 0 && ("KZFW002".equals(checkTypeNumber) || "KZFW006".equals(checkTypeNumber))) {
            expression = new Expression();
            ((Expression)expression).setDirection(direction);
            CreditCondition condition = new CreditCondition(entityKey, null);
            ((Expression)expression).setCondition(condition);
            ((Expression)expression).setFilter(new BillConditionFilter(null));
            billStrategy.getExpressions().add((Expression)expression);
        }
        for (DynamicObject row : checkEntry) {
            Expression expression2 = new Expression();
            expression2.setDirection(direction);
            this.setExpressionByFilterCondition(expression2, row, "newcheckfilter_tag", entityKey);
            this.setExpressionByValueFormual(expression2, row, "newcheckformula_tag", entityKey);
            billStrategy.getExpressions().add(expression2);
        }
        expression = new Expression();
        DynamicObject assingEntity = billSetting.getDynamicObject("assingentity");
        if (!ObjectUtils.isEmpty((Object)assingEntity)) {
            this.setExpressionByFilterCondition((Expression)expression, billSetting, "newdatafilter_tag", assingEntity.getString("id"));
        }
        billStrategy.setExpression((Expression)expression);
        String checkType = billSetting.getString("checktype.number");
        if ("KZFW002".equals(checkType)) {
            billStrategy.setCalculateDate(billSetting.getString("calculatedate"));
        } else if ("KZFW006".equals(checkType)) {
            billStrategy.setCalculateDate(billSetting.getString("calculatedate"));
            billStrategy.setCalculateAmt(billSetting.getString("calculateamt"));
        }
        if (!ObjectUtils.isEmpty((Object)assingEntity)) {
            billStrategy.setAssingEntityKey(assingEntity.getString("number"));
        }
        return billStrategy;
    }

    private void setExpressionByValueFormual(Expression expression, DynamicObject data, String valueFormualName, String entityKey) {
        String rawFormulaStr = data.getString(valueFormualName);
        if (StringUtils.isNotBlank((CharSequence)rawFormulaStr)) {
            CRFormula crFormula = (CRFormula)SerializationUtils.fromJsonString((String)rawFormulaStr, CRFormula.class);
            CreditFormula formula = new CreditFormula(entityKey, crFormula.getExpression());
            expression.setFormula(formula);
            expression.setValueGetter(new AmountFormulaValueGetter(formula));
        } else {
            CreditFormula formula = new CreditFormula(entityKey, null);
            expression.setFormula(formula);
            expression.setValueGetter(new ConstValueGettter(BigDecimal.ZERO));
        }
    }

    private void setExpressionByFilterCondition(Expression expression, DynamicObject data, String filterConditionName, String entityKey) {
        String filterCondition = data.getString(filterConditionName);
        if (StringUtils.isNotBlank((CharSequence)filterCondition)) {
            CRCondition crCondition = (CRCondition)SerializationUtils.fromJsonString((String)filterCondition, CRCondition.class);
            CreditCondition condition = new CreditCondition(entityKey, crCondition);
            expression.setCondition(condition);
            expression.setFilter(new BillConditionFilter(condition));
        } else {
            CreditCondition condition = new CreditCondition(entityKey, null);
            expression.setCondition(condition);
            expression.setFilter(new BillConditionFilter(null));
        }
    }

    private boolean isReverseOp(String op, Direction direction, List<String> increaseOps, List<String> reduceOps) {
        if ("unsubmit".equals(op) || "unaudit".equals(op) || "bizunclose".equals(op) || "bizuncancel".equals(op)) {
            return true;
        }
        if (direction == Direction.REDUCE) {
            return increaseOps.contains(op);
        }
        return reduceOps.contains(op);
    }

    private List<String> getCreditOpList(DynamicObject billSetting, String creditOpType) {
        String[] creditOps = billSetting.getString(creditOpType).split(",");
        LinkedList<String> creditOpList = new LinkedList<String>();
        for (String op : creditOps) {
            if (!StringUtils.isNotBlank((CharSequence)op)) continue;
            creditOpList.add(op);
        }
        return creditOpList;
    }

    private String getQuotaType(String checkType) {
        switch (checkType) {
            case "KZFW001": {
                return "amount";
            }
            case "KZFW002": {
                return "days";
            }
            case "KZFW003": {
                return "qty";
            }
            case "KZFW006": {
                return "overdueamt";
            }
            case "KZFW010": {
                return "privilegeamt";
            }
            case "KZFW011": {
                return "privilegeday";
            }
        }
        throw new IllegalArgumentException("Unknow checktype:" + checkType);
    }

    private Set<Long> getBillOrgIds() {
        try (Auditable audit = Audit.audit((String)"ccm.getconfig", (Object[])new Object[0]);){
            EntityConfig config = this.iCreditEntityConService.readConfig(CreditContext.get().getEntityKey());
            HashSet<Long> creditOrgSet = new HashSet<Long>();
            Field orgField = config.getOrgField();
            if (orgField.getEntryKey() != null) {
                for (DynamicObject bill : this.bills) {
                    DynamicObjectCollection entry = bill.getDynamicObjectCollection(orgField.getEntryKey());
                    for (DynamicObject row : entry) {
                        DynamicObject creditUnit = row.getDynamicObject(orgField.getKey());
                        if (creditUnit == null) continue;
                        creditOrgSet.add(creditUnit.getLong("id"));
                    }
                }
            } else {
                for (DynamicObject bill : this.bills) {
                    DynamicObject creditUnit = bill.getDynamicObject(orgField.getKey());
                    if (creditUnit == null) continue;
                    creditOrgSet.add(creditUnit.getLong("id"));
                }
            }
            logger.info("\u4fe1\u63a7\u68c0\u67e5\u670d\u52a1\uff0c\u83b7\u53d6\u4e1a\u52a1\u5355\u636e\u4e0a\u7ec4\u7ec7ID\u5982\u4e0b\uff1a{}", creditOrgSet);
            HashSet<Long> hashSet = creditOrgSet;
            return hashSet;
        }
    }

    public CreditSchemeServiceImpl(DynamicObject[] bills) {
        super(bills);
    }

    @Override
    public void close() throws Exception {
        if (this.iCreditEntityConService != null) {
            this.iCreditEntityConService = null;
        }
    }
}

