/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.service.snapshot;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.ccm.business.formulavalue.DimensionValueGetter;
import kd.scmc.ccm.business.formulavalue.ValueGetter;
import kd.scmc.ccm.business.helper.DimensionEntryFieldMapper;
import kd.scmc.ccm.business.pojo.CompositeKey;
import kd.scmc.ccm.business.pojo.CreditElement;
import kd.scmc.ccm.business.pojo.CreditScheme;
import kd.scmc.ccm.business.pojo.Dimension;
import kd.scmc.ccm.business.pojo.DimensionValue;
import kd.scmc.ccm.business.pojo.EntityConfig;
import kd.scmc.ccm.business.pojo.Field;
import kd.scmc.ccm.business.pojo.QuotaType;
import kd.scmc.ccm.business.pojo.Role;
import kd.scmc.ccm.business.pojo.exprfilter.CreditFormula;
import kd.scmc.ccm.business.pojo.exprfilter.Expression;
import kd.scmc.ccm.business.pojo.snapshot.CreditSnapshotsGroupInfo;
import kd.scmc.ccm.business.pojo.snapshot.CreditSnapshotsInfo;
import kd.scmc.ccm.business.service.journal.builder.CacheableExchangeRateLoader;
import kd.scmc.ccm.business.service.snapshot.ICreditSnapshotCreateService;
import kd.scmc.ccm.common.enums.Direction;
import kd.scmc.ccm.common.util.CreditContext;

public class CreditSnapshotCreateServiceImpl
implements ICreditSnapshotCreateService {
    private static final Log logger = LogFactory.getLog(CreditSnapshotCreateServiceImpl.class);
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern(TimeServiceHelper.getDateTimeFormatString());
    private CreditScheme scheme;
    private DimensionValueGetter dimensionValueGetter;
    private CreditContext txt;
    private boolean isReverse;

    public CreditSnapshotCreateServiceImpl(CreditScheme scheme, boolean isReverse) {
        this.scheme = scheme;
        this.txt = CreditContext.get();
        this.dimensionValueGetter = new DimensionValueGetter(scheme, this.txt);
        this.isReverse = isReverse;
    }

    @Override
    public List<CreditSnapshotsGroupInfo> createSnapshotGroupInfoList(List<DynamicObject> billList) {
        logger.info("\u4fe1\u63a7\u5373\u65f6\u5feb\u7167\u8ba1\u7b97\u5f00\u59cb\u65f6\u95f4\uff1a{}", (Object)formatter.format(LocalDateTime.now()));
        try (TraceSpan traceSpan = Tracer.create((String)"CreditSnapshotCreateServiceImpl", (String)"createSnapshotGroupInfoList");){
            ArrayList<CreditSnapshotsGroupInfo> creditSnapshotsGroupInfoList = new ArrayList<CreditSnapshotsGroupInfo>(16);
            for (DynamicObject bill : billList) {
                CreditSnapshotsGroupInfo creditSnapshotsGroup = this.createCreditSnapshotsGroupInfo(bill);
                this.groupBy(creditSnapshotsGroup);
                creditSnapshotsGroupInfoList.add(creditSnapshotsGroup);
            }
            logger.info("\u4fe1\u63a7\u5373\u65f6\u5feb\u7167\u8ba1\u7b97\u7ed3\u675f\u65f6\u95f4\uff1a{}", (Object)formatter.format(LocalDateTime.now()));
            ArrayList<CreditSnapshotsGroupInfo> arrayList = creditSnapshotsGroupInfoList;
            return arrayList;
        }
    }

    @Override
    public void saveSnapshotInfoList(List<CreditSnapshotsGroupInfo> creditSnapshotsGroupInfoList) {
        logger.info("\u4fe1\u63a7\u5373\u65f6\u5feb\u7167\u843d\u5e93\u5f00\u59cb\u65f6\u95f4\uff1a{}", (Object)formatter.format(LocalDateTime.now()));
        try (TraceSpan traceSpan = Tracer.create((String)"CreditSnapshotCreateServiceImpl", (String)"saveSnapshotInfoList");){
            ArrayList<DynamicObject> snapshotsObjList = new ArrayList<DynamicObject>(creditSnapshotsGroupInfoList.size());
            for (CreditSnapshotsGroupInfo snapshotsGroupInfo : creditSnapshotsGroupInfoList) {
                List<CreditSnapshotsInfo> creditSnapshotsInfoList = snapshotsGroupInfo.getCreditSnapshotsInfoList();
                for (CreditSnapshotsInfo snapshotsInfo : creditSnapshotsInfoList) {
                    Long archiveid = snapshotsInfo.getArchiveid();
                    if (archiveid == null || archiveid == 0L) continue;
                    DynamicObject dynObj = snapshotsInfo.convertInfoToDynObj();
                    snapshotsObjList.add(dynObj);
                }
            }
            if (snapshotsObjList.size() <= 0) {
                return;
            }
            SaveServiceHelper.save((DynamicObject[])snapshotsObjList.toArray(new DynamicObject[0]));
        }
        logger.info("\u4fe1\u63a7\u5373\u65f6\u5feb\u7167\u843d\u5e93\u7ed3\u675f\u65f6\u95f4\uff1a{}", (Object)formatter.format(LocalDateTime.now()));
    }

    public CreditSnapshotsGroupInfo createCreditSnapshotsGroupInfo(DynamicObject bill) {
        CreditSnapshotsGroupInfo snapshotsGroupInfo = CreditSnapshotsGroupInfo.doCreate(bill.getString("billno"), bill.getLong("id"), this.txt.getEntityKey());
        snapshotsGroupInfo.setScheme(this.scheme);
        ArrayList<CreditSnapshotsInfo> snapshotsInfoList = new ArrayList<CreditSnapshotsInfo>(16);
        EntityConfig config = this.scheme.getEntityConfig(this.txt);
        String entryKey = this.getEntryKey(config);
        if (entryKey == null) {
            CreditSnapshotsInfo snapshotsInfo;
            Expression expression = this.matchExpressionByBill(bill);
            if (expression != null && (snapshotsInfo = this.createSnapshotsInfo(bill, null, 0, expression)) != null) {
                snapshotsInfoList.add(snapshotsInfo);
            }
        } else {
            DynamicObjectCollection entryList = bill.getDynamicObjectCollection(entryKey);
            int rowIndex = 1;
            for (DynamicObject row : entryList) {
                CreditSnapshotsInfo snapshotsInfo;
                Expression expression = this.matchExpressionByRow(row);
                if (expression != null && (snapshotsInfo = this.createSnapshotsInfo(bill, row, rowIndex, expression)) != null) {
                    snapshotsInfoList.add(snapshotsInfo);
                }
                ++rowIndex;
            }
        }
        snapshotsGroupInfo.setCreditSnapshotsInfoList(snapshotsInfoList);
        return snapshotsGroupInfo;
    }

    private CreditSnapshotsInfo createSnapshotsInfo(DynamicObject bill, DynamicObject row, int rowSeq, Expression expression) {
        EntityConfig entityConfig;
        Field orgField;
        Object orgObj;
        CreditSnapshotsInfo info = CreditSnapshotsInfo.doCreate(bill.getLong("id"), this.txt.getEntityKey(), bill.getString("billno"), bill.getLong("id"), this.txt.getCreditAction(), expression.getDirection().name(), this.txt.getOperateKey(), bill.getDataEntityType().getName());
        if (this.isReverse) {
            info.setDirection(Direction.INCREASE.name());
        }
        info.setScheme(this.scheme.getId());
        info.setUpdatetime(TimeServiceHelper.getTimeStamp());
        if (row != null) {
            info.setEntrykey(row.getDataEntityType().getName());
            info.setEntryid(row.getLong("id"));
            info.setEntryseq(Long.valueOf(rowSeq));
        }
        if ((orgObj = this.getValue(bill, row, orgField = (entityConfig = this.scheme.getEntityConfig(this.txt)).getOrgField(), this.getValueGetter(this.scheme, CreditElement.ELEMENT_ORG))) instanceof DynamicObject) {
            info.setOrg(((DynamicObject)orgObj).getLong("id"));
        } else if (orgObj != null) {
            info.setOrg((Long)orgObj);
        }
        QuotaType quotaType = this.scheme.getQuotaType();
        String quotaTypeStr = quotaType.getQuotaType();
        info.setQuotatype(quotaTypeStr);
        ValueGetter quotaValueGetter = expression.getValueGetter();
        BigDecimal originalQuota = BigDecimal.ZERO;
        originalQuota = row != null ? (BigDecimal)quotaValueGetter.get(row) : (BigDecimal)quotaValueGetter.get(bill);
        info.setOriginalamount(originalQuota);
        DimensionValue dimensionValue = null;
        dimensionValue = row != null ? (DimensionValue)this.dimensionValueGetter.get(row) : (DimensionValue)this.dimensionValueGetter.get(bill);
        info.setDimensionvalue(dimensionValue);
        if ("amount".equals(quotaTypeStr) || "privilegeamt".equals(quotaTypeStr)) {
            if (originalQuota.compareTo(BigDecimal.ZERO) == 0) {
                return null;
            }
            Field currencyField = entityConfig.getCurrencyField();
            ValueGetter currencyValueGetter = this.getValueGetter(this.scheme, CreditElement.ELEMENT_CURRENCY);
            Object currencyObj = this.getValue(bill, row, currencyField, currencyValueGetter);
            long currency = 0L;
            currency = currencyObj instanceof DynamicObject ? ((DynamicObject)currencyObj).getLong("id") : ((Long)currencyObj).longValue();
            info.setOriginalunit(currency);
            long exchangeCurrency = this.scheme.getCurrency();
            info.setUnit(exchangeCurrency);
            BigDecimal exchangeRate = this.getRate(currency, exchangeCurrency, this.scheme.getExchangeRateTable(), TimeServiceHelper.now());
            info.setConversionrate(exchangeRate);
            BigDecimal quota = originalQuota.multiply(exchangeRate);
            info.setAmount(quota);
        } else if ("qty".equals(quotaTypeStr)) {
            Dimension dimension = this.scheme.getDimension();
            List<Role> roles = dimension.getRoles();
            Map<Role, Object> valueMap = dimensionValue.getValueMap();
            DimensionEntryFieldMapper mapper = new DimensionEntryFieldMapper(dimension.getId());
            List<String> fieldTypeKeys = mapper.getFieldTypeKeys();
            for (int i = 0; i < roles.size(); ++i) {
                if (!"bd_material".equals(mapper.getBaseDataKey(fieldTypeKeys.get(i)))) continue;
                Object materialId = valueMap.get(roles.get(i));
                DynamicObject material = QueryServiceHelper.queryOne((String)"bd_material", (String)"baseunit", (QFilter[])new QFilter[]{new QFilter("id", "=", materialId)});
                info.setUnit(material.getLong("baseunit"));
                break;
            }
            info.setAmount(originalQuota);
        } else {
            info.setAmount(originalQuota);
        }
        return info;
    }

    private void groupBy(CreditSnapshotsGroupInfo snapshotsGroupInfo) {
        List<CreditSnapshotsInfo> snapshotsInfoList = snapshotsGroupInfo.getCreditSnapshotsInfoList();
        HashMap<CompositeKey, CreditSnapshotsInfo> snapshotsMap = new HashMap<CompositeKey, CreditSnapshotsInfo>();
        for (CreditSnapshotsInfo info : snapshotsInfoList) {
            CompositeKey compositeKey = new CompositeKey(new Object[0]);
            compositeKey.addKey(info.getOrg());
            compositeKey.addKey(info.getDimensionvalue());
            compositeKey.addKey(info.getOriginalunit());
            compositeKey.addKey(info.getQuotatype());
            compositeKey.addKey(info.getConversionrate());
            CreditSnapshotsInfo tempInfo = (CreditSnapshotsInfo)snapshotsMap.get(compositeKey);
            if (tempInfo != null) {
                tempInfo.setOriginalamount(tempInfo.getOriginalamount().add(info.getOriginalamount()));
                tempInfo.setAmount(tempInfo.getAmount().add(info.getAmount()));
                continue;
            }
            snapshotsMap.put(compositeKey, info);
        }
        snapshotsGroupInfo.setCreditSnapshotsInfoList(snapshotsMap.values().stream().collect(Collectors.toList()));
    }

    private String getEntryKey(EntityConfig entityConfig) {
        Field orgField = entityConfig.getOrgField();
        if (orgField.getEntryKey() != null) {
            return orgField.getEntryKey();
        }
        Field currencyField = entityConfig.getCurrencyField();
        if (currencyField.getEntryKey() != null) {
            return currencyField.getEntryKey();
        }
        Map<String, Field> creditRolesKeyMap = entityConfig.getCreditRolesKeyMap();
        for (Role role : this.scheme.getDimension().getRoles()) {
            Field field = creditRolesKeyMap.get(role.getRoleType());
            if (field.getEntryKey() == null) continue;
            return field.getEntryKey();
        }
        List<Expression> expressions = this.scheme.getExpressions(this.txt);
        for (Expression exp : expressions) {
            List<Field> refFields = exp.getCondition().getFields();
            for (Field field : refFields) {
                if (field.getEntryKey() == null) continue;
                return field.getEntryKey();
            }
            CreditFormula formula = exp.getFormula();
            if (formula == null) continue;
            refFields = formula.getFields();
            for (Field field : refFields) {
                if (field.getEntryKey() == null) continue;
                return field.getEntryKey();
            }
        }
        return null;
    }

    private Object getValue(DynamicObject bill, DynamicObject row, Field field, ValueGetter fieldValueGetter) {
        if (field.getEntryKey() != null) {
            return fieldValueGetter.get(row);
        }
        return fieldValueGetter.get(bill);
    }

    private ValueGetter getValueGetter(CreditScheme scheme2, CreditElement element) {
        return scheme2.getValueGetter(this.txt, element);
    }

    private Expression matchExpressionByBill(DynamicObject bill) {
        List<Expression> expressions = this.scheme.getExpressions(this.txt);
        for (Expression exp : expressions) {
            if (!exp.getFilter().isBillMatch(bill)) continue;
            return exp;
        }
        return null;
    }

    private Expression matchExpressionByRow(DynamicObject row) {
        List<Expression> expressions = this.scheme.getExpressions(this.txt);
        for (Expression exp : expressions) {
            if (!exp.getFilter().isRowMatch(row)) continue;
            return exp;
        }
        return null;
    }

    private BigDecimal getRate(long srcCurrencyId, long targetCurrencyId, long exchangeRateTableId, Date rateDate) {
        BigDecimal rate = new CacheableExchangeRateLoader().getRate(srcCurrencyId, targetCurrencyId, exchangeRateTableId, rateDate);
        if (rate != null) {
            return rate;
        }
        DynamicObject srcCurrency = BusinessDataServiceHelper.loadSingleFromCache((Object)srcCurrencyId, (String)"bd_currency");
        DynamicObject targetCurrency = BusinessDataServiceHelper.loadSingleFromCache((Object)targetCurrencyId, (String)"bd_currency");
        DynamicObject exchangeRateTable = BusinessDataServiceHelper.loadSingleFromCache((Object)exchangeRateTableId, (String)"bd_exratetable");
        String srcCurrencyName = srcCurrency == null ? "" : srcCurrency.getString("name");
        String targetCurrencyName = targetCurrency == null ? "" : targetCurrency.getString("name");
        String rateTableName = exchangeRateTable == null ? "" : exchangeRateTable.getString("name");
        String message = String.format(ResManager.loadKDString((String)"\u4fe1\u7528\u989d\u5ea6\u6298\u7b97\u5931\u8d25\uff0c\u6c47\u7387\u8868\u6ca1\u6709\u7ef4\u62a4\u5bf9\u5e94\u7684\u6c47\u7387\uff0c\u539f\u5e01\u4e3a%1$s\uff0c\u76ee\u6807\u5e01\u4e3a%2$s\uff0c\u6c47\u7387\u8868\u4e3a%3$s\u3002", (String)"CreditSnapshotCreateServiceImpl_0", (String)"scmc-ccm", (Object[])new Object[0]), srcCurrencyName, targetCurrencyName, rateTableName);
        throw new KDBizException(message);
    }

    @Override
    public void close() throws Exception {
    }
}

