/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.common.util;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import kd.bos.dataentity.utils.ObjectUtils;

public class DateUtil {
    private static final LocalTime ENDOFDAY = LocalTime.of(23, 59, 59);

    public static Date getEndOfDay(Date date) {
        if (!ObjectUtils.isEmpty((Object)date)) {
            LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault());
            LocalDateTime endOfDay = localDateTime.with(ENDOFDAY);
            return Date.from(endOfDay.atZone(ZoneId.systemDefault()).toInstant());
        }
        return null;
    }

    public static Date getStartOfDay(Date date) {
        if (!ObjectUtils.isEmpty((Object)date)) {
            LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault());
            LocalDateTime startOfDay = localDateTime.with(LocalTime.MIN);
            return Date.from(startOfDay.atZone(ZoneId.systemDefault()).toInstant());
        }
        return null;
    }

    public static int getDateYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        return year;
    }

    public static int getDateMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int month = calendar.get(2);
        return month;
    }

    public static int getDateDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int day = calendar.get(5);
        return day;
    }

    public static Date getYearsLaterDate(Date date, int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(1, calendar.get(1) + year);
        calendar.set(5, calendar.get(5) - 1);
        return calendar.getTime();
    }

    public static Date getSpecialDate(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        return calendar.getTime();
    }

    public static int getDiffDays(Date beginDate, Date endDate) {
        return (int)((endDate.getTime() - beginDate.getTime()) / 86400000L);
    }
}

