/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.common.apm;

import com.alibaba.fastjson.annotation.JSONField;
import java.util.LinkedList;
import java.util.List;
import kd.bos.audit.Auditable;
import kd.scmc.ccm.common.apm.Audit;
import kd.scmc.ccm.common.apm.AuditDataConsumer;

public class CostItem
implements Auditable,
Comparable<CostItem> {
    @JSONField
    private String name;
    @JSONField
    private long beginTime;
    @JSONField
    private long endTime;
    @JSONField
    private long costTime;
    @JSONField
    private CostItem parent;
    @JSONField
    private List<CostItem> subItems = new LinkedList<CostItem>();
    private Auditable bosAudit;
    private boolean closed = false;

    public CostItem() {
    }

    public CostItem(String name) {
        this.name = name;
        this.bosAudit = kd.bos.audit.Audit.audit((String)name, (Object[])new Object[0]);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(long beginTime) {
        this.beginTime = beginTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getCostTime() {
        return this.costTime;
    }

    public void setCostTime(long costTime) {
        this.costTime = costTime;
    }

    public List<CostItem> getSubItems() {
        return this.subItems;
    }

    public void setSubItems(List<CostItem> subItems) {
        this.subItems = subItems;
    }

    public void addSubItem(CostItem subItem) {
        this.subItems.add(subItem);
    }

    public CostItem getParent() {
        return this.parent;
    }

    public void setParent(CostItem parent) {
        this.parent = parent;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.endTime = System.currentTimeMillis();
        this.costTime = this.endTime - this.beginTime;
        if (this.parent == null) {
            AuditDataConsumer.add(this);
        } else {
            Audit.CURRENT_AUIDTABLE.set(this.parent);
        }
        if (this.bosAudit != null) {
            this.bosAudit.close();
        }
    }

    @Override
    public int compareTo(CostItem o) {
        return this.costTime > o.costTime ? 1 : 0;
    }
}

