/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.common.apm;

import com.alibaba.fastjson.annotation.JSONField;
import java.util.LinkedList;
import java.util.TreeSet;
import kd.scmc.ccm.common.apm.CostItem;

public class SummaryCostItem {
    private static final int TOPCOSTSIZE = 10;
    @JSONField
    private String name;
    @JSONField
    private long totalTime;
    @JSONField
    private int times;
    @JSONField
    private LinkedList<CostItem> details = new LinkedList();
    @JSONField
    private TreeSet<CostItem> topCostDetails = new TreeSet();

    public SummaryCostItem() {
    }

    public SummaryCostItem(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public int getTimes() {
        return this.times;
    }

    public LinkedList<CostItem> getDetails() {
        return this.details;
    }

    public TreeSet<CostItem> getTopCostDetails() {
        return this.topCostDetails;
    }

    public synchronized void addCostItem(CostItem costItem) {
        this.details.add(costItem);
        if (this.details.size() > 10) {
            this.details.poll();
        }
        ++this.times;
        this.totalTime += costItem.getCostTime();
        if (this.topCostDetails.size() >= 10) {
            CostItem last = this.topCostDetails.first();
            if (last.getCostTime() <= costItem.getCostTime()) {
                this.topCostDetails.pollFirst();
                this.topCostDetails.add(costItem);
            }
        } else {
            this.topCostDetails.add(costItem);
        }
    }
}

