/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.common.helper;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.ccm.common.util.CompositeKey;

public class CacheableExchangeRateLoader {
    private Map<CompositeKey, BigDecimal> rateCache = new HashMap<CompositeKey, BigDecimal>();

    public BigDecimal getRate(long srcCurrency, long targetCurrency, long rateTable, Date date) {
        if (srcCurrency == targetCurrency || srcCurrency == 0L || targetCurrency == 0L || rateTable == 0L || date == null) {
            return BigDecimal.ONE;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        Date time = calendar.getTime();
        CompositeKey compositeKey = new CompositeKey(srcCurrency, targetCurrency, rateTable, time);
        BigDecimal rate = this.rateCache.get(compositeKey);
        if (rate == null) {
            rate = this.loadRate(srcCurrency, targetCurrency, rateTable, date);
            this.rateCache.put(compositeKey, rate);
        }
        return rate;
    }

    private BigDecimal loadRate(long srcCurrency, long targetCurrency, long rateTable, Date date) {
        return BaseDataServiceHelper.getExchangeRate((Long)rateTable, (Long)srcCurrency, (Long)targetCurrency, (Date)date);
    }
}

