/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.ccm.common.enums.ExchangeTypeEnum;
import kd.scmc.ccm.common.util.BigDecimalUtil;

public class CurrencyHelper {
    public static BigDecimal getExChangeRate(Long srcCurId, Long tarCurId, Long exRateTableId, Date date) {
        BigDecimal exchangeRate = BigDecimal.ZERO;
        if (srcCurId == null || tarCurId == null || exRateTableId == null || date == null) {
            return exchangeRate;
        }
        exchangeRate = srcCurId.equals(tarCurId) ? BigDecimal.ONE : BaseDataServiceHelper.getExchangeRate((Long)exRateTableId, (Long)srcCurId, (Long)tarCurId, (Date)date);
        return exchangeRate;
    }

    public static Map<String, Object> getExChangeRateMap(Long srcCurId, Long tarCurId, Long exRateTableId, Date date) {
        BigDecimal exRate;
        BigDecimal exchangeRate = BigDecimal.ZERO;
        String exchangeType = ExchangeTypeEnum.DIRECT.getValue();
        HashMap<String, Object> exRateMap = new HashMap<String, Object>(4);
        if (srcCurId == null || tarCurId == null || exRateTableId == null || date == null) {
            exRateMap.put("exchangerate", exchangeRate);
            exRateMap.put("exchangetype", exchangeType);
            return exRateMap;
        }
        Map exchangeRateMap = BaseDataServiceHelper.getExchangeRateMap((Long)srcCurId, (Long)tarCurId, (Long)exRateTableId, (Date)date);
        Boolean isIndirectRate = (Boolean)exchangeRateMap.get("quoteType");
        if (isIndirectRate != null && isIndirectRate.booleanValue()) {
            exchangeType = ExchangeTypeEnum.INDIRECT.getValue();
        }
        if ((exRate = (BigDecimal)exchangeRateMap.get("exchangeRate")) != null) {
            exchangeRate = exRate;
        }
        exRateMap.put("exchangerate", exchangeRate);
        exRateMap.put("exchangetype", exchangeType);
        return exRateMap;
    }

    public static BigDecimal convert(BigDecimal money, BigDecimal exRate, boolean isIndirectRate, int amtPrecision, RoundingMode roundingMode) {
        if (roundingMode == null) {
            roundingMode = RoundingMode.HALF_UP;
        }
        if (BigDecimalUtil.isZero(exRate)) {
            return BigDecimalUtil.ZERO;
        }
        if (isIndirectRate) {
            return money.divide(exRate, amtPrecision, roundingMode);
        }
        return money.multiply(exRate).setScale(amtPrecision, roundingMode);
    }
}

