/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.common.helper;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class SettingMapperHelper {
    private static final String SETTINGMAPPER = "ap_settingmapper";

    private SettingMapperHelper() {
    }

    public static String getOrCreateValueFromCache(String type, String key, String defaultValue) {
        QFilter[] filters = new QFilter[]{new QFilter("type", "=", (Object)type), new QFilter("key", "=", (Object)key)};
        DynamicObject cachedSetting = BusinessDataServiceHelper.loadSingleFromCache((String)SETTINGMAPPER, (QFilter[])filters);
        if (cachedSetting == null) {
            SettingMapperHelper.saveOrUpdate(type, key, defaultValue);
            return defaultValue;
        }
        return cachedSetting.getString("value");
    }

    public static String getValueFromCache(String type, String key) {
        QFilter[] filters = new QFilter[]{new QFilter("type", "=", (Object)type), new QFilter("key", "=", (Object)key)};
        DynamicObject cachedSetting = BusinessDataServiceHelper.loadSingleFromCache((String)SETTINGMAPPER, (QFilter[])filters);
        return cachedSetting == null ? null : cachedSetting.getString("value");
    }

    public static DynamicObject[] queryAllFromCache(String type) {
        QFilter[] filters = new QFilter[]{new QFilter("type", "=", (Object)type)};
        Map cachedValues = BusinessDataServiceHelper.loadFromCache((String)SETTINGMAPPER, (String)"type,key,value", (QFilter[])filters);
        return cachedValues.values().toArray(new DynamicObject[0]);
    }

    public static String getValue(String type, String key) {
        QFilter[] filters = new QFilter[]{new QFilter("type", "=", (Object)type), new QFilter("key", "=", (Object)key)};
        DynamicObject[] settings = BusinessDataServiceHelper.load((String)SETTINGMAPPER, (String)"value", (QFilter[])filters);
        return settings.length > 0 ? settings[0].getString("value") : null;
    }

    public static DynamicObject saveOrUpdate(String type, String key, String value) {
        QFilter[] filters = new QFilter[]{new QFilter("type", "=", (Object)type), new QFilter("key", "=", (Object)key)};
        DynamicObject[] settings = BusinessDataServiceHelper.load((String)SETTINGMAPPER, (String)"value", (QFilter[])filters);
        if (settings.length > 0) {
            settings[0].set("value", (Object)value);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{settings[0]});
            return settings[0];
        }
        DynamicObject setting = BusinessDataServiceHelper.newDynamicObject((String)SETTINGMAPPER);
        setting.set("type", (Object)type);
        setting.set("key", (Object)key);
        setting.set("value", (Object)value);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{setting});
        return setting;
    }

    public static void delete(String type, String key) {
        QFilter[] filters = new QFilter[]{new QFilter("type", "=", (Object)type), new QFilter("key", "=", (Object)key)};
        DeleteServiceHelper.delete((String)SETTINGMAPPER, (QFilter[])filters);
    }

    public static void delete(String type) {
        QFilter[] filters = new QFilter[]{new QFilter("type", "=", (Object)type)};
        DeleteServiceHelper.delete((String)SETTINGMAPPER, (QFilter[])filters);
    }

    public static DynamicObject[] queryAll(String type) {
        QFilter[] filters = new QFilter[]{new QFilter("type", "=", (Object)type)};
        return BusinessDataServiceHelper.load((String)SETTINGMAPPER, (String)"type,key,value", (QFilter[])filters);
    }
}

