/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.common.util;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class BigDecimalUtil {
    public static final BigDecimal ZERO = BigDecimal.ZERO;
    public static final BigDecimal ONE = BigDecimal.ONE;
    public static final BigDecimal HUNDRED = new BigDecimal("100");
    public static final int DEFAULT_SCALE = 10;
    public static final RoundingMode DEFAULT_ROUNDING = RoundingMode.HALF_UP;
    private static final int POINT_MOVE = 2;

    public static BigDecimal getNotNull(Object object) {
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        return ZERO;
    }

    public static BigDecimal x100(BigDecimal num) {
        return num.movePointRight(2);
    }

    public static BigDecimal div100(BigDecimal num) {
        return num.movePointLeft(2);
    }

    public static BigDecimal div100(BigDecimal num, int scale, RoundingMode roundingMode) {
        return num.movePointLeft(2).setScale(scale, roundingMode);
    }

    public static BigDecimal div100(BigDecimal num, int scale) {
        return BigDecimalUtil.div100(num, scale, DEFAULT_ROUNDING);
    }

    public static BigDecimal divide(BigDecimal num1, BigDecimal num2) {
        return num1.divide(num2, 10, DEFAULT_ROUNDING);
    }

    public static boolean equals(BigDecimal num1, BigDecimal num2) {
        if (num1 == null && num2 == null) {
            return true;
        }
        if (num1 != null && num2 != null) {
            return num1.compareTo(num2) == 0;
        }
        return false;
    }

    public static boolean isZero(BigDecimal num) {
        return BigDecimalUtil.equals(num, ZERO);
    }

    public static boolean isBlank(BigDecimal num) {
        if (num == null) {
            return true;
        }
        return BigDecimalUtil.isZero(num);
    }

    public static boolean notEquals(BigDecimal num1, BigDecimal num2) {
        if (num1 == null && num2 == null) {
            return false;
        }
        if (num1 != null && num2 != null) {
            return num1.compareTo(num2) != 0;
        }
        return true;
    }

    public static boolean isNotBlank(BigDecimal num) {
        return !BigDecimalUtil.isBlank(num);
    }

    public static boolean isNotZero(BigDecimal num) {
        return BigDecimalUtil.notEquals(num, ZERO);
    }

    public static boolean largeThan(BigDecimal num1, BigDecimal num2) {
        if (num1 == null) {
            num1 = ZERO;
        }
        if (num2 == null) {
            num2 = ZERO;
        }
        return num1.compareTo(num2) > 0;
    }

    public static boolean lessThan(BigDecimal num1, BigDecimal num2) {
        return BigDecimalUtil.largeThan(num2, num1);
    }

    public static boolean largeZero(BigDecimal num) {
        return BigDecimalUtil.largeThan(num, ZERO);
    }

    public static boolean large100(BigDecimal num) {
        return BigDecimalUtil.largeThan(num, HUNDRED);
    }

    public static BigDecimal getByGrowRate(BigDecimal num, BigDecimal growRate) {
        return num.add(num.multiply(growRate));
    }

    public static BigDecimal getByReduceRate(BigDecimal num, BigDecimal reduceRate) {
        return num.subtract(num.multiply(reduceRate));
    }
}

