/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.common.util;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dlock.DLock;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.scmc.ccm.common.util.CommonUtils;

public class Lock
implements AutoCloseable {
    private static final Log logger = LogFactory.getLog(Lock.class);
    private static final String LOCKTIMEPARAMKEY = "locktime";
    private static final String CCM_APPID = "0N6JIY2ETSPF";
    private List<DLock> successfulDLocks = new LinkedList<DLock>();

    public void lock(String lockKey) {
        DLock reentrantLock = DLock.createReentrant((String)lockKey);
        reentrantLock.fastMode();
        reentrantLock.lock();
        this.successfulDLocks.add(reentrantLock);
    }

    public boolean tryLock(String lockKey) {
        long creatReeLockStartTime = System.currentTimeMillis();
        logger.info("\u4fe1\u7528\u5206\u5e03\u5f0f\u9501DLock.createReentrant Start\uff1a" + creatReeLockStartTime + "({})", (Object)new Date(creatReeLockStartTime));
        DLock reentrantLock = DLock.createReentrant((String)lockKey);
        reentrantLock.fastMode();
        logger.info("\u4fe1\u7528\u5206\u5e03\u5f0f\u9501DLock.createReentrant(lockKey)\uff1a{ } ", (Object)lockKey);
        long creatReeLockEndTime = System.currentTimeMillis();
        logger.info("\u4fe1\u7528\u5206\u5e03\u5f0f\u9501DLock.createReentrant End\uff1a" + creatReeLockEndTime + "({})", (Object)new Date(creatReeLockEndTime));
        logger.info("\u4fe1\u7528\u5206\u5e03\u5f0f\u9501DLock.createReentrant \u8017\u65f6\uff1a {}  ms", (Object)(creatReeLockEndTime - creatReeLockStartTime));
        logger.info("\u4fe1\u7528\u5206\u5e03\u5f0f\u9501\uff08\u5c1d\u8bd5\u83b7\u53d6\u9501\uff09reentrantLock.tryLock Start!");
        boolean getLockSuccess = false;
        int Lock_Time = this.getLockTimeAPPParam();
        getLockSuccess = reentrantLock.tryLock((long)Lock_Time);
        if (getLockSuccess) {
            this.successfulDLocks.add(reentrantLock);
            logger.info("\u4fe1\u7528\u5206\u5e03\u5f0f\u9501\uff08\u5c1d\u8bd5\u83b7\u53d6\u9501\uff09 reentrantLock.tryLock \u6210\u529f\uff0c\u9501\u7b49\u5f85\u65f6\u95f4\u53c2\u6570\uff1a" + Lock_Time + " ms");
            logger.info("\u4fe1\u7528\u5206\u5e03\u5f0f\u9501\uff08\u5c1d\u8bd5\u83b7\u53d6\u9501\uff09 reentrantLock.tryLock \u6210\u529f\uff0clockKey\uff1a{} ", (Object)lockKey);
        } else {
            logger.info("\u4fe1\u7528\u5206\u5e03\u5f0f\u9501\uff08\u5c1d\u8bd5\u83b7\u53d6\u9501\uff09 reentrantLock.tryLock \u5931\u8d25\uff0c\u9501\u7b49\u5f85\u65f6\u95f4\u53c2\u6570\uff1a" + Lock_Time + " ms");
        }
        long tryLockEndTime = System.currentTimeMillis();
        logger.info("\u4fe1\u7528\u5206\u5e03\u5f0f\u9501reentrantLock.tryLock End\uff1a" + tryLockEndTime + "({})", (Object)new Date(tryLockEndTime));
        logger.info("\u4fe1\u7528\u5206\u5e03\u5f0f\u9501reentrantLock.tryLock \u6574\u4f53\u8017\u65f6\uff1a {}  ms", (Object)(tryLockEndTime - creatReeLockStartTime));
        return getLockSuccess;
    }

    public void unlockAll() {
        if (CommonUtils.isNull(this.successfulDLocks)) {
            return;
        }
        for (DLock dLock : this.successfulDLocks) {
            dLock.unlock();
        }
    }

    public void unLock(String key) {
        DLock reentrantLock = DLock.createReentrant((String)key);
        reentrantLock.unlock();
    }

    @Override
    public void close() {
        this.unlockAll();
        long closeTime = System.currentTimeMillis();
        logger.info("\u4fe1\u7528\u5206\u5e03\u5f0f\uff08\u9501\u91ca\u653e\uff09closeTime End\uff1a" + closeTime + "{}", (Object)new Date(closeTime));
    }

    private int getLockTimeAPPParam() {
        long getParamBeginTime = System.currentTimeMillis();
        StringBuilder lockGetParamLogStr = new StringBuilder();
        logger.info("\u4fe1\u7528\u5206\u5e03\u5f0f\uff08\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570\uff091 \u5f00\u59cb\uff1a" + new Date(getParamBeginTime));
        int Lock_Time = 600000;
        Long orgID = RequestContext.get().getOrgId();
        logger.info("\u4fe1\u7528\u5206\u5e03\u5f0f\uff08\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570\uff092 \u7ec4\u7ec7ID\uff1a" + orgID);
        if (orgID > 0L) {
            AppParam appParam = new AppParam(CCM_APPID, "15", orgID, Long.valueOf(0L));
            logger.info("\u4fe1\u7528\u5206\u5e03\u5f0f\uff08\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570\uff093 APPID\uff1a0N6JIY2ETSPF");
            logger.info("\u4fe1\u7528\u5206\u5e03\u5f0f\uff08\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570\uff094 LOCKTIMEPARAMKEY\uff1alocktime");
            Object lockTimeValue = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)LOCKTIMEPARAMKEY);
            if (lockTimeValue != null) {
                logger.info("\u4fe1\u7528\u5206\u5e03\u5f0f\uff08\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570\uff095 ParamValue\uff1a" + lockTimeValue + " ms");
                if ((Integer)lockTimeValue < 60000) {
                    Lock_Time = 180000;
                    logger.info("\u4fe1\u7528\u5206\u5e03\u5f0f\uff08\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570\uff095_1 ParamValueReset\uff1a" + Lock_Time + " ms");
                } else {
                    Lock_Time = (Integer)lockTimeValue;
                }
            }
        } else {
            logger.info("\u4fe1\u7528\u5206\u5e03\u5f0f\uff08\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570\uff093~5 \u7701\u7565\uff08\u56e0orgid = 0\uff09");
        }
        logger.info("\u4fe1\u7528\u5206\u5e03\u5f0f\uff08\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570\uff096 Lock_Time\uff1a" + Lock_Time + " ms");
        long getParamEndTime = System.currentTimeMillis();
        logger.info("\u4fe1\u7528\u5206\u5e03\u5f0f\uff08\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570\uff097 \u7ed3\u675f\uff1a " + new Date(getParamEndTime) + "\u8017\u65f6\uff1a" + (getParamEndTime - getParamBeginTime) + " ms");
        return Lock_Time;
    }
}

