/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LinkEntryProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.servicehelper.MetadataServiceHelper;

public class MetadataUtils {
    public static DynamicProperty getProperty(String entityKey, String key) {
        MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)entityKey);
        return MetadataUtils.getProperty(dt, key);
    }

    public static DynamicProperty getProperty(MainEntityType dt, String key) {
        DynamicProperty property = dt.getProperty(key);
        if (property == null) {
            List<EntryProp> entryProps = MetadataUtils.getEntryProps((IDataEntityType)dt);
            for (EntryProp entryProp : entryProps) {
                property = entryProp._collectionItemPropertyType.getProperty(key);
                if (property == null) continue;
                return property;
            }
        }
        return property;
    }

    public static boolean containsProperty(IDataEntityType dataEntityType, String fieldName) {
        return MetadataUtils.getProperty((MainEntityType)dataEntityType, fieldName) != null;
    }

    public static boolean containsEntryField(Collection<String> fields, MainEntityType dataEntityType) {
        for (String field : fields) {
            if (!MetadataUtils.isEntryField(dataEntityType, field)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEntryField(MainEntityType dt, String propName) {
        List<EntryProp> entryProps = MetadataUtils.getEntryProps((IDataEntityType)dt);
        String prefix = MetadataUtils.getPrefix(propName);
        for (EntryProp entryProp : entryProps) {
            if (!entryProp.getName().equalsIgnoreCase(prefix)) continue;
            return true;
        }
        DynamicProperty property = dt.getProperty(prefix);
        return property == null;
    }

    public static String getEntryKey(MainEntityType dt, String propName) {
        String prefix = MetadataUtils.getPrefix(propName);
        List<EntryProp> entryProps = MetadataUtils.getEntryProps((IDataEntityType)dt);
        for (EntryProp entryProp : entryProps) {
            if (entryProp._collectionItemPropertyType.getProperty(prefix) == null) continue;
            return entryProp.getName();
        }
        return null;
    }

    private static String getPrefix(String str) {
        int index = str.indexOf(46);
        index = index > 0 ? index : str.length();
        return str.substring(0, index);
    }

    public static List<String> getProperties(DynamicObject bill) {
        ArrayList<String> props = new ArrayList<String>();
        DataEntityPropertyCollection properties = bill.getDataEntityType().getProperties();
        for (IDataEntityProperty prop : properties) {
            if (prop instanceof EntryProp) {
                DataEntityPropertyCollection entryProperties = ((EntryProp)prop)._collectionItemPropertyType.getProperties();
                for (IDataEntityProperty eProp : entryProperties) {
                    props.add(eProp.getName());
                }
            }
            props.add(prop.getName());
        }
        return props;
    }

    public static List<EntryProp> getEntryProps(IDataEntityType dataType) {
        ArrayList<EntryProp> entrys = new ArrayList<EntryProp>();
        DataEntityPropertyCollection properties = dataType.getProperties();
        for (IDataEntityProperty pro : properties) {
            if (!(pro instanceof EntryProp) || pro instanceof LinkEntryProp) continue;
            entrys.add((EntryProp)pro);
        }
        return entrys;
    }

    public static IDataEntityProperty getMainOrgProp(String entityKey) {
        MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)entityKey);
        DataEntityPropertyCollection properties = dt.getProperties();
        for (IDataEntityProperty prop : properties) {
            if (!(prop instanceof MainOrgProp)) continue;
            return prop;
        }
        return null;
    }

    public static boolean isExistProperty(DynamicObject bill, String propertyName) {
        DynamicProperty property;
        boolean isExistProperty = false;
        DynamicObjectType dynamicObjectType = bill.getDynamicObjectType();
        if (dynamicObjectType != null && (property = dynamicObjectType.getProperty(propertyName)) != null) {
            isExistProperty = true;
        }
        return isExistProperty;
    }

    public static String getOpDisplayName(String entityKey, String op) {
        List entityOperates = EntityMetadataCache.getDataEntityOperate((String)entityKey);
        for (Map opConfigs : entityOperates) {
            if (!Objects.equals(op, opConfigs.get("key"))) continue;
            LocaleString caption = LocaleString.fromMap((Map)((Map)opConfigs.get("name")));
            return caption.getLocaleValue();
        }
        return op;
    }
}

