/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.mservice.upgrade;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.ccm.business.archives.DefaultArchiveLoader;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;

public class ArchiveApplyFieldsUpgradePlugin
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String log = "";
        try (TXHandle txHandle = TX.required();){
            try {
                this.upgrade();
            }
            catch (Exception e) {
                txHandle.markRollback();
                log = this.getStackTraceMessage(e);
            }
        }
        UpgradeResult upgradeResult = new UpgradeResult();
        upgradeResult.setSuccess(true);
        upgradeResult.setLog(log);
        return upgradeResult;
    }

    private void upgrade() {
        Object[] archiveApplys = BusinessDataServiceHelper.load((String)"ccm_archive_apply", (String)"scheme,roletype0,roletype1,roletype2,roletype3,role0,role1,role2,role3,archiveid", (QFilter[])new QFilter[]{new QFilter("entry.archiveid", "=", (Object)0L), new QFilter("billstatus", "=", (Object)"C")});
        if (ObjectUtils.isEmpty((Object[])archiveApplys)) {
            return;
        }
        LinkedList<Long> schemeIds = new LinkedList<Long>();
        LinkedList<String> dimensionValues = new LinkedList<String>();
        HashMap<Long, String> dimensionValueMap = new HashMap<Long, String>();
        for (Object archiveApply : archiveApplys) {
            schemeIds.add(archiveApply.getDynamicObject("scheme").getLong("id"));
            DynamicObject dimension = archiveApply.getDynamicObject("scheme").getDynamicObject("dimension");
            DimensionEntryFieldMapper mapper = new DimensionEntryFieldMapper(dimension.getPkValue());
            List fieldKeys = mapper.getRoleFieldKeys();
            DynamicObjectCollection entry = archiveApply.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                String dimensionValue = this.getDimensionValue(fieldKeys, row);
                dimensionValues.add(dimensionValue);
                dimensionValueMap.put(row.getLong("id"), dimensionValue);
            }
        }
        HashMap<String, Long> archiveMap = new HashMap<String, Long>();
        DefaultArchiveLoader archiveLoader = new DefaultArchiveLoader();
        DynamicObjectCollection archives = archiveLoader.loadArchives(schemeIds, dimensionValues);
        for (DynamicObject archive : archives) {
            archiveMap.put(archive.getString("dimensionvalue") + archive.getLong("scheme"), archive.getLong("id"));
        }
        for (Object archiveApply : archiveApplys) {
            DynamicObject scheme = archiveApply.getDynamicObject("scheme");
            DynamicObjectCollection entry = archiveApply.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                String dimensionValue = (String)dimensionValueMap.get(row.getLong("id"));
                if (ObjectUtils.isEmpty((Object)dimensionValue)) continue;
                long archiveId = (Long)archiveMap.get(dimensionValue + scheme.getLong("id"));
                row.set("archiveid", (Object)archiveId);
            }
        }
        SaveServiceHelper.save((DynamicObject[])archiveApplys);
    }

    public String getStackTraceMessage(Exception e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getClass().getName()).append(':');
        sb.append(e.getMessage()).append('\n');
        StackTraceElement[] stackArray = e.getStackTrace();
        for (int i = 0; i < stackArray.length; ++i) {
            StackTraceElement element = stackArray[i];
            sb.append(element).append('\n');
        }
        return sb.toString();
    }

    private String getDimensionValue(List<String> fieldKeys, DynamicObject row) {
        LinkedList<String> pkValues = new LinkedList<String>();
        for (String fieldKey : fieldKeys) {
            if (!(row.get(fieldKey) instanceof DynamicObject)) continue;
            DynamicProperty property = row.getDynamicObject(fieldKey).getDynamicObjectType().getProperty("masterid");
            if (property == null) {
                pkValues.add(row.getDynamicObject(fieldKey).getString("id"));
                continue;
            }
            pkValues.add(row.getDynamicObject(fieldKey).getString("masterid"));
        }
        return String.join((CharSequence)"-", pkValues);
    }
}

