/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.mservice.upgrade;

import java.util.LinkedList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class ArchiveChangeFieldsUpgradePlugin
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String log = "";
        try (TXHandle txHandle = TX.required();){
            try {
                this.upgrade();
            }
            catch (Exception e) {
                txHandle.markRollback();
                log = this.getStackTraceMessage(e);
            }
        }
        UpgradeResult upgradeResult = new UpgradeResult();
        upgradeResult.setSuccess(true);
        upgradeResult.setLog(log);
        return upgradeResult;
    }

    private void upgrade() {
        String queryOldArchiveChangesSql = "SELECT FID,FCREATORID,FCREATETIME,FCHANGEPERSONID,FCHANGEDATE FROM T_CCM_ARCHIVE_CHANGE WHERE FCHANGEPERSONID = 0 OR FCHANGEDATE IS NULL";
        DataSet oldChanges = DB.queryDataSet((String)"ccm.ArchiveChangeFieldsUpgradePlugin", (DBRoute)new DBRoute("im"), (String)queryOldArchiveChangesSql);
        LinkedList<Object[]> updateParams = new LinkedList<Object[]>();
        for (Row oldChange : oldChanges) {
            Object[] param = new Object[]{oldChange.getLong("FCREATORID"), oldChange.getDate("FCREATETIME"), oldChange.getLong("FID")};
            updateParams.add(param);
        }
        String updateSql = "UPDATE T_CCM_ARCHIVE_CHANGE SET FCHANGEPERSONID=?, FCHANGEDATE=? WHERE FID=?";
        if (!ObjectUtils.isEmpty(updateParams)) {
            DB.executeBatch((DBRoute)new DBRoute("im"), (String)updateSql, updateParams);
        }
    }

    public String getStackTraceMessage(Exception e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getClass().getName()).append(':');
        sb.append(e.getMessage()).append('\n');
        StackTraceElement[] stackArray = e.getStackTrace();
        for (int i = 0; i < stackArray.length; ++i) {
            StackTraceElement element = stackArray[i];
            sb.append(element).append('\n');
        }
        return sb.toString();
    }
}

