/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.mservice.upgrade;

import java.util.Arrays;
import java.util.LinkedList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class ArchiveQuotaFieldsUpgradePlugin
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String log = "";
        try (TXHandle txHandle = TX.required();){
            try {
                this.upgrade();
            }
            catch (Exception e) {
                txHandle.markRollback();
                log = this.getStackTraceMessage(e);
            }
        }
        UpgradeResult upgradeResult = new UpgradeResult();
        upgradeResult.setSuccess(true);
        upgradeResult.setLog(log);
        return upgradeResult;
    }

    private void upgrade() {
        String queryJournalsSql = "SELECT FSCHEMEID,FDIMENSIONVALUE,FDIRECTION,FAMOUNT FROM T_CCM_JOURNAL WHERE FQUOTATYPE = 'amount'";
        DataSet journals = DB.queryDataSet((String)"ccm.JournalRoleFieldsUpgradePlugin", (DBRoute)new DBRoute("im"), (String)queryJournalsSql);
        String[] groupbySelectors = new String[]{"fschemeid", "fdimensionvalue", "fdirection"};
        DataSet finish = journals.groupBy(groupbySelectors).sum("FAMOUNT").finish();
        LinkedList<Object> rowDatas = new LinkedList<Object>();
        for (Row row : finish) {
            Object[] rowData = new Object[]{row.getBigDecimal("famount"), row.getLong("fschemeid"), row.getString("fdimensionvalue"), row.getString("fdirection")};
            rowDatas.add(rowData);
        }
        LinkedList<Object[]> updateReduceParams = new LinkedList<Object[]>();
        LinkedList<Object[]> updateIncreaseParams = new LinkedList<Object[]>();
        for (Object[] objectArray : rowDatas) {
            Object[] param = Arrays.copyOf(objectArray, objectArray.length - 1);
            if ("REDUCE".equals(objectArray[objectArray.length - 1])) {
                updateReduceParams.add(param);
                continue;
            }
            if (!"INCREASE".equals(objectArray[objectArray.length - 1])) continue;
            updateIncreaseParams.add(param);
        }
        String updateReduceSql = "UPDATE T_CCM_ARCHIVE SET FREDUCESUM=? WHERE FSCHEMEID=? AND FDIMENSIONVALUE=? AND FQUOTATYPE = 'amount' AND FARCHIVETYPE = 'normal'";
        String string = "UPDATE T_CCM_ARCHIVE SET FINCREASESUM=? WHERE FSCHEMEID=? AND FDIMENSIONVALUE=? AND FQUOTATYPE = 'amount' AND FARCHIVETYPE = 'normal'";
        if (!ObjectUtils.isEmpty(updateReduceParams)) {
            DB.executeBatch((DBRoute)new DBRoute("im"), (String)updateReduceSql, updateReduceParams);
        }
        if (!ObjectUtils.isEmpty(updateIncreaseParams)) {
            DB.executeBatch((DBRoute)new DBRoute("im"), (String)string, updateIncreaseParams);
        }
    }

    public String getStackTraceMessage(Exception e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getClass().getName()).append(':');
        sb.append(e.getMessage()).append('\n');
        StackTraceElement[] stackArray = e.getStackTrace();
        for (int i = 0; i < stackArray.length; ++i) {
            StackTraceElement element = stackArray[i];
            sb.append(element).append('\n');
        }
        return sb.toString();
    }
}

