/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.mservice.upgrade;

import java.util.LinkedList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class BillstrategyFieldsUpgradePlugin
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String log = "";
        try (TXHandle txHandle = TX.required();){
            try {
                this.upgrade();
            }
            catch (Exception e) {
                txHandle.markRollback();
                log = this.getStackTraceMessage(e);
            }
        }
        UpgradeResult upgradeResult = new UpgradeResult();
        upgradeResult.setSuccess(true);
        upgradeResult.setLog(log);
        return upgradeResult;
    }

    private void upgrade() {
        String queryOldBillstrategySql = "SELECT FID,FDATAFILTER_TAG,FNEWDATAFILTER_TAG FROM T_CCM_BILLSTRATEGY WHERE FNEWDATAFILTER_TAG IS NULL";
        DataSet oldBillstrategy = DB.queryDataSet((String)"ccm.BillstrategyFieldsUpgradePlugin", (DBRoute)new DBRoute("im"), (String)queryOldBillstrategySql);
        LinkedList<Object[]> updateBillstrategyParams = new LinkedList<Object[]>();
        for (Row oldChange : oldBillstrategy) {
            Object[] param = new Object[]{oldChange.get("FDATAFILTER_TAG"), oldChange.getLong("FID")};
            updateBillstrategyParams.add(param);
        }
        String updateBillstrategySql = "UPDATE T_CCM_BILLSTRATEGY SET FNEWDATAFILTER_TAG=? WHERE FID=?";
        if (!ObjectUtils.isEmpty(updateBillstrategyParams)) {
            DB.executeBatch((DBRoute)new DBRoute("im"), (String)updateBillstrategySql, updateBillstrategyParams);
        }
        String queryOldRecalentrySql = "SELECT FENTRYID,FRECALFILTER_TAG, FNEWRECALFILTER_TAG,FRECALFORMULA_TAG, FNEWRECALFORMULA_TAG FROM T_CCM_BS_RECALENTRY WHERE FNEWRECALFILTER_TAG IS NULL OR FNEWRECALFORMULA_TAG IS NULL";
        DataSet oldRecalentry = DB.queryDataSet((String)"ccm.BillstrategyFieldsUpgradePlugin", (DBRoute)new DBRoute("im"), (String)queryOldRecalentrySql);
        LinkedList<Object[]> updateRecalentryParams = new LinkedList<Object[]>();
        for (Row oldChange : oldRecalentry) {
            Object[] param = new Object[]{oldChange.get("FRECALFILTER_TAG"), oldChange.get("FRECALFORMULA_TAG"), oldChange.getLong("FENTRYID")};
            updateRecalentryParams.add(param);
        }
        String updateRecalentrySql = "UPDATE T_CCM_BS_RECALENTRY SET FNEWRECALFILTER_TAG=?,FNEWRECALFORMULA_TAG=? WHERE FENTRYID=?";
        if (!ObjectUtils.isEmpty(updateRecalentryParams)) {
            DB.executeBatch((DBRoute)new DBRoute("im"), (String)updateRecalentrySql, updateRecalentryParams);
        }
        String queryOldCheckentrySql = "SELECT FENTRYID,FCHECKFILTER_TAG, FNEWCHECKFILTER_TAG,FCHECKFORMULA_TAG, FNEWCHECKFORMULA_TAG FROM T_CCM_BS_CHECKENTRY WHERE FNEWCHECKFILTER_TAG IS NULL OR FNEWCHECKFORMULA_TAG IS NULL";
        DataSet oldCheckentry = DB.queryDataSet((String)"ccm.BillstrategyFieldsUpgradePlugin", (DBRoute)new DBRoute("im"), (String)queryOldCheckentrySql);
        LinkedList<Object[]> updateCheckentryParams = new LinkedList<Object[]>();
        for (Row oldChange : oldCheckentry) {
            Object[] param = new Object[]{oldChange.get("FCHECKFILTER_TAG"), oldChange.get("FCHECKFORMULA_TAG"), oldChange.getLong("FENTRYID")};
            updateCheckentryParams.add(param);
        }
        String updateCheckentrySql = "UPDATE T_CCM_BS_CHECKENTRY SET FNEWCHECKFILTER_TAG=?,FNEWCHECKFORMULA_TAG=? WHERE FENTRYID=?";
        if (!ObjectUtils.isEmpty(updateCheckentryParams)) {
            DB.executeBatch((DBRoute)new DBRoute("im"), (String)updateCheckentrySql, updateCheckentryParams);
        }
    }

    public String getStackTraceMessage(Exception e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getClass().getName()).append(':');
        sb.append(e.getMessage()).append('\n');
        StackTraceElement[] stackArray = e.getStackTrace();
        for (int i = 0; i < stackArray.length; ++i) {
            StackTraceElement element = stackArray[i];
            sb.append(element).append('\n');
        }
        return sb.toString();
    }
}

