/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.mservice.upgrade;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.threads.ThreadPools;

public class CreditCRHandlerUpgradeService
implements IUpgradeService {
    public static Log logger = LogFactory.getLog(CreditCRHandlerUpgradeService.class);
    private static final String CHECKRESULTHANDLER = "CheckResultHandler";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        ThreadPools.executeOnce((String)this.getClass().getName(), () -> this.doUpdateCreditCRHandler(result));
        result.setSuccess(true);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UpgradeResult doUpdateCreditCRHandler(UpgradeResult result) {
        DBRoute scm_DBRoute = new DBRoute("scm");
        try (DataSet rows = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scm_DBRoute, (String)"select  fid num  from   t_ccm_globalconfig  where  fkey='CheckResultHandler'", null);){
            if (!rows.isEmpty()) {
                result.setSuccess(true);
                result.setLog("data have upgrade success");
                UpgradeResult upgradeResult = result;
                return upgradeResult;
            }
        }
        String querySQL = "select fvalue  from  t_ap_stdconfig  where fkey='CheckResultHandler' order by fid desc";
        try {
            DBRoute fi_DBRoute = new DBRoute("fi");
            try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)fi_DBRoute, (String)querySQL, null);){
                String resourcesValue;
                ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                for (Row row : ds) {
                    Object[] obj = new Object[]{DBServiceHelper.genLongIds((String)"t_ccm_globalconfig", (int)1)[0], CHECKRESULTHANDLER, row.getString("fvalue")};
                    if (paramList.size() >= 1) continue;
                    paramList.add(obj);
                }
                if (paramList.size() <= 0 && StringUtils.isNotBlank((CharSequence)(resourcesValue = this.getResourcesConfig()))) {
                    Object[] obj = new Object[]{DBServiceHelper.genLongIds((String)"t_ccm_globalconfig", (int)1)[0], CHECKRESULTHANDLER, resourcesValue};
                    paramList.add(obj);
                }
                try (TXHandle h = TX.required((String)this.getClass().getName());){
                    try {
                        if (paramList.size() > 0) {
                            String insertSQL = "insert into t_ccm_globalconfig(fid,fkey,fvalue) values(?,?,?)";
                            this.executeSqlBatch(scm_DBRoute, insertSQL, paramList);
                        }
                    }
                    catch (Throwable e) {
                        h.markRollback();
                        result.setSuccess(false);
                        String err = "database execution failed,errorInfo" + e.getMessage();
                        result.setErrorInfo(err);
                        result.setLog("database execution failed,errorMsgInfo" + e.getMessage());
                        logger.info(err);
                        UpgradeResult upgradeResult = result;
                        if (h != null) {
                            if (var9_20 != null) {
                                try {
                                    h.close();
                                }
                                catch (Throwable throwable) {
                                    var9_20.addSuppressed(throwable);
                                }
                            } else {
                                h.close();
                            }
                        }
                        if (ds == null) return upgradeResult;
                        if (var6_12 == null) {
                            ds.close();
                            return upgradeResult;
                        }
                        try {
                            ds.close();
                            return upgradeResult;
                        }
                        catch (Throwable throwable) {
                            var6_12.addSuppressed(throwable);
                            return upgradeResult;
                        }
                    }
                }
                logger.info("upgrade data size:{}", (Object)paramList.size());
            }
            catch (Throwable e) {
                result.setSuccess(false);
                String err = "query data field failed,errorMsgInfo\uff1a" + e.getMessage();
                result.setErrorInfo(err);
                result.setLog(err);
                logger.info(err);
                return result;
            }
        }
        catch (Exception exp) {
            logger.info("new data scheme is not exist" + exp);
        }
        result.setLog("data update successful.");
        logger.info("data update successful.");
        return result;
    }

    private void executeSqlBatch(DBRoute dbRoute, String sql, List<Object[]> paramList) {
        DB.executeBatch((DBRoute)dbRoute, (String)sql, paramList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResourcesConfig() {
        HashMap<String, String> configMap = new HashMap<String, String>(16);
        InputStream resourceAsStream = null;
        try {
            Properties properties = new Properties();
            resourceAsStream = CreditCRHandlerUpgradeService.class.getClassLoader().getResourceAsStream("ccmconfig.properties");
            if (resourceAsStream != null) {
                properties.load(resourceAsStream);
            }
            Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
            for (Map.Entry<Object, Object> entry : entrySet) {
                configMap.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        finally {
            try {
                if (resourceAsStream != null) {
                    resourceAsStream.close();
                }
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
        return (String)configMap.get(CHECKRESULTHANDLER);
    }
}

