/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.mservice.upgrade;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.OpBizRuleSetServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ccm.business.setting.ServerServiceRegister;

public class CreditOpRegisterUpgradePlugin
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String log = "";
        try (TXHandle txHandle = TX.required();){
            try {
                this.deleteIncreaseOps();
                this.registerNewOps();
            }
            catch (Exception e) {
                txHandle.markRollback();
                log = this.getStackTraceMessage(e);
            }
        }
        UpgradeResult upgradeResult = new UpgradeResult();
        upgradeResult.setSuccess(true);
        upgradeResult.setLog(log);
        return upgradeResult;
    }

    private void registerNewOps() {
        QFilter billStatusFilter = new QFilter("status", "=", (Object)"C");
        QFilter[] filters = new QFilter[]{billStatusFilter};
        DynamicObject[] billStrategies = BusinessDataServiceHelper.load((String)"ccm_billstrategy", (String)"entity,checkops,reduceops,increaseops", (QFilter[])filters);
        ServerServiceRegister serverServiceRegister = new ServerServiceRegister();
        serverServiceRegister.registerService(billStrategies);
    }

    private void deleteIncreaseOps() {
        QFilter billStatusFilter = new QFilter("status", "=", (Object)"C");
        QFilter[] filters = new QFilter[]{billStatusFilter};
        DynamicObjectCollection billStrategies = QueryServiceHelper.query((String)"ccm_billstrategy", (String)"entity", (QFilter[])filters);
        for (DynamicObject billStrategy : billStrategies) {
            OpBizRuleSetServiceHelper.deleteOpBizRuleSet((String)billStrategy.getString("entity"), (String)"IncreaseCredit");
        }
    }

    public String getStackTraceMessage(Exception e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getClass().getName()).append(':');
        sb.append(e.getMessage()).append('\n');
        StackTraceElement[] stackArray = e.getStackTrace();
        for (int i = 0; i < stackArray.length; ++i) {
            StackTraceElement element = stackArray[i];
            sb.append(element).append('\n');
        }
        return sb.toString();
    }
}

