/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.mservice.upgrade;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;

public class JournalRoleFieldsUpgradePlugin
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(JournalRoleFieldsUpgradePlugin.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String log = "SUCCESS!";
        String info = "SUCCESS!";
        try {
            this.upgrade();
        }
        catch (Exception e) {
            info = log = JournalRoleFieldsUpgradePlugin.getStackTraceMessage(e);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        resultMap.put("success", Boolean.TRUE);
        resultMap.put("log", log);
        resultMap.put("el", "");
        resultMap.put("info", info);
        return new UpgradeResult(resultMap);
    }

    public void upgrade() {
        HashMap<Long, DimensionEntryFieldMapper> mapperCache = new HashMap<Long, DimensionEntryFieldMapper>(10);
        String sql = "SELECT FID,FDIMENSIONID,FDIMENSIONVALUE FROM T_CCM_JOURNAL WHERE FDIMENSIONID<>0 AND FROLEID0=0";
        DataSet journals = DB.queryDataSet((String)"ccm.JournalRoleFieldsUpgradePlugin", (DBRoute)new DBRoute("im"), (String)sql);
        LinkedList<Object[]> updateParams = new LinkedList<Object[]>();
        StringBuilder msg = new StringBuilder();
        for (Row row : journals) {
            List roleNumbers;
            String[] dimensionValues;
            Long dimensionId = row.getLong("FDIMENSIONID");
            DimensionEntryFieldMapper fieldMapper = (DimensionEntryFieldMapper)mapperCache.get(dimensionId);
            if (fieldMapper == null) {
                try {
                    fieldMapper = new DimensionEntryFieldMapper((Object)dimensionId);
                    mapperCache.put(dimensionId, fieldMapper);
                }
                catch (Exception e) {
                    msg.append(e.getMessage());
                    continue;
                }
            }
            if ((dimensionValues = row.getString("FDIMENSIONVALUE").split("[-]")).length != (roleNumbers = fieldMapper.getRoleNumbers()).size()) continue;
            Object[] param = new Object[]{0, " ", 0, " ", 0, " ", 0, " ", 0};
            int paramIndex = 0;
            for (int i = 0; i < roleNumbers.size(); ++i) {
                String roleType = (String)roleNumbers.get(i);
                String baseDataKey = fieldMapper.getBaseDataKey(roleType);
                param[paramIndex++] = Long.valueOf(dimensionValues[i]);
                param[paramIndex++] = baseDataKey;
            }
            param[8] = row.getLong("FID");
            updateParams.add(param);
        }
        log.info(msg.toString());
        String updateSql = "UPDATE T_CCM_JOURNAL SET FROLEID0=?,FROLETYPE0=?,FROLEID1=?,FROLETYPE1=?,FROLEID2=?,FROLETYPE2=?,FROLEID3=?,FROLETYPE3=? WHERE FID=?";
        if (!updateParams.isEmpty()) {
            DB.executeBatch((DBRoute)new DBRoute("im"), (String)updateSql, updateParams);
        }
    }

    public static String getStackTraceMessage(Exception e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getClass().getName()).append(':');
        sb.append(e.getMessage()).append('\n');
        StackTraceElement[] stackArray = e.getStackTrace();
        for (int i = 0; i < stackArray.length; ++i) {
            StackTraceElement element = stackArray[i];
            sb.append(element).append('\n');
        }
        return sb.toString();
    }
}

