/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.mservice.upgrade;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class OpBizRuleForSysPreBsUpgradePlugin
implements IUpgradeService {
    private static DBRoute scmDBRoute = new DBRoute("scm");
    private static DBRoute metaDBRoute = new DBRoute("sys.meta");

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String log = "";
        try (TXHandle txHandle = TX.required();){
            try {
                this.upgrade();
            }
            catch (Exception e) {
                txHandle.markRollback();
                log = this.getStackTraceMessage(e);
            }
        }
        UpgradeResult upgradeResult = new UpgradeResult();
        upgradeResult.setSuccess(true);
        upgradeResult.setLog(log);
        return upgradeResult;
    }

    private void upgrade() {
        LinkedList<Object[]> updateOpBizRuleParams = new LinkedList<Object[]>();
        LinkedList<Object[]> updateOpBizRuleEntryParams = new LinkedList<Object[]>();
        HashMap<String, List<String>> upOPRuleMap = new HashMap<String, List<String>>(16);
        HashMap<String, List<String>> checkOPRuleMap = new HashMap<String, List<String>>(16);
        this.buildSysPreBsData(upOPRuleMap, checkOPRuleMap);
        this.buildUpdateOpParam(upOPRuleMap, "UpdateCredit", updateOpBizRuleParams, updateOpBizRuleEntryParams);
        this.buildUpdateOpParam(checkOPRuleMap, "CheckCredit", updateOpBizRuleParams, updateOpBizRuleEntryParams);
        if (!ObjectUtils.isEmpty(updateOpBizRuleParams)) {
            DB.executeBatch((DBRoute)metaDBRoute, (String)this.getInsertOBRuleSQLString(), updateOpBizRuleParams);
        }
        if (!ObjectUtils.isEmpty(updateOpBizRuleEntryParams)) {
            DB.executeBatch((DBRoute)metaDBRoute, (String)this.getInsertOBRuleEntrySQLString(), updateOpBizRuleEntryParams);
        }
    }

    private void buildSysPreBsData(Map<String, List<String>> upOPRuleMap, Map<String, List<String>> checkOPRuleMap) {
        String querySysPreBillstrategySql = "SELECT FID,FSTATUS,FISSYS,FENTITYID,FREDUCEOPS,FINCREASEOPS,FCHECKOPS FROM T_CCM_BILLSTRATEGY WHERE FISSYS = '1' and FSTATUS = 'C' ";
        DataSet sysPreBillStrategys = DB.queryDataSet((String)"ccm.OpBizRuleForSysPreBsUpgradePlugin", (DBRoute)scmDBRoute, (String)querySysPreBillstrategySql);
        for (Row sysBs : sysPreBillStrategys) {
            String[] checkOPStrs;
            String checkOPs;
            String increaseOPs;
            LinkedList<String> upOpList = new LinkedList<String>();
            LinkedList<String> checkOpList = new LinkedList<String>();
            String entityid = sysBs.getString("FENTITYID");
            String reduceOPs = sysBs.getString("FREDUCEOPS");
            if (!StringUtils.isEmpty((CharSequence)reduceOPs)) {
                String[] reduceOpStrs;
                for (String reduceOp : reduceOpStrs = reduceOPs.split(",")) {
                    if (StringUtils.isEmpty((CharSequence)reduceOp)) continue;
                    upOpList.add(reduceOp);
                }
            }
            if (!StringUtils.isEmpty((CharSequence)(increaseOPs = sysBs.getString("FINCREASEOPS")))) {
                String[] increaseOpStrs;
                for (String increaseOp : increaseOpStrs = increaseOPs.split(",")) {
                    if (StringUtils.isEmpty((CharSequence)increaseOp)) continue;
                    upOpList.add(increaseOp);
                }
            }
            if (upOpList != null && upOpList.size() > 0) {
                upOPRuleMap.put(entityid, upOpList);
            }
            if (StringUtils.isEmpty((CharSequence)(checkOPs = sysBs.getString("FCHECKOPS")))) continue;
            for (String checkOp : checkOPStrs = checkOPs.split(",")) {
                if (StringUtils.isEmpty((CharSequence)checkOp)) continue;
                checkOpList.add(checkOp);
            }
            checkOPRuleMap.put(entityid, checkOpList);
        }
    }

    private void buildUpdateOpParam(Map<String, List<String>> needUpOPRuleMap, String opBizRuleKey, List<Object[]> updateOpBizRuleParams, List<Object[]> updateOpBizRuleEntryParams) {
        if (needUpOPRuleMap != null && !needUpOPRuleMap.isEmpty()) {
            String queryUpOpBizRuleSql = "SELECT R.FID AS ID, R.FOBJECTTYPEID AS OBJECTTYPEID, R.FOPBIZRULE AS OPBIZRULE, RE.FOPERATIONKEY AS OPKEY ,RE.FENTRYID as ENTRYID FROM T_META_OPBIZRULESET R LEFT JOIN T_META_OPBIZRULESETENTRY RE ON RE.FID = R.FID WHERE R.FOBJECTTYPEID IN ('sm_salorder','sm_delivernotice','im_saloutbill','ar_finarbill','cas_recbill') AND R.FOPBIZRULE = ? ";
            DataSet UpOpBizRules = DB.queryDataSet((String)"ccm.OpBizRuleForSysPreBsUpgradePlugin", (DBRoute)metaDBRoute, (String)queryUpOpBizRuleSql, (Object[])new Object[]{opBizRuleKey});
            for (Map.Entry<String, List<String>> upEntry : needUpOPRuleMap.entrySet()) {
                String eid = upEntry.getKey();
                List<String> needUpOpStr = upEntry.getValue();
                DataSet UpOpRulesCopy = UpOpBizRules.copy();
                long ID = 0L;
                int seq = 1;
                for (Row upBR : UpOpRulesCopy) {
                    if (StringUtils.isEmpty((CharSequence)"OBJECTTYPEID") || !upBR.getString("OBJECTTYPEID").equals(eid)) continue;
                    ID = upBR.getLong("ID");
                    String opKey = upBR.getString("OPKEY");
                    if (StringUtils.isEmpty((CharSequence)opKey)) continue;
                    ++seq;
                    if (!needUpOpStr.contains(opKey)) continue;
                    needUpOpStr.remove(opKey);
                }
                if (needUpOpStr == null || needUpOpStr.size() <= 0) continue;
                int opSize = needUpOpStr.size();
                long[] entryids = OpBizRuleForSysPreBsUpgradePlugin.getEntryIds("T_META_OPBIZRULESETENTRY", opSize);
                Object[] insertUpOpBizRuleParam = new Object[3];
                if (ID <= 0L) {
                    ID = OpBizRuleForSysPreBsUpgradePlugin.getEntryId("T_META_OPBIZRULESET");
                    insertUpOpBizRuleParam[0] = ID;
                    insertUpOpBizRuleParam[1] = eid;
                    insertUpOpBizRuleParam[2] = opBizRuleKey;
                    updateOpBizRuleParams.add(insertUpOpBizRuleParam);
                }
                for (String upop : needUpOpStr) {
                    Object[] insertUpOpBizRuleEntryParam = new Object[]{ID, entryids[needUpOpStr.indexOf(upop)], seq++, upop};
                    updateOpBizRuleEntryParams.add(insertUpOpBizRuleEntryParam);
                }
            }
        }
    }

    private static long[] getEntryIds(String tableName, int count) {
        return DB.genLongIds((String)tableName, (int)count);
    }

    private static long getEntryId(String tableName) {
        return DB.genLongId((String)tableName);
    }

    private String getInsertOBRuleSQLString() {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO T_META_OPBIZRULESET (FID,FOBJECTTYPEID,FOPBIZRULE)");
        sb.append(" VALUES (?,?,?)");
        return sb.toString();
    }

    private String getInsertOBRuleEntrySQLString() {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO T_META_OPBIZRULESETENTRY (FID,FENTRYID,FSEQ,FOPERATIONKEY)");
        sb.append(" VALUES (?,?,?,?)");
        return sb.toString();
    }

    public String getStackTraceMessage(Exception e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getClass().getName()).append(':');
        sb.append(e.getMessage()).append('\n');
        StackTraceElement[] stackArray = e.getStackTrace();
        for (int i = 0; i < stackArray.length; ++i) {
            StackTraceElement element = stackArray[i];
            sb.append(element).append('\n');
        }
        return sb.toString();
    }
}

