/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.formplugin.basedata;

import com.alibaba.fastjson.JSON;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.WebOffice;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.control.events.webOffice.WebOfficeDataListener;
import kd.bos.form.control.events.webOffice.event.WebOfficeBookmarkCheckEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeBookmarkEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeBookmarkValueEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeCheckboxEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeDocChangeEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeIsFieldReviseEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeOpenStatusEvent;
import kd.bos.form.control.model.WebOfficeMark;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.attachment.FilePathService;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.business.helper.DynamicObjectHelper;
import kd.mpscmm.mscon.common.utils.MetaDataHelper;
import kd.scmc.conm.business.helper.ConmAppCacheHelper;
import kd.scmc.conm.business.helper.FileHelper;
import kd.scmc.conm.business.helper.TemplateHelper;
import kd.scmc.conm.business.service.cooperate.impl.CooperateServiceExecutor;
import kd.scmc.conm.business.service.cooperate.pojo.CooperateResponse;
import kd.scmc.conm.enums.BizConfirmStatusEnum;
import kd.scmc.conm.utils.CommonUtils;
import kd.sdk.scmc.conm.extpoint.IWebOfficePlugin;

public class ContractPreviewPlugin
extends AbstractFormPlugin
implements UploadListener,
WebOfficeDataListener {
    private static final Log log = LogFactory.getLog(ContractPreviewPlugin.class);
    private static final String WEBOFFICEAP = "webofficeap";
    private MainEntityType parentEntityType = null;
    private static final HashSet<String> entitySet = new HashSet(10);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getControl("toolbarap");
        toolbar.addItemClickListener((ItemClickListener)this);
        WebOffice webOffice = (WebOffice)this.getControl(WEBOFFICEAP);
        webOffice.addUploadListener((UploadListener)this);
        webOffice.addDataListener((WebOfficeDataListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject parentDataEntity = this.getParentDataEntity();
        String pathv3 = this.getPathV3(parentDataEntity);
        String pathv2 = this.getPathV2(parentDataEntity);
        String path = this.getPath(parentDataEntity);
        WebOffice webOffice = (WebOffice)this.getControl(WEBOFFICEAP);
        FileService afs = FileServiceFactory.getAttachmentFileService();
        if (StringUtils.isNotEmpty((String)pathv3) && afs.exists(pathv3)) {
            String path3 = UrlService.getAttachmentFullUrl((String)CommonUtils.urlEncode((String)pathv3, (String)"utf-8"));
            log.info("pathV3 = " + path3);
            webOffice.open(path3);
        } else if (afs.exists(pathv2)) {
            String path2 = UrlService.getAttachmentFullUrl((String)CommonUtils.urlEncode((String)pathv2, (String)"utf-8"));
            log.info("pathV2 = " + path2);
            webOffice.open(path2);
        } else if (afs.exists(path)) {
            String path1 = UrlService.getAttachmentFullUrl((String)CommonUtils.urlEncode((String)path, (String)"utf-8"));
            log.info("path = " + path1);
            webOffice.open(path1);
        } else {
            String fullUrl = this.getFullUrl(parentDataEntity);
            log.info("fullUrl = " + fullUrl);
            webOffice.open(fullUrl);
            webOffice.getAllBookmarks("replaceMark");
        }
    }

    private String getPath(DynamicObject parentDataEntity) {
        DynamicObject template = parentDataEntity.getDynamicObject("template");
        DynamicObject version = parentDataEntity.getDynamicObject("templateversion");
        String entity = parentDataEntity.getDynamicObjectType().getName();
        if ("conm_xpurcontract".equals(entity) || "conm_xsalcontract".equals(entity)) {
            template = parentDataEntity.getDynamicObject("xtemplate");
            version = parentDataEntity.getDynamicObject("xtemplateversion");
        }
        return '/' + this.parentEntityType.getName() + '/' + template.getPkValue() + '/' + version.getPkValue() + '/' + this.getFileName(parentDataEntity) + TemplateHelper.getDocFileSuffix();
    }

    private String getPathV2(DynamicObject parentDataEntity) {
        DynamicObject template = parentDataEntity.getDynamicObject("template");
        DynamicObject version = parentDataEntity.getDynamicObject("templateversion");
        String entity = parentDataEntity.getDynamicObjectType().getName();
        if ("conm_xpurcontract".equals(entity) || "conm_xsalcontract".equals(entity)) {
            template = parentDataEntity.getDynamicObject("xtemplate");
            version = parentDataEntity.getDynamicObject("xtemplateversion");
        }
        return '/' + this.parentEntityType.getName() + '/' + parentDataEntity.getPkValue() + '/' + template.getPkValue() + '/' + version.getPkValue() + '/' + this.getFileName(parentDataEntity) + TemplateHelper.getDocFileSuffix();
    }

    private String getPathV3(DynamicObject parentDataEntity) {
        Map attachment;
        QFilter qFilter = new QFilter("finterid", "=", (Object)parentDataEntity.getPkValue().toString()).and(new QFilter("fattachmentpanel", "=", (Object)"tempattachment")).and(new QFilter("fbilltype", "=", (Object)parentDataEntity.getDataEntityType().getName()));
        DynamicObjectCollection bos_attachment = QueryServiceHelper.query((String)"bos_attachment", (String)"id,fattachmentname,fattachmentsize,ffileid,fnumber,fattachmentpanel,fextname,fcreatetime", (QFilter[])qFilter.toArray(), (String)"fcreatetime desc");
        ArrayList tempAttachments = new ArrayList();
        for (DynamicObject attach : bos_attachment) {
            HashMap<String, Object> fileInfo = new HashMap<String, Object>();
            fileInfo.put("url", attach.getString("ffileid"));
            fileInfo.put("createdate", attach.getDate("fcreatetime"));
            fileInfo.put("type", attach.getString("fextname"));
            tempAttachments.add(fileInfo);
        }
        if (tempAttachments != null && tempAttachments.size() > 0 && (attachment = (Map)tempAttachments.get(0)) != null) {
            String url = (String)attachment.get("url");
            String type = (String)attachment.get("type");
            if (StringUtils.isNotEmpty((String)url)) {
                String realPath = new FilePathService().getRealPath(url);
                this.getView().getPageCache().put("openFileType", type);
                return realPath;
            }
        }
        return null;
    }

    private String getBindingPath(DynamicObject parentDataEntity, String fileType) {
        DynamicObject template = parentDataEntity.getDynamicObject("template");
        String entity = parentDataEntity.getDynamicObjectType().getName();
        if ("conm_xpurcontract".equals(entity) || "conm_xsalcontract".equals(entity)) {
            template = parentDataEntity.getDynamicObject("xtemplate");
        }
        if (template == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5408\u540c\u6a21\u677f\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u7ef4\u62a4\u5408\u540c\u6a21\u677f\u6587\u4ef6\u4fe1\u606f\u3002", (String)"ContractPreviewPlugin_0", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
        }
        return "/binding/" + this.parentEntityType.getName() + '/' + parentDataEntity.getPkValue() + '/' + this.getFileName(parentDataEntity) + "." + fileType;
    }

    private static String replaceSpeChar(String str) {
        for (int i = 0; i < AttachmentServiceHelper.SPECIAL_CHARACTERS.length; ++i) {
            if (!str.contains(AttachmentServiceHelper.SPECIAL_CHARACTERS[i])) continue;
            str = str.replace(AttachmentServiceHelper.SPECIAL_CHARACTERS[i], "");
        }
        return str;
    }

    private void coverSignAttachment(WebOffice webOffice, DynamicObject attachment) {
        if (attachment != null) {
            String fileName = attachment.getString("fattachmentname");
            if (StringUtils.isEmpty((String)fileName)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u6587\u4ef6\u540d\u79f0\u9519\u8bef", (String)"", (String)"", (Object[])new Object[0]));
                return;
            }
            this.getView().getPageCache().put("fileName", fileName.substring(0, fileName.lastIndexOf(46)));
            this.getView().getPageCache().put("fileType", fileName.substring(fileName.lastIndexOf(46) + 1));
            this.getView().getPageCache().put("fid", attachment.getString("id"));
            webOffice.save(this.getFileName(this.getParentDataEntity()) + TemplateHelper.getDocFileSuffix(), "bar_attachment");
        }
    }

    private void showSaveForm() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("conm_filesave");
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.Modal);
        parameter.setOpenStyle(openStyle);
        parameter.setCustomParam("filename", (Object)this.getFileName(this.getParentDataEntity()));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "generateAttachment"));
        this.getView().showForm(parameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getResult() == MessageBoxResult.Yes && Objects.equals("bar_reload", e.getCallBackId().toLowerCase())) {
            WebOffice webOffice = (WebOffice)this.getControl(WEBOFFICEAP);
            webOffice.close();
            String fullUrl = this.getFullUrl(this.getParentDataEntity());
            if (StringUtils.isNotEmpty((String)fullUrl)) {
                webOffice.open(fullUrl);
                webOffice.getAllBookmarks("replaceMark");
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
        if (returnData != null) {
            String type = (String)returnData.get("type");
            this.getView().getPageCache().put("fileType", type);
            this.getView().getPageCache().put("fileName", (String)returnData.get("filename"));
            if ("generateAttachment".equals(actionId)) {
                WebOffice webOffice = (WebOffice)this.getControl(WEBOFFICEAP);
                if (!"pdf".equalsIgnoreCase(type)) {
                    webOffice.save(this.getFileName(this.getParentDataEntity()) + "." + type, "bar_attachment");
                } else {
                    String openFileType = this.getView().getPageCache().get("openFileType");
                    if (StringUtils.isEmpty((String)openFileType)) {
                        openFileType = "doc";
                    }
                    webOffice.save(this.getFileName(this.getParentDataEntity()) + "." + openFileType, "bar_attachment");
                }
            }
        }
    }

    public void afterUpload(UploadEvent evt) {
        super.afterUpload(evt);
        if (!WEBOFFICEAP.equals(evt.getCallbackKey())) {
            return;
        }
        Object[] urls = evt.getUrls();
        if (null == urls || urls.length == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9644\u4ef6\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"ContractPreviewPlugin_2", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
            return;
        }
        Map urlData = (Map)urls[0];
        String opType = (String)urlData.get("id");
        String url = (String)urlData.get("url");
        String name = (String)urlData.get("name");
        String fid = this.getPageCache().get("fid");
        DynamicObject bill = this.getParentDataEntity();
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        if (Objects.equals("bar_save", opType)) {
            DynamicObjectCollection attachments = FileHelper.getAttachmentFile((DynamicObject)bill, (String)"tempattachment");
            String formId = bill.getDataEntityType().getName();
            Object pkValue = bill.getPkValue();
            for (DynamicObject attachment : attachments) {
                AttachmentServiceHelper.remove((String)formId, (Object)pkValue, (Object)attachment.getString("fnumber"));
            }
            this.bindTempFileToBill(url, name, bill, "tempattachment");
            cache.remove(url);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"ContractPreviewPlugin_7", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (Objects.equals("bar_attachment", opType)) {
            String fileType = this.getView().getPageCache().get("fileType");
            String fileName = this.getView().getPageCache().get("fileName");
            try (ByteArrayOutputStream outputStream = this.readInputStream(cache.getInputStream(url));){
                int size = outputStream.size();
                DynamicObjectCollection attachments = FileHelper.getAttachmentFile((DynamicObject)bill, (String)"tempattachment");
                String formId = bill.getDataEntityType().getName();
                Object billId = bill.getPkValue();
                for (DynamicObject attachment : attachments) {
                    AttachmentServiceHelper.remove((String)formId, (Object)billId, (Object)attachment.getString("fnumber"));
                }
                String middleUrl = this.bindTempFileToBill(url, name, bill, "tempattachment");
                cache.remove(url);
                InputStream is = null;
                is = "pdf".equalsIgnoreCase(fileType) ? FileHelper.wordToPdf((String)middleUrl, (String)name) : new ByteArrayInputStream(outputStream.toByteArray());
                if (is == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210PDF\u6587\u4ef6\u5931\u8d25\u3002", (String)"ContractPreviewPlugin_17", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                }
                String finalFileName = fileName + "." + fileType;
                String persistUrl = this.uploadInputStream(bill, is, finalFileName);
                try (TXHandle tx = TX.required((String)"conm_generateAttachmentFile");){
                    try {
                        QFilter fidFilter;
                        DynamicObject attachment;
                        boolean isReplace = false;
                        String uid = null;
                        if (fid != null && (attachment = BusinessDataServiceHelper.loadSingle((String)"bos_attachment", (String)"fcreatetime,fcreatemen", (QFilter[])new QFilter[]{fidFilter = new QFilter("id", "=", (Object)Long.valueOf(fid))})) != null) {
                            uid = attachment.getString("fnumber");
                            FileHelper.bindFile((String)uid, (String)finalFileName, (int)size, (String)persistUrl, (String)formId, (Object)billId, (String)"signattachment");
                            attachment.set("fcreatetime", (Object)new Date());
                            attachment.set("fcreatemen", (Object)RequestContext.get().getCurrUserId());
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attachment});
                            isReplace = true;
                        }
                        if (!isReplace) {
                            uid = AttachmentServiceHelper.generateUid();
                            FileHelper.bindFile((String)uid, (String)finalFileName, (int)size, (String)persistUrl, (String)formId, (Object)billId, (String)"signattachment");
                        }
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("name", finalFileName);
                        map.put("url", persistUrl);
                        map.put("size", size);
                        if (StringUtils.isNotEmpty((String)uid)) {
                            map.put("uid", uid);
                        }
                        this.syncAttach(map, "attach-add", bill);
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        String msg = ResManager.loadKDString((String)"\u751f\u6210\u9644\u4ef6\u5931\u8d25", (String)"ContractPreviewPlugin_16", (String)"scmc-conm-formplugin", (Object[])new Object[0]);
                        log.warn(msg, (Throwable)e);
                        this.getView().showTipNotification(msg);
                    }
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u751f\u6210\u9644\u4ef6\u6210\u529f", (String)"ContractPreviewPlugin_8", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
            }
            catch (IOException e) {
                String msg = ResManager.loadKDString((String)"\u751f\u6210\u9644\u4ef6\u5931\u8d25", (String)"ContractPreviewPlugin_16", (String)"scmc-conm-formplugin", (Object[])new Object[0]);
                log.warn(msg, (Throwable)e);
                this.getView().showTipNotification(msg);
            }
            return;
        }
    }

    private String getFullUrl(DynamicObject parDym) {
        DynamicObject attachmententry;
        DynamicObject templateversion = parDym.getDynamicObject("templateversion");
        String entity = parDym.getDynamicObjectType().getName();
        if ("conm_xpurcontract".equals(entity) || "conm_xsalcontract".equals(entity)) {
            templateversion = parDym.getDynamicObject("xtemplateversion");
        }
        if (templateversion == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u6a21\u677f\u7248\u672c\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"ContractPreviewPlugin_13", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
            return null;
        }
        String templateUrl = "";
        String templateType = "";
        if (templateversion != null && (attachmententry = BusinessDataServiceHelper.loadSingle((String)"conm_template", (String)"attachmententry.attachmentfile", (QFilter[])new QFilter[]{new QFilter("attachmententry.id", "=", templateversion.getPkValue())})) != null) {
            DynamicObjectCollection entrys = attachmententry.getDynamicObjectCollection("attachmententry");
            for (DynamicObject entry : entrys) {
                DynamicObjectCollection attachmentfile;
                if (!entry.getPkValue().equals(templateversion.getPkValue()) || (attachmentfile = entry.getDynamicObjectCollection("attachmentfile")) == null || attachmentfile.size() < 1) continue;
                DynamicObject file = (DynamicObject)attachmentfile.get(0);
                DynamicObject fbasedataid = file.getDynamicObject("fbasedataid");
                templateType = fbasedataid.getString("type");
                templateUrl = fbasedataid.getString("url");
            }
        }
        if (StringUtils.isEmpty((String)templateUrl)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5408\u540c\u6a21\u677f\u6587\u4ef6\u4fe1\u606f\u7f3a\u5931\uff0c\u8bf7\u5148\u7ef4\u62a4\u5408\u540c\u6a21\u677f\u3002", (String)"ContractPreviewPlugin_4", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
            return null;
        }
        if (StringUtils.isNotEmpty((String)templateType)) {
            this.getView().getPageCache().put("openFileType", templateType);
        }
        if (templateUrl.startsWith(UrlService.getDomainContextUrl())) {
            return templateUrl;
        }
        return UrlService.getAttachmentFullUrl((String)CommonUtils.urlEncode((String)templateUrl, (String)"utf-8"));
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        WebOffice webOffice = (WebOffice)this.getControl(WEBOFFICEAP);
        switch (key = evt.getItemKey().toLowerCase()) {
            case "btn_replace": {
                webOffice.getAllBookmarks("replaceMark");
                break;
            }
            case "bar_attachment": {
                DynamicObject parentEntity = this.getParentDataEntity();
                DynamicObjectCollection bos_attachment = FileHelper.getAttachmentFile((DynamicObject)parentEntity, (String)"signattachment");
                List<DynamicObject> list = this.getFileByPath(bos_attachment, "/binding/");
                int size = list.size();
                if (size == 0) {
                    this.showSaveForm();
                    break;
                }
                if (size > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8def\u5f84\u4e0b\u5b58\u5728\u591a\u4e2a\u6587\u4ef6\uff0c\u65e0\u6cd5\u81ea\u52a8\u8986\u76d6", (String)"", (String)"", (Object[])new Object[0]));
                    break;
                }
                if (size != 1) break;
                this.coverSignAttachment(webOffice, list.get(0));
                break;
            }
            case "bar_save": {
                String fileType = this.getView().getPageCache().get("openFileType");
                if (StringUtils.isEmpty((String)fileType)) {
                    fileType = "doc";
                }
                webOffice.save(this.getFileName(this.getParentDataEntity()) + "." + fileType, key);
                break;
            }
            case "bar_reload": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u91cd\u65b0\u52a0\u8f7d\u5c06\u6309\u7167\u6a21\u677f\u91cd\u6784\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ContractPreviewPlugin_1", (String)"scmc-conm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(key));
                break;
            }
        }
    }

    private String uploadInputStream(DynamicObject bill, InputStream inputStream, String fileName) {
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        MainEntityType type = (MainEntityType)bill.getDataEntityType();
        String entityId = type.getName();
        String appId = type.getAppId();
        Object pkId = bill.getPkValue();
        String fileUrl = FileNameUtils.getAttachmentFileName((String)tenantId, (String)accountId, (String)appId, (String)entityId, (Object)ContractPreviewPlugin.replaceSpeChar(String.valueOf(pkId)), (String)(uuid + "/binding/" + fileName));
        FileItem fileItem = new FileItem(fileName, fileUrl, inputStream);
        fileItem.setCreateNewFileWhenExists(true);
        FileService service = FileServiceFactory.getAttachmentFileService();
        return service.upload(fileItem);
    }

    private String bindTempFileToBill(String tempUrl, String docName, DynamicObject bill, String attachKey) {
        String formId = bill.getDataEntityType().getName();
        Object pkValue = bill.getPkValue();
        String middleUrl = AttachmentServiceHelper.saveTempToFileService((String)tempUrl, (String)"conm", (String)formId, (Object)pkValue, (String)docName, (boolean)false, (boolean)true);
        ArrayList attachs = new ArrayList();
        HashMap<String, Object> fileInfo = new HashMap<String, Object>();
        fileInfo.put("name", docName);
        fileInfo.put("url", middleUrl);
        try {
            String realPath = new FilePathService().getRealPath(middleUrl);
            fileInfo.put("size", AttachmentServiceHelper.getFileSizeByPath((String)realPath));
        }
        catch (Exception e) {
            fileInfo.put("size", 2048);
            log.info(e.getMessage());
        }
        attachs.add(fileInfo);
        AttachmentServiceHelper.upload((String)formId, (Object)pkValue, (String)attachKey, attachs);
        return middleUrl;
    }

    private boolean syncAttach(Map<String, Object> attach, String operate, DynamicObject bill) {
        String formId = bill.getDataEntityType().getName();
        if (!entitySet.contains(formId)) {
            return true;
        }
        String billStatus = bill.getString("billstatus");
        Boolean iscollaconsult = bill.getBoolean("iscollaconsult");
        QFilter qFilter = new QFilter("id", "=", bill.getPkValue());
        DynamicObject object = BusinessDataServiceHelper.loadSingle((String)bill.getDataEntityType().getName(), (String)"id,confirmstatus", (QFilter[])new QFilter[]{qFilter});
        String confirmstatus = null;
        confirmstatus = object == null ? bill.getString("confirmstatus") : object.getString("confirmstatus");
        if (("C".equals(billStatus) || "B".equals(billStatus) && Boolean.TRUE.equals(iscollaconsult) || "A".equals(billStatus) && BizConfirmStatusEnum.CONFIRM.getValue().equalsIgnoreCase(confirmstatus)) && entitySet.contains(formId)) {
            ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
            data.add(attach);
            if (data.size() > 0) {
                HashMap<String, Object> fileInfo = new HashMap<String, Object>();
                fileInfo.put("attachs", data);
                fileInfo.put("position", "signattachment");
                fileInfo.put("operate", operate);
                if (!fileInfo.isEmpty()) {
                    CooperateResponse response = CooperateServiceExecutor.sync(Collections.singletonList(bill), (String)formId, (String)operate, fileInfo);
                    return response == null || response.isSuccess() != false;
                }
            }
        }
        return true;
    }

    private ByteArrayOutputStream readInputStream(InputStream inputStream) throws IOException {
        int len;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = inputStream.read(buffer)) > -1) {
            outputStream.write(buffer, 0, len);
        }
        outputStream.flush();
        return outputStream;
    }

    private List<DynamicObject> getFileByPath(DynamicObjectCollection bos_attachment, String bindPath) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        FilePathService pathService = new FilePathService();
        for (DynamicObject attach : bos_attachment) {
            String ffileid = attach.getString("ffileid");
            String realPath = pathService.getRealPath(ffileid);
            if (!StringUtils.isNotEmpty((String)bindPath) || !StringUtils.isNotEmpty((String)realPath) || !realPath.contains(bindPath)) continue;
            list.add(attach);
        }
        return list;
    }

    private DynamicObject getParentDataEntity() {
        IFormView parentView;
        IPageCache pageCache;
        FormShowParameter param = this.getView().getFormShowParameter();
        String requestId = (String)param.getCustomParam("requestId");
        String pageId = (String)ConmAppCacheHelper.get((String)requestId, String.class);
        if (StringUtils.isNotEmpty((String)pageId)) {
            pageCache = this.getView().getPageCache();
            pageCache.put("parentPageId", pageId);
            ConmAppCacheHelper.remove((String)requestId);
        } else {
            pageCache = this.getView().getPageCache();
            pageId = pageCache.get("parentPageId");
        }
        if (StringUtils.isNotEmpty((String)pageId) && (parentView = this.getView().getViewNoPlugin(pageId)) != null) {
            if (this.parentEntityType == null) {
                this.parentEntityType = parentView.getModel().getDataEntityType();
            }
            DynamicObject bill = parentView.getModel().getDataEntity(true);
            String entityTypeName = this.parentEntityType.getName();
            if ("conm_xpurcontract".equals(entityTypeName) || "conm_xsalcontract".equals(entityTypeName)) {
                DynamicObject xtemplate = bill.getDynamicObject("xtemplate");
                DynamicObject xtemplateversion = bill.getDynamicObject("xtemplateversion");
                if (xtemplate == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u53d8\u66f4\u5355\u6a21\u677f\u4e3a\u7a7a\u3002", (String)"ContractPreviewPlugin_14", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                }
                if (xtemplateversion == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u53d8\u66f4\u5355\u6a21\u677f\u7248\u672c\u4e3a\u7a7a\u3002", (String)"ContractPreviewPlugin_15", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                }
            } else {
                DynamicObject template = bill.getDynamicObject("template");
                DynamicObject templateversion = bill.getDynamicObject("templateversion");
                if (template == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5408\u540c\u6a21\u677f\u4e3a\u7a7a", (String)"ContractPreviewPlugin_19", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                }
                if (templateversion == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u7248\u672c\u4e3a\u7a7a", (String)"ContractPreviewPlugin_20", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                }
            }
            return bill;
        }
        String entityId = (String)param.getCustomParam("entityId");
        Object billId = param.getCustomParam("billId");
        if (entityId == null || StringUtils.isEmpty((String)entityId) || Objects.equals(billId, 0L)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u53c2\u6570\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ContractPreviewPlugin_10", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
        }
        if (this.parentEntityType == null) {
            this.parentEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
        }
        return BusinessDataServiceHelper.loadSingle((Object)billId, (String)entityId);
    }

    public String getFileName(DynamicObject parDym) {
        StringBuilder sb = new StringBuilder();
        String entity = parDym.getDynamicObjectType().getName();
        String billno = parDym.getString("billno");
        if ("conm_xpurcontract".equals(entity) || "conm_xsalcontract".equals(entity)) {
            billno = parDym.getString("changebillno");
        }
        sb.append(billno);
        return sb.toString();
    }

    private void replaceMark(List<String> bookmarks) {
        if (null == bookmarks || bookmarks.isEmpty()) {
            return;
        }
        DynamicObject parentEntity = this.getParentDataEntity();
        Map<String, Map<String, String>> varMapping = this.getVarMapping(parentEntity);
        PluginProxy pluginProxy = PluginProxy.create(null, IWebOfficePlugin.class, (String)"SCMC_CONM_CONTRACT_WEBOFFICE", null);
        DynamicObject bill = (DynamicObject)new CloneUtils(false, false).clone(parentEntity.getDataEntityType(), (Object)parentEntity);
        ArrayList<WebOfficeMark> marks = new ArrayList<WebOfficeMark>(16);
        for (String mark : bookmarks) {
            Object data;
            String billFieldKey;
            if (StringUtils.isEmpty((String)mark) || !mark.startsWith("variable") || StringUtils.isEmpty((String)(billFieldKey = mark.substring(mark.indexOf(95) + 1)))) continue;
            List values = pluginProxy.callReplace(p -> p.replaceMark(bill, mark));
            if (values != null && values.size() > 0 && (data = values.get(values.size() - 1)) != null) {
                if (data instanceof String[][]) {
                    WebOffice webOffice = (WebOffice)this.getControl(WEBOFFICEAP);
                    webOffice.addTable(mark, (String[][])data);
                    continue;
                }
                if (data instanceof String) {
                    marks.add(new WebOfficeMark(mark, data.toString()));
                    continue;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"WebOffice\u6269\u5c55\u63d2\u4ef6replaceMark\u65b9\u6cd5\u7684\u8fd4\u56de\u503c\u7c7b\u578b\u5fc5\u987b\u4e3aString[][]\u6216\u8005String\u3002", (String)"ContractPreviewPlugin_18", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                return;
            }
            Map<String, String> varInfo = varMapping.get(mark);
            if (varInfo != null) {
                String[][] value4Entry;
                String fieldKey;
                Object value4Head;
                if ("A".equals(varInfo.get("vartype")) && (value4Head = DynamicObjectHelper.getValue4Head((DynamicObject)bill, (String)(fieldKey = varInfo.get("srcfield")), (Boolean)Boolean.TRUE)) != null) {
                    String head = (String)value4Head;
                    if (StringUtils.isEmpty((String)head)) {
                        head = "    ";
                    }
                    marks.add(new WebOfficeMark(mark, head));
                }
                if (!"B".equals(varInfo.get("vartype"))) continue;
                String entryVar = varInfo.get("varnum");
                String entryKey = entryVar.substring(entryVar.indexOf(95) + 1);
                String srcField = varInfo.get("srcfield");
                String settings = varInfo.get("settings");
                List entryFields = (List)JSON.parseObject((String)srcField, List.class);
                if (StringUtils.isNotEmpty((String)settings)) {
                    int i;
                    List entryFieldInfos = (List)JSON.parseObject((String)settings, List.class);
                    if (entryFields == null || entryFields.size() <= 0) continue;
                    List value4Entry2 = DynamicObjectHelper.getValue4Entry((DynamicObject)bill, (String)entryKey, (List)entryFields, (Boolean)Boolean.TRUE);
                    String[][] data2 = new String[value4Entry2 == null ? 1 : value4Entry2.size() + 1][entryFields.size()];
                    for (i = 0; i < entryFieldInfos.size(); ++i) {
                        data2[0][i] = (String)((Map)entryFieldInfos.get(i)).get("text");
                    }
                    if (value4Entry2 == null) continue;
                    for (i = 0; i < value4Entry2.size(); ++i) {
                        data2[i + 1] = (String[])value4Entry2.get(i);
                    }
                    WebOffice webOffice = (WebOffice)this.getControl(WEBOFFICEAP);
                    webOffice.addTable(mark, data2);
                    continue;
                }
                if (entryFields == null || entryFields.size() <= 0 || (value4Entry = this.getEntryTable(parentEntity, entryKey, entryFields)) == null || value4Entry.length <= 0) continue;
                WebOffice webOffice = (WebOffice)this.getControl(WEBOFFICEAP);
                webOffice.addTable(mark, value4Entry);
                continue;
            }
            if (Objects.equals("billentry", billFieldKey)) {
                String[][] value4Entry = this.getEntryTable(parentEntity, "billentry", this.getMatEntryVar());
                if (value4Entry == null || value4Entry.length <= 0) continue;
                WebOffice webOffice = (WebOffice)this.getControl(WEBOFFICEAP);
                webOffice.addTable(mark, value4Entry);
                continue;
            }
            Object value4Head = DynamicObjectHelper.getValue4Head((DynamicObject)parentEntity, (String)billFieldKey, (Boolean)Boolean.TRUE);
            String head = (String)value4Head;
            if (StringUtils.isEmpty((String)head)) {
                head = "    ";
            }
            marks.add(new WebOfficeMark(mark, head));
        }
        if (!marks.isEmpty()) {
            WebOffice webOffice = (WebOffice)this.getControl(WEBOFFICEAP);
            webOffice.modifyMarks(marks);
        }
    }

    private String[][] getEntryTable(DynamicObject bill, String entryKey, List<String> entryFields) {
        if (bill == null || StringUtils.isEmpty((String)entryKey) || entryFields == null || entryFields.size() == 0) {
            return null;
        }
        List value4Entry = DynamicObjectHelper.getValue4Entry((DynamicObject)bill, (String)entryKey, entryFields, (Boolean)Boolean.TRUE);
        String[] entryTableHead = MetaDataHelper.getEntryTableHead((BillEntityType)((BillEntityType)bill.getDynamicObjectType()), entryFields);
        if (entryTableHead != null) {
            String[][] data = new String[value4Entry == null ? 1 : value4Entry.size() + 1][entryFields.size()];
            data[0] = entryTableHead;
            if (value4Entry != null) {
                for (int i = 0; i < value4Entry.size(); ++i) {
                    data[i + 1] = (String[])value4Entry.get(i);
                }
            }
            return data;
        }
        return null;
    }

    private Map<String, Map<String, String>> getVarMapping(DynamicObject parentEntity) {
        DynamicObject template = null;
        DynamicObject version = null;
        String entity = parentEntity.getDataEntityType().getName();
        if ("conm_xpurcontract".equals(entity) || "conm_xsalcontract".equals(entity)) {
            template = BusinessDataServiceHelper.loadSingle((Object)parentEntity.getDynamicObject("xtemplate").getPkValue(), (String)"conm_template");
            version = parentEntity.getDynamicObject("xtemplateversion");
        } else {
            template = BusinessDataServiceHelper.loadSingle((Object)parentEntity.getDynamicObject("template").getPkValue(), (String)"conm_template");
            version = parentEntity.getDynamicObject("templateversion");
        }
        DynamicObjectCollection attachmentEntry = template.getDynamicObjectCollection("attachmententry");
        HashMap<String, Map<String, String>> varMapping = new HashMap<String, Map<String, String>>();
        for (DynamicObject entry : attachmentEntry) {
            Object pkValue = entry.getPkValue();
            if (!pkValue.equals(version.getPkValue())) continue;
            DynamicObjectCollection subentryentity = entry.getDynamicObjectCollection("subentryentity");
            for (DynamicObject sub : subentryentity) {
                HashMap<String, String> var = new HashMap<String, String>();
                var.put("srcfield", sub.getString("srcfield"));
                var.put("vartype", sub.getString("vartype"));
                var.put("varnum", sub.getString("varnum"));
                var.put("settings", sub.getString("settings_tag"));
                varMapping.put(sub.getString("varnum"), var);
            }
        }
        return varMapping;
    }

    public List<String> getMatEntryVar() {
        ArrayList<String> vars = new ArrayList<String>();
        vars.add("seq");
        vars.add("material.masterid.number");
        vars.add("materialname");
        vars.add("qty");
        vars.add("unit");
        vars.add("priceandtax");
        vars.add("amountandtax");
        return vars;
    }

    public void onGetAllBookmarks(WebOfficeBookmarkEvent e) {
        if (Objects.equals("replaceMark", e.getId())) {
            this.replaceMark(e.getBookmarks());
        }
    }

    public void onGetBookmarkCheckResult(WebOfficeBookmarkCheckEvent arg0) {
    }

    public void onGetDocChangeCheckResult(WebOfficeDocChangeEvent arg0) {
    }

    public void onGetTextByBookmark(WebOfficeBookmarkValueEvent arg0) {
    }

    public void onGetAllCheckBoxes(WebOfficeCheckboxEvent arg0) {
    }

    public void onIsFieldRevise(WebOfficeIsFieldReviseEvent arg0) {
    }

    public void onSendOpenStatus(WebOfficeOpenStatusEvent arg0) {
    }

    static {
        entitySet.add("conm_purcontract");
        entitySet.add("conm_xpurcontract");
        entitySet.add("conm_pursupagrt");
        entitySet.add("conm_purendagrt");
    }
}

