/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.formplugin.basedata;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.impl.AttachmentFileService;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.scmc.conm.business.helper.TemplateHelper;

public class DataUpdateTestPlugin
extends AbstractFormPlugin {
    private static Log log = LogFactory.getLog(DataUpdateTestPlugin.class);
    private static final String[] formIds = new String[]{"conm_purcontract", "conm_pursupagrt", "conm_purendagrt", "conm_salcontract", "conm_salsupagrt", "conm_salendagrt"};

    private String isToContinue() {
        return ResManager.loadKDString((String)"\u5347\u7ea7\u64cd\u4f5c\u4e0d\u53ef\u9006,\u662f\u5426\u7ee7\u7eed?", (String)"DataUpdateTestPlugin_0", (String)"scmc-conm-formplugin", (Object[])new Object[0]);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn1", "btn2", "btn3", "btn4", "btn5", "btn6", "btn7", "btn8", "btn9", "btn10"});
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        super.click((EventObject)evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if (Objects.equals("btn1", key) || Objects.equals("btn2", key) || Objects.equals("btn3", key) || Objects.equals("btn4", key) || Objects.equals("btn5", key) || Objects.equals("btn6", key) || Objects.equals("btn7", key) || Objects.equals("btn8", key) || Objects.equals("btn9", key) || Objects.equals("btn10", key)) {
            this.getView().showConfirm(this.isToContinue(), MessageBoxOptions.YesNo, new ConfirmCallBackListener(key));
            evt.setCancel(true);
        }
    }

    public void click(EventObject evt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getResult() != MessageBoxResult.Yes) {
            return;
        }
        switch (e.getCallBackId()) {
            case "btn1": {
                this.updateSalContractParty1st(false);
                break;
            }
            case "btn2": {
                this.updateSalContractParty1st(true);
                break;
            }
            case "btn3": {
                this.updatePurContractParty2nd(false);
                break;
            }
            case "btn4": {
                this.updatePurContractParty2nd(true);
                break;
            }
            case "btn5": {
                OperationResult res = this.getView().invokeOperation("purcontract_purorder");
                this.getModel().setValue("updateres", (Object)String.format(ResManager.loadKDString((String)"\u5347\u7ea7%1$s, \u4fe1\u606f : %2$s\u3002", (String)"DataUpdateTestPlugin_1", (String)"scmc-conm-formplugin", (Object[])new Object[0]), res.isSuccess(), res.getMessage()));
                break;
            }
            case "btn6": {
                OperationResult res = this.getView().invokeOperation("salcontract_salorder");
                this.getModel().setValue("updateres", (Object)String.format(ResManager.loadKDString((String)"\u5347\u7ea7%1$s, \u4fe1\u606f : %2$s\u3002", (String)"DataUpdateTestPlugin_1", (String)"scmc-conm-formplugin", (Object[])new Object[0]), res.isSuccess(), res.getMessage()));
                break;
            }
            case "btn7": {
                OperationResult res = this.getView().invokeOperation("template_attachment");
                StringBuilder sb = new StringBuilder();
                if (res.isSuccess()) {
                    sb.append(ResManager.loadKDString((String)"\u5408\u540c\u6a21\u7248\u5df2\u6210\u529f\u5347\u7ea7\u3002", (String)"DataUpdateTestPlugin_2", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                    break;
                }
                sb.append(ResManager.loadKDString((String)"\u5408\u540c\u6a21\u7248\u5347\u7ea7\u5931\u8d25\u3002", (String)"DataUpdateTestPlugin_3", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("updateres", (Object)sb.toString());
                break;
            }
            case "btn8": {
                StringBuilder sb2 = new StringBuilder();
                int i = 1;
                try (TXHandle tx = TX.required((String)"scmc-conm-dataupdate");){
                    for (String formId : formIds) {
                        Object[] objects = this.updateContractTemplate(formId);
                        if (objects != null && objects.length > 0) {
                            sb2.append(String.format(ResManager.loadKDString((String)"%1$d.%2$s\u5347\u7ea7\u6210\u529f\u3002", (String)"DataUpdateTestPlugin_4", (String)"scmc-conm-formplugin", (Object[])new Object[0]), i++, formId));
                            this.getModel().setValue("updateres", (Object)sb2.toString());
                            continue;
                        }
                        sb2.append(String.format(ResManager.loadKDString((String)"%1$d.%2$s\u6ca1\u6709\u53ef\u5347\u7ea7\u7684\u6570\u636e\u3002", (String)"DataUpdateTestPlugin_5", (String)"scmc-conm-formplugin", (Object[])new Object[0]), i++, formId));
                    }
                }
                sb2.append(ResManager.loadKDString((String)"\u5df2\u5f00\u542f\u5408\u540c\u9644\u4ef6\u5f02\u6b65\u5347\u7ea7\uff0c\u8bf7\u5728\u540e\u53f0\u67e5\u770b\u5347\u7ea7\u65e5\u5fd7\u3002", (String)"DataUpdateTestPlugin_11", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                sb2.append("\n");
                this.getModel().setValue("updateres", (Object)sb2.toString());
                final RequestContext context = RequestContext.get();
                ThreadPools.executeOnce((String)"scmc-conm-dataupdate", (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        RequestContext.copyAndSet((RequestContext)context);
                        for (String formId : formIds) {
                            DataUpdateTestPlugin.this.moveFile(formId);
                        }
                    }
                });
                break;
            }
            case "btn9": {
                DispatchServiceHelper.invokeBizService((String)"scmc", (String)"conm", (String)"RowNumUpGrade", (String)"beforeExecuteSqlWithResult", (Object[])new Object[]{null, null, null, null});
                this.getModel().setValue("updateres", (Object)ResManager.loadKDString((String)"\u5347\u7ea7\u7ed3\u675f\u3002", (String)"DataUpdateTestPlugin_12", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "btn10": {
                DispatchServiceHelper.invokeBizService((String)"scmc", (String)"conm", (String)"PurContractAllOrderAmountUpGrade", (String)"beforeExecuteSqlWithResult", (Object[])new Object[]{null, null, null, null});
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u7ed3\u675f\u3002", (String)"DataUpdateTestPlugin_12", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void moveFile(String formId) {
        DynamicObject[] bills;
        AttachmentFileService afs = new AttachmentFileService();
        for (DynamicObject bill : bills = BusinessDataServiceHelper.load((String)formId, (String)"id ,billno,template,templateversion", (QFilter[])QFilter.isNotNull((String)"template").toArray())) {
            String oldPath;
            String billno = bill.getString("billno");
            if (bill.getDynamicObject("template") == null && StringUtils.isNotEmpty((String)billno) || !afs.exists(oldPath = this.getOldPath(bill))) continue;
            InputStream inputStream = afs.getInputStream(oldPath);
            String fileName = this.getFileName(bill);
            String newPath = this.getNewPath(bill);
            FileItem fileItem = new FileItem(fileName, newPath, inputStream);
            fileItem.setCreateNewFileWhenExists(false);
            afs.upload(fileItem);
            try {
                inputStream.close();
            }
            catch (IOException e) {
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private String getOldPath(DynamicObject bill) {
        DynamicObject template = bill.getDynamicObject("template");
        return '/' + bill.getDataEntityType().getName() + '/' + template.getPkValue() + '/' + this.getFileName(bill);
    }

    private String getNewPath(DynamicObject bill) {
        DynamicObject template = bill.getDynamicObject("template");
        DynamicObject version = bill.getDynamicObject("templateversion");
        return '/' + bill.getDataEntityType().getName() + '/' + template.getPkValue() + '/' + version.getPkValue() + '/' + this.getFileName(bill);
    }

    private String getFileName(DynamicObject bill) {
        StringBuilder sb = new StringBuilder();
        String billno = bill.getString("billno");
        sb.append(billno).append(TemplateHelper.getDocFileSuffix());
        return sb.toString();
    }

    private Object[] updateContractTemplate(String entity) {
        try {
            DynamicObject[] conm_purcontracts = BusinessDataServiceHelper.load((String)entity, (String)"id ,billno,template.number,template.url,template.attachmententry.id,templateversion", (QFilter[])QFilter.isNotNull((String)"template.url").and(new QFilter("templateversion", "=", (Object)0)).toArray());
            if (conm_purcontracts == null || conm_purcontracts.length <= 0) {
                return new Object[0];
            }
            for (DynamicObject purcontract : conm_purcontracts) {
                DynamicObjectCollection attachmententry;
                DynamicObject template = purcontract.getDynamicObject("template");
                if (template == null || (attachmententry = template.getDynamicObjectCollection("attachmententry")) == null || attachmententry.size() < 1) continue;
                List modifydate = attachmententry.stream().map(a -> a.getDate("modifydate")).collect(Collectors.toList());
                Date maxDate = (Date)Collections.max(modifydate);
                List attachment = attachmententry.stream().filter(a -> a.getDate("modifydate").equals(maxDate)).collect(Collectors.toList());
                purcontract.set("templateversion", attachment.get(0));
            }
            return SaveServiceHelper.save((DynamicObject[])conm_purcontracts);
        }
        catch (Exception e) {
            throw new KDBizException(entity + "\uff1aerrorInfo:" + e.getMessage());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (!Objects.equals("purcontract_purorder", e.getOperateKey()) || e.getOperationResult().isSuccess()) {
            // empty if block
        }
        if (!Objects.equals("salcontract_salorder", e.getOperateKey()) || e.getOperationResult().isSuccess()) {
            // empty if block
        }
    }

    private void updatePurContractParty2nd(boolean isXBill) {
        QFilter qfilter1 = new QFilter("party2nd", "=", (Object)" ");
        qfilter1.or("party2nd", "is null", (Object)"");
        QFilter qfilter2 = new QFilter("supplier", "!=", (Object)0);
        String entityName = isXBill ? "conm_xpurcontract" : "conm_purcontract";
        DynamicObject[] purContracts = BusinessDataServiceHelper.load((String)entityName, (String)"id, org, billno, supplier, party2nd", (QFilter[])new QFilter[]{qfilter1, qfilter2});
        if (purContracts == null || purContracts.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7532\u65b9\u7684\u5355\u636e\u8bb0\u5f55\u3002", (String)"DataUpdateTestPlugin_7", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("updateres", (Object)ResManager.loadKDString((String)"\u672a\u627e\u5230\u7532\u65b9\u7684\u5355\u636e\u8bb0\u5f55\u3002", (String)"DataUpdateTestPlugin_7", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
            return;
        }
        for (DynamicObject bill : purContracts) {
            bill.set("party2nd", (Object)bill.getDynamicObject("supplier").getLocaleString("name").getLocaleValue());
        }
        SaveServiceHelper.update((DynamicObject[])purContracts);
        String resStr = this.parsPurRes(purContracts);
        this.getModel().setValue("updateres", (Object)resStr);
    }

    private String parsPurRes(DynamicObject[] purContracts) {
        if (purContracts == null || purContracts.length == 0) {
            return ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u5347\u7ea7\u7684\u6570\u636e\u3002", (String)"DataUpdateTestPlugin_8", (String)"scmc-conm-formplugin", (Object[])new Object[0]);
        }
        StringBuilder logStr = new StringBuilder();
        logStr.append(purContracts[0].getDataEntityType().getName());
        logStr.append("\r\n");
        for (int i = 0; i < purContracts.length; ++i) {
            DynamicObject bill = purContracts[i];
            logStr.append(String.format(ResManager.loadKDString((String)"%1$s\u3001\u5355\u636e\u201c%2$s,%3$s,%4$s\u201d\u5347\u7ea7\u66f4\u65b0\u6210\u529f\uff0c\u53d6\u5230\u7684\u4f9b\u5e94\u5546\u201c%5$s\u201d\u3002", (String)"DataUpdateTestPlugin_9", (String)"scmc-conm-formplugin", (Object[])new Object[0]), i + 1, bill.getPkValue(), bill.get("billno"), bill.get("org.name"), bill.get("supplier.name")));
            logStr.append("/\r/\n");
        }
        return logStr.toString();
    }

    private void updateSalContractParty1st(boolean isXBill) {
        QFilter qfilter1 = new QFilter("party1st", "=", (Object)" ");
        qfilter1.or("party1st", "is null", (Object)"");
        QFilter qfilter2 = new QFilter("customer", "!=", (Object)0);
        String entityName = isXBill ? "conm_xsalcontract" : "conm_salcontract";
        Object[] salContracts = BusinessDataServiceHelper.load((String)entityName, (String)"id, org, billno, customer, party1st", (QFilter[])new QFilter[]{qfilter1, qfilter2});
        if (salContracts == null || salContracts.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7532\u65b9\u7684\u5355\u636e\u8bb0\u5f55\u3002", (String)"DataUpdateTestPlugin_7", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("updateres", (Object)ResManager.loadKDString((String)"\u672a\u627e\u5230\u7532\u65b9\u7684\u5355\u636e\u8bb0\u5f55\u3002", (String)"DataUpdateTestPlugin_7", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
            return;
        }
        for (DynamicObject dynamicObject : salContracts) {
            dynamicObject.set("party1st", (Object)dynamicObject.getDynamicObject("customer").getLocaleString("name").getLocaleValue());
        }
        SaveServiceHelper.update((DynamicObject[])salContracts);
        String resStr = this.parsSalRes(salContracts);
        this.getModel().setValue("updateres", (Object)resStr);
    }

    private String parsSalRes(Object[] res) {
        if (res == null || res.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u5347\u7ea7\u7684\u6570\u636e\u3002", (String)"DataUpdateTestPlugin_8", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
        }
        StringBuilder logStr = new StringBuilder();
        for (int i = 0; i < res.length; ++i) {
            DynamicObject bill = (DynamicObject)res[i];
            logStr.append(String.format(ResManager.loadKDString((String)"%1$s\u3001\u5355\u636e \u201c%2$s,%3$s,%4$s\u201d\u5347\u7ea7\u66f4\u65b0\u6210\u529f\uff0c \u53d6\u5230\u7684\u5ba2\u6237\u201c%5$s\u201d\u3002", (String)"DataUpdateTestPlugin_10", (String)"scmc-conm-formplugin", (Object[])new Object[0]), i + 1, bill.getPkValue(), bill.get("billno"), bill.get("org.name"), bill.get("customer.name")));
            logStr.append("/\r/\n");
        }
        return logStr.toString();
    }
}

