/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.formplugin.blockchain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.conm.utils.CommonUtils;

public class ConmParamSetupPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(ConmParamSetupPlugin.class);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean fpurorderctrl = (Boolean)this.getModel().getValue("fpurorderctrl");
        if (fpurorderctrl) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"fpurorderctrl"});
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        FieldEdit source = (FieldEdit)e.getSource();
        String fieldKey = source.getFieldKey();
        Object value = e.getValue();
        if ("fpurorderctrl".equals(fieldKey) && ((Boolean)value).booleanValue()) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("enablePurOrderCtrl", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5f00\u5173\u5f00\u542f\u540e\uff0c\u76f8\u5e94\u5355\u636e\u5c06\u6839\u636e\u201c\u5408\u540c\u7c7b\u578b\u201d\u4e2d\u6240\u9009\u7684\u5408\u540c\u63a7\u5236\u65b9\u5f0f\u8fdb\u884c\u5c65\u884c\u63a7\u5236\uff0c\u4e14\u4e0d\u53ef\u5173\u95ed\u3002\u5982\u679c\u5f00\u5173\u5f00\u542f\u524d\u5df2\u53d1\u751f\u8fc7\u5408\u540c\u4e1a\u52a1\uff0c\u5219\u9700\u4f7f\u7528\u9884\u7f6e\u7684\u6570\u636e\u5de1\u68c0\u4efb\u52a1\u8fdb\u884c\u5386\u53f2\u6570\u636e\u5347\u7ea7\u3002", (String)"ConmParamSetupPlugin_3", (String)"scmc-conm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
        } else if ("fpurorderctrl".equals(fieldKey) && !((Boolean)value).booleanValue()) {
            e.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("closePurOrderCtrl", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u53c2\u6570\u5df2\u7ecf\u5f00\u542f\uff0c\u7981\u6b62\u5173\u95ed\u3002", (String)"ConmParamSetupPlugin_2", (String)"scmc-conm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK, confirmCallBacks);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (evt.getCallBackId().equals("enablePurOrderCtrl")) {
            if (evt.getResult() == MessageBoxResult.No) {
                this.getModel().beginInit();
                this.getModel().setValue("fpurorderctrl", (Object)Boolean.FALSE);
                this.getView().updateView("fpurorderctrl");
                this.getModel().endInit();
            } else {
                this.getModel().setValue("fenabletime", (Object)new Date());
            }
        } else if (evt.getCallBackId().equals("closePurOrderCtrl") && evt.getResult() == MessageBoxResult.Cancel) {
            this.getModel().beginInit();
            this.getModel().setValue("fpurorderctrl", (Object)Boolean.TRUE);
            this.getView().updateView("fpurorderctrl");
            this.getModel().endInit();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!CommonUtils.isRealChanged((ChangeData)e.getChangeSet()[0])) {
            return;
        }
        String propName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propName) {
            case "fupchainctrl": {
                if (newValue != Boolean.TRUE) break;
                this.ConmUpChainInit();
                break;
            }
        }
    }

    public void ConmUpChainInit() {
        try {
            DispatchServiceHelper.invokeBizService((String)"scmc", (String)"conm", (String)"BlockChainConmPreinsdata", (String)"BlockChainDataPreins", (Object[])new Object[0]);
            Map serviceCenterMap = (Map)DispatchServiceHelper.invokeBizService((String)"bsc", (String)"bcc", (String)"ServiceCenterService", (String)"getServiceCenter", (Object[])new Object[0]);
            this.setValue4BeaMapping(serviceCenterMap);
            this.startUpChainTask();
            String successInfo = ResManager.loadKDString((String)"\u5f00\u542f\u4e0a\u94fe\u6210\u529f\u3002", (String)"ConmParamSetupPlugin_0", (String)"scmc-conm-formplugin", (Object[])new Object[0]);
            this.getView().showSuccessNotification(successInfo);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            this.getModel().setValue("fupchainctrl", (Object)Boolean.FALSE);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u533a\u5757\u94fe\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u5382\u5546\u5904\u7406\u6216\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ConmParamSetupPlugin_1", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
        }
    }

    private void startUpChainTask() {
        List<Long> taskIds = Arrays.asList(1240404931706359808L, 1240405865526203392L, 1240405734563254272L, 1240406950500373504L, 1240405142377862144L, 1240404576658527232L, 1240405462956904448L, 1240409569155354624L, 1240406040185410560L, 1242119345799172096L, 1240407111830081536L);
        QFilter qfilter = new QFilter("id", "in", taskIds);
        QFilter statusQfilter = new QFilter("billstatus", "!=", (Object)"C");
        DynamicObject[] taskColl = BusinessDataServiceHelper.load((String)"bea_task", (String)"id", (QFilter[])new QFilter[]{qfilter, statusQfilter});
        taskIds = new ArrayList<Long>(16);
        for (DynamicObject task : taskColl) {
            taskIds.add((Long)task.getPkValue());
        }
        List operatResult = (List)DispatchServiceHelper.invokeBizService((String)"bsc", (String)"bea", (String)"StcTaskService", (String)"startTasks", (Object[])new Object[]{taskIds});
        for (Map map : operatResult) {
            if (map == null || map.get("taskPkId") == null && !StringUtils.isNotBlank(map.get("errorMessage"))) continue;
            log.error("failed taskPkId:" + map.get("taskPkId"));
            log.error("failed errorMessage:" + map.get("errorMessage"));
            throw new KDBizException("start upChainTask failed!");
        }
    }

    private void setValue4BeaMapping(Map<String, Object> serviceCenterMap) {
        ArrayList<Long> ids = new ArrayList<Long>(8);
        ids.add(1239803265994986496L);
        ids.add(1239811051621453824L);
        ids.add(1239806816414601216L);
        ids.add(1239815156385453056L);
        ids.add(1239865276254655488L);
        ids.add(1239876835412545536L);
        ids.add(1240409424007270400L);
        QFilter qfilter = new QFilter("id", "in", ids);
        DynamicObject[] dynamicObjectColl = BusinessDataServiceHelper.load((String)"bea_mapping", (String)ConmParamSetupPlugin.getSelectField(), (QFilter[])new QFilter[]{qfilter});
        Long serviecCenterId = (Long)serviceCenterMap.get("pkId");
        for (DynamicObject entity : dynamicObjectColl) {
            entity.set("service_center", (Object)serviecCenterId);
            this.setDataEntityType(String.valueOf(entity.getLong("id")), entity, serviecCenterId);
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjectColl);
    }

    private void setDataEntityType(String pkId, DynamicObject entity, Long ServiceCenterId) {
        switch (pkId) {
            case "1239803265994986496": {
                this.setbeaEntity(entity, ServiceCenterId, "conm_purcontract_STD");
                break;
            }
            case "1239811051621453824": {
                this.setbeaEntity(entity, ServiceCenterId, "conm_pursupagrt_STD");
                break;
            }
            case "1239806816414601216": {
                this.setbeaEntity(entity, ServiceCenterId, "conm_purendagrt_STD");
                break;
            }
            case "1239815156385453056": {
                this.setbeaEntity(entity, ServiceCenterId, "pm_purorderbill_STD");
                break;
            }
            case "1239865276254655488": {
                this.setbeaEntity(entity, ServiceCenterId, "ap_finapbill_STD");
                break;
            }
            case "1239876835412545536": {
                this.setbeaEntity(entity, ServiceCenterId, "cas_paybill_STD");
                break;
            }
            case "1240409424007270400": {
                this.setbeaEntity(entity, ServiceCenterId, "cas_paybill_STD");
            }
        }
    }

    private void setbeaEntity(DynamicObject entity, Long serviceCenterId, String entityName) {
        Map beaEntity = (Map)DispatchServiceHelper.invokeBizService((String)"bsc", (String)"bea", (String)"ChainDataTypeService", (String)"saveSchemaByName", (Object[])new Object[]{serviceCenterId, entityName});
        entity.set("datatype", beaEntity.get("pkId"));
    }

    private static String getSelectField() {
        ArrayList<String> selectorSet = new ArrayList<String>(16);
        selectorSet.add("id");
        selectorSet.add("number");
        selectorSet.add("name");
        selectorSet.add("datatype");
        selectorSet.add("service_center");
        return String.join((CharSequence)",", selectorSet);
    }
}

