/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.formplugin.botp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildDrawFilterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.property.OrgProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.conm.business.helper.AppParameterHelper;
import kd.scmc.conm.business.helper.BillTypeParameterHelper;
import kd.scmc.conm.business.helper.OperatorGroupHelper;
import kd.scmc.conm.enums.BizReviewStatusEnum;
import kd.scmc.conm.enums.BizSignStatusEnum;
import kd.scmc.conm.enums.FilingStatusEnum;

public class Bill2AgreementConvertPlugin
extends AbstractConvertPlugIn {
    public void afterBuildDrawFilter(AfterBuildDrawFilterEventArgs e) {
        super.afterBuildDrawFilter(e);
        Optional.ofNullable(e.getTargetDataEntity().getDynamicObject("org")).ifPresent(org -> {
            long orgId = (Long)org.getPkValue();
            String srcEntityName = this.getSrcMainType().getName();
            Object operatorGroupIsolate = AppParameterHelper.getAppParameterByFormId((String)srcEntityName, (Long)orgId, (String)"foperatorgroupisolate");
            if (Boolean.TRUE.equals(operatorGroupIsolate)) {
                ArrayList arList;
                ArrayList opGrpList;
                ArrayList validList;
                long userId = UserServiceHelper.getCurrentUserId();
                String grpType = "";
                if ("conm_purcontract".equals(srcEntityName)) {
                    grpType = "CGZ";
                } else if ("conm_salcontract".equals(srcEntityName)) {
                    grpType = "XSZ";
                }
                if (StringUtils.isNotEmpty((String)grpType) && !(validList = OperatorGroupHelper.getValidOperatorGroup((ArrayList)(opGrpList = OperatorGroupHelper.getOperatorGroupByOrg((long)orgId, (String)grpType)), (ArrayList)(arList = OperatorGroupHelper.getOperatorGroupByUser((long)orgId, (long)userId, (String)grpType)))).isEmpty()) {
                    QFilter q = new QFilter("operatorgroup", "in", (Object)validList);
                    e.setPlugFilter(q);
                }
            }
        });
    }

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        BillEntityType tgtMainType = this.getTgtMainType();
        String orgFunc = ((OrgProp)tgtMainType.getProperty("org")).getOrgFunc();
        ExtendedDataEntitySet tgt = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = tgt.FindByEntityKey(tgtMainType.toString());
        this.dealCategory(entitys);
    }

    private void dealCategory(ExtendedDataEntity[] entitys) {
        if (entitys == null || entitys.length == 0) {
            return;
        }
        HashSet<Object> categoryIds = new HashSet<Object>(16);
        HashMap<Object, Long> categoryMap = new HashMap<Object, Long>(16);
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject bill = entity.getDataEntity();
            DynamicObject billType = bill.getDynamicObject("billtype");
            if (billType == null) continue;
            DynamicObject category = bill.getDynamicObject("category");
            if (category != null) {
                categoryIds.add(category.getPkValue());
                continue;
            }
            Long categoryID = (Long)categoryMap.get(billType.getPkValue());
            if (categoryID == null) {
                DynamicObject dynamicObject = BillTypeParameterHelper.getBillTypeParameter((MainEntityType)this.getTgtMainType(), (long)((Long)billType.getPkValue()));
                if (dynamicObject == null || (category = dynamicObject.getDynamicObject("category")) == null) continue;
                categoryMap.put(billType.getPkValue(), (Long)category.getPkValue());
                bill.set("category_id", category.getPkValue());
                categoryIds.add(category.getPkValue());
                continue;
            }
            bill.set("category_id", (Object)categoryID);
        }
        QFilter contcategoryQF = new QFilter("contcategory", "in", (Object)categoryIds.toArray());
        QFilter isdefaultQF = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
        QFilter enableQF = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] contTypes = BusinessDataServiceHelper.load((String)"conm_type", (String)"contcategory,activereview,activesign,activearchive", (QFilter[])new QFilter[]{contcategoryQF, isdefaultQF, enableQF});
        HashMap<Object, DynamicObject> map = new HashMap<Object, DynamicObject>(16);
        for (DynamicObject dynamicObject : contTypes) {
            map.put(dynamicObject.getDynamicObject("contcategory").getPkValue(), dynamicObject);
        }
        for (DynamicObject dynamicObject : entitys) {
            Object pkValue;
            Object value;
            DynamicObject dataEntity = dynamicObject.getDataEntity();
            if (dataEntity.getDynamicObject("type") == null && (value = map.get(pkValue = dataEntity.get("category_id"))) != null) {
                dataEntity.set("type", value);
            }
            Bill2AgreementConvertPlugin.setConmType(dataEntity);
        }
    }

    private static void setConmType(DynamicObject bill) {
        DynamicObject type = bill.getDynamicObject("type");
        if (type != null) {
            bill.set("signstatus", (Object)(type.getBoolean("activesign") ? BizSignStatusEnum.UNSIGN.getValue() : BizSignStatusEnum.INACTIVE.getValue()));
            bill.set("reviewstatus", (Object)(type.getBoolean("activereview") ? BizReviewStatusEnum.UNREVIEW.getValue() : BizReviewStatusEnum.INACTIVE.getValue()));
            bill.set("filingstatus", (Object)(type.getBoolean("activearchive") ? FilingStatusEnum.UNFILED.getValue() : FilingStatusEnum.INACTIVE.getValue()));
        }
    }
}

