/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.formplugin.botp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.helper.AttachmentPanelConvertHelper;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.entity.botp.runtime.AttachmentPanelMap;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class Bill2PmmProtocolConvertPlugin
extends AbstractConvertPlugIn {
    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        e.addSrcField("suitscope");
        e.addSrcField("operator");
    }

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        List selectedRows = e.getSelectedRows();
        HashSet<Object> ids = new HashSet<Object>(selectedRows.size());
        for (ListSelectedRow selectedRow : selectedRows) {
            Object id = selectedRow.getPrimaryKeyValue();
            ids.add(id);
        }
        QFilter qFilter = new QFilter("srcid", "in", ids);
        DynamicObject[] protocols = BusinessDataServiceHelper.load((String)"pmm_protocol", (String)"srcid,srcbillbillno", (QFilter[])new QFilter[]{qFilter});
        HashSet<String> filter = new HashSet<String>();
        if (protocols != null && protocols.length > 0) {
            for (DynamicObject protocol : protocols) {
                String srcbillbillno = protocol.getString("srcbillbillno");
                filter.add(srcbillbillno);
            }
        }
        if (filter.size() > 0) {
            QFilter billNoFilter = new QFilter("billno", "not in", filter);
            e.setCustFilterDesc(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u91cd\u590d\u4e0b\u63a8\u3002", (String)"Bill2PmmProtocolConvertPlugin_0", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
            e.setCustFilterExpression(billNoFilter.toString());
            e.getCustQFilters().add(billNoFilter);
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(this.getTgtMainType().getName());
        HashSet<Long> supIds = new HashSet<Long>(1024);
        HashSet<String> orgIds = new HashSet<String>(1024);
        HashSet<Long> materialIds = new HashSet<Long>(1024);
        for (ExtendedDataEntity entity : entitys) {
            ExtendedDataEntity[] tarDyn = entity.getDataEntity();
            if (null != tarDyn.getDynamicObject("partyb")) {
                supIds.add(tarDyn.getDynamicObject("partyb").getLong("id"));
            }
            if (null != tarDyn.getDynamicObject("org")) {
                orgIds.add(tarDyn.getDynamicObject("org").getString("id"));
            }
            DynamicObjectCollection materialentry = tarDyn.getDynamicObjectCollection("entryentity1");
            for (DynamicObject row : materialentry) {
                if (null == row.getDynamicObject("material")) continue;
                materialIds.add(row.getDynamicObject("material").getLong("id"));
            }
        }
        Set<Long> suppliers = this.getSupplier(supIds);
        Map<String, String> sccParam = this.getSccParam(orgIds);
        Map<Long, Long> materialGroup = this.getMaterialGroup(materialIds);
        HashSet<Long> operatorIds = new HashSet<Long>(1024);
        for (ExtendedDataEntity entity : entitys) {
            List srcRows = (List)entity.getValue("ConvertSource");
            DynamicObject srcRow = (DynamicObject)srcRows.get(0);
            Long operator = (Long)((DynamicProperty)e.getFldProperties().get("operator")).getValue((Object)srcRow);
            operatorIds.add(operator);
        }
        HashMap<Long, Long> operator_user = new HashMap<Long, Long>(1024);
        QFilter qFilter = new QFilter("id", "in", operatorIds);
        DynamicObjectCollection bdOperators = QueryServiceHelper.query((String)"bd_operator", (String)"id,operatorid", (QFilter[])qFilter.toArray());
        for (DynamicObject info : bdOperators) {
            operator_user.put(info.getLong("id"), info.getLong("operatorid"));
        }
        for (ExtendedDataEntity entity : entitys) {
            Long operator;
            Long operatorId;
            List srcRows = (List)entity.getValue("ConvertSource");
            DynamicObject tarDyn = entity.getDataEntity();
            DynamicObject srcRow = (DynamicObject)srcRows.get(0);
            String suitscope = String.valueOf(((DynamicProperty)e.getFldProperties().get("suitscope")).getValue((Object)srcRow));
            if (null != ((DynamicProperty)e.getFldProperties().get("operator")).getValue((Object)srcRow) && (operatorId = (Long)operator_user.get(operator = (Long)((DynamicProperty)e.getFldProperties().get("operator")).getValue((Object)srcRow))) != null) {
                tarDyn.set("handlor_id", (Object)operatorId);
            }
            if ("B".equals(suitscope) || "A".equals(suitscope)) {
                tarDyn.set("purmode", (Object)"3");
            }
            if ("C".equals(suitscope)) {
                tarDyn.set("purmode", (Object)"1");
                tarDyn.set("isgoodvisible", (Object)Boolean.TRUE);
            }
            if (!"B".equals(suitscope)) {
                tarDyn.getDynamicObjectCollection("entryentity").clear();
            }
            Long supId = 0L;
            if (null != tarDyn.getDynamicObject("partyb")) {
                supId = tarDyn.getDynamicObject("partyb").getLong("id");
            }
            String orgId = "";
            if (null != tarDyn.getDynamicObject("org")) {
                orgId = tarDyn.getDynamicObject("org").getString("id");
            }
            if (suppliers.contains(supId) && Boolean.parseBoolean(sccParam.get(orgId))) {
                tarDyn.set("issrm", (Object)Boolean.TRUE);
            } else {
                tarDyn.set("issrm", (Object)Boolean.FALSE);
                tarDyn.set("issupgood", (Object)Boolean.FALSE);
            }
            tarDyn.set("bizpartner_id", (Object)Bill2PmmProtocolConvertPlugin.getBizPartnerBySupplier(supId));
            DynamicObjectCollection materialentry = tarDyn.getDynamicObjectCollection("entryentity1");
            for (DynamicObject row : materialentry) {
                if (null == row.getDynamicObject("material")) continue;
                row.set("materialgroup_id", (Object)materialGroup.get(row.getDynamicObject("material").getLong("id")));
            }
            this.loadAttachFile("attachmentpanel", "attachmentpanel", entity, srcRow);
            this.loadAttachFile("signattachment", "attachmentpanel", entity, srcRow);
        }
    }

    public static final Long getBizPartnerBySupplier(Object supplierId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)supplierId, (String)"bd_supplier", (String)"bizpartner");
        Long bizpartnerId = null;
        if (null != dynamicObject) {
            bizpartnerId = dynamicObject.getLong("bizpartner_id");
        }
        return bizpartnerId;
    }

    private void loadAttachFile(String srcAttach, String tarAttach, ExtendedDataEntity entity, DynamicObject srcRow) {
        HashMap<String, AttachmentPanelMap> attachmentPanelMapRules = new HashMap<String, AttachmentPanelMap>(1024);
        BillEntityType srcMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)"conm_purcontract");
        BillEntityType tartMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)"pmm_protocol");
        AttachmentPanelMap attachmentPanelMap = new AttachmentPanelMap(srcMainType, tartMainType);
        attachmentPanelMap.setSourceAttachmentPanelKey(srcAttach);
        attachmentPanelMap.setTargetAttachmentPanelKey(tarAttach);
        attachmentPanelMapRules.put("attachmentpanel", attachmentPanelMap);
        ArrayList<Long> sourcePks = new ArrayList<Long>(1024);
        sourcePks.add(srcRow.getLong("id"));
        entity.setValue("botp_attachment_mapping_source_row_ids", sourcePks);
        MainEntityType sourceMainType = EntityMetadataCache.getDataEntityType((String)"conm_purcontract");
        Map attachInfoMap = AttachmentPanelConvertHelper.loadAttachInfoMap((MainEntityType)sourceMainType, attachmentPanelMapRules, sourcePks, null);
        if (null != entity.getValue("botp_source_attachmentpanel_infos")) {
            Map attachInfo = (Map)entity.getValue("botp_source_attachmentpanel_infos");
            for (Map.Entry attachMap : attachInfoMap.entrySet()) {
                if (!attachInfo.containsKey(attachMap.getKey())) continue;
                List attachs = (List)attachInfo.get(attachMap.getKey());
                attachs.addAll((Collection)attachMap.getValue());
            }
            entity.setValue("botp_source_attachmentpanel_infos", (Object)attachInfo);
        } else {
            entity.setValue("botp_source_attachmentpanel_infos", (Object)attachInfoMap);
        }
    }

    private Map<Long, Long> getMaterialGroup(Set<Long> materialIds) {
        QFilter qFilter = new QFilter("id", "in", materialIds);
        String sectlors = "group,id";
        DynamicObjectCollection materials = QueryServiceHelper.query((String)"bd_material", (String)sectlors, (QFilter[])qFilter.toArray());
        HashMap<Long, Long> materialGroup = new HashMap<Long, Long>(1024);
        for (DynamicObject dyn : materials) {
            materialGroup.put(dyn.getLong("id"), dyn.getLong("group"));
        }
        return materialGroup;
    }

    private Map<String, String> getSccParam(Set<String> orgIds) {
        Object data = DispatchServiceHelper.invokeBizService((String)"scm", (String)"scc", (String)"ISCCBillService", (String)"getSCCSrm", (Object[])new Object[]{orgIds});
        Map<String, String> paramObjByOrg = new HashMap<String, String>(1024);
        if (null != data) {
            paramObjByOrg = (Map)data;
        }
        return paramObjByOrg;
    }

    private Set<Long> getSupplier(Set<Long> supIds) {
        QFilter qFilter = new QFilter("id", "in", supIds);
        String sectlors = "issuppcolla,id";
        DynamicObjectCollection suppliers = QueryServiceHelper.query((String)"bd_supplier", (String)sectlors, (QFilter[])qFilter.toArray());
        HashSet<Long> isSrmSupSet = new HashSet<Long>(1024);
        for (DynamicObject dyn : suppliers) {
            if (!dyn.getBoolean("issuppcolla")) continue;
            isSrmSupSet.add(dyn.getLong("id"));
        }
        return isSrmSupSet;
    }
}

