/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.formplugin.botp;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildDrawFilterEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.conm.business.helper.AppParameterHelper;
import kd.scmc.conm.business.helper.ContractValidHelper;
import kd.scmc.conm.business.helper.OperatorGroupHelper;
import kd.scmc.conm.enums.BizValidStatusEnum;
import kd.scmc.conm.enums.ContractPropEnum;
import kd.scmc.conm.enums.ContractSuitScopeEnum;
import kd.scmc.conm.utils.CommonUtils;

public class ContractConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log log = LogFactory.getLog(ContractConvertPlugin.class);

    public void afterBuildDrawFilter(AfterBuildDrawFilterEventArgs e) {
        DynamicObject customer;
        DynamicObject supplier;
        super.afterBuildDrawFilter(e);
        DynamicObject contract = e.getTargetDataEntity();
        DynamicObject org = contract.getDynamicObject("org");
        DynamicObject type = (DynamicObject)contract.get("type");
        String conmProp = (String)contract.get("conmprop");
        String bizMode = (String)contract.get("bizmode");
        Date bizDate = contract.getDate("biztime");
        if (org == null || type == null || conmProp == null) {
            if ("conm_purcontract".equals(e.getTargetDataEntity().getDataEntityType().toString())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u91c7\u8d2d\u7ec4\u7ec7\u3001\u5408\u540c\u7c7b\u578b\u548c\u5408\u540c\u5c5e\u6027\u5b57\u6bb5\u3002", (String)"ContractConvertPlugin_0", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
            }
            if ("conm_salcontract".equals(e.getTargetDataEntity().getDataEntityType().toString())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u9500\u552e\u7ec4\u7ec7\u3001\u5408\u540c\u7c7b\u578b\u548c\u5408\u540c\u5c5e\u6027\u5b57\u6bb5\u3002", (String)"ContractConvertPlugin_2", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
            }
        }
        if (ContractPropEnum.FRAMEAGREEMENT.getValue().equals(conmProp)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u5408\u540c\u5c5e\u6027\u4e3a\u6846\u67b6\u534f\u8bae\u65f6\uff0c\u65e0\u6cd5\u62c9\u5f0f\u751f\u6210\u3002", (String)"ContractConvertPlugin_1", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
        }
        List ContractIds = ContractValidHelper.getValidContractIds((String)e.getTargetDataEntity().getDataEntityType().toString(), (Date)bizDate);
        QFilter filter = new QFilter("id", "in", (Object)ContractIds);
        if (ContractPropEnum.CONTRACT.getValue().equals(conmProp)) {
            filter.and(new QFilter("validstatus", "=", (Object)BizValidStatusEnum.VALID.getValue()));
            filter.and(new QFilter("conmprop", "=", (Object)ContractPropEnum.FRAMEAGREEMENT.getValue()));
        }
        if (org != null) {
            QFilter orgFilter1 = new QFilter("suitscope", "=", (Object)ContractSuitScopeEnum.CURRENTORG.getValue()).and("org.id", "=", org.getPkValue());
            QFilter orgFilter2 = new QFilter("suitscope", "=", (Object)ContractSuitScopeEnum.ALLORG.getValue());
            QFilter orgFilter3 = new QFilter("suitscope", "=", (Object)ContractSuitScopeEnum.CHOSENORG.getValue()).and("suitentry.suitorg.id", "=", org.getPkValue());
            QFilter orgFilter = orgFilter1.or(orgFilter2).or(orgFilter3);
            filter.and(orgFilter);
        }
        if ("conm_purcontract".equals(e.getTargetDataEntity().getDataEntityType().toString()) && !CommonUtils.isNull((Object)(supplier = contract.getDynamicObject("supplier")))) {
            filter.and(new QFilter("supplier.id", "=", supplier.getPkValue()));
        }
        if ("conm_salcontract".equals(e.getTargetDataEntity().getDataEntityType().toString()) && !CommonUtils.isNull((Object)(customer = contract.getDynamicObject("customer")))) {
            filter.and(new QFilter("customer.id", "=", customer.getPkValue()));
        }
        if (org != null) {
            long orgId = (Long)org.getPkValue();
            String srcEntityName = this.getSrcMainType().getName();
            Object operatorGroupIsolate = AppParameterHelper.getAppParameterByFormId((String)srcEntityName, (Long)orgId, (String)"foperatorgroupisolate");
            if (Boolean.TRUE.equals(operatorGroupIsolate)) {
                ArrayList arList;
                ArrayList opGrpList;
                ArrayList validList;
                long userId = UserServiceHelper.getCurrentUserId();
                String grpType = "";
                if ("conm_purcontract".equals(srcEntityName)) {
                    grpType = "CGZ";
                } else if ("conm_salcontract".equals(srcEntityName)) {
                    grpType = "XSZ";
                }
                if (StringUtils.isNotEmpty((String)grpType) && !(validList = OperatorGroupHelper.getValidOperatorGroup((ArrayList)(opGrpList = OperatorGroupHelper.getOperatorGroupByOrg((long)orgId, (String)grpType)), (ArrayList)(arList = OperatorGroupHelper.getOperatorGroupByUser((long)orgId, (long)userId, (String)grpType)))).isEmpty()) {
                    filter.and(new QFilter("operatorgroup", "in", (Object)validList));
                }
            }
        }
        e.setPlugFilter(filter);
    }
}

