/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.formplugin.contract;

import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.conm.utils.CommonUtils;

public class ApplyOperatorGrpPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(ApplyOperatorGrpPlugin.class);

    public void registerListener(EventObject e) {
        BasedataEdit deptEdit;
        super.registerListener(e);
        BasedataEdit operatorEdit = (BasedataEdit)this.getView().getControl("bizuser");
        if (operatorEdit != null) {
            operatorEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((deptEdit = (BasedataEdit)this.getView().getControl("dept")) != null) {
            deptEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String billcretype = this.getPageCache().get("billcretype");
        if ("1".equals(billcretype)) {
            return;
        }
        IDataModel model = this.getModel();
        long userId = UserServiceHelper.getCurrentUserId();
        model.setValue("bizuser", (Object)userId);
        Long deptId = UserServiceHelper.getUserMainOrgId((long)userId);
        model.setValue("dept", (Object)deptId);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        String name = e.getProperty().getName();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (!"org".equals(name) && org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7533\u8bf7\u7ec4\u7ec7\u3002", (String)"ApplyOperatorGrpPlugin_0", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        switch (name) {
            case "dept": {
                List deptIDs = OrgUnitServiceHelper.getAllToOrg((String)"15", (String)"01", (Long)((Long)org.getPkValue()), (boolean)true);
                DynamicObject user = (DynamicObject)this.getModel().getValue("bizuser");
                if (user != null) {
                    Long userID = (Long)user.getPkValue();
                    Long deptID = UserServiceHelper.getUserMainOrgId((long)userID);
                    deptIDs.add(deptID);
                }
                QFilter qFilter = new QFilter("id", "in", (Object)deptIDs);
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!CommonUtils.isRealChanged((ChangeData)e.getChangeSet()[0])) {
            return;
        }
        String propName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (Objects.equals("bizuser", propName)) {
            DynamicObject operator = (DynamicObject)newValue;
            if (operator == null) {
                this.getModel().setValue("dept", null);
                return;
            }
            Long deptID = null;
            Long userID = (Long)operator.getPkValue();
            if (userID != null) {
                deptID = UserServiceHelper.getUserMainOrgId((long)userID);
            }
            this.getModel().setValue("dept", (Object)deptID);
        }
    }
}

